/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.AxisClientProxy;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;
import org.apache.axis.client.Transport;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.WSDLUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.w3c.dom.Document;

public class Service
implements javax.xml.rpc.Service,
Serializable,
Referenceable {
    private transient AxisEngine engine = null;
    private transient EngineConfiguration config = null;
    private QName serviceName = null;
    private String wsdlLocation = null;
    private javax.wsdl.Service wsdlService = null;
    private boolean maintainSession = false;
    private HandlerRegistryImpl registry = new HandlerRegistryImpl();
    private Parser wsdlParser = null;
    private static HashMap cachedWSDL = new HashMap();
    private static boolean cachingWSDL = true;
    protected Call _call = null;
    private Hashtable transportImpls = new Hashtable();

    protected javax.wsdl.Service getWSDLService() {
        return this.wsdlService;
    }

    public Parser getWSDLParser() {
        return this.wsdlParser;
    }

    protected AxisClient getAxisClient() {
        return new AxisClient(this.getEngineConfiguration());
    }

    public Service() {
        this.engine = this.getAxisClient();
    }

    public Service(QName qName) {
        this.serviceName = qName;
        this.engine = this.getAxisClient();
    }

    public Service(EngineConfiguration engineConfiguration, AxisClient axisClient) {
        this.config = engineConfiguration;
        this.engine = axisClient;
    }

    public Service(EngineConfiguration engineConfiguration) {
        this.config = engineConfiguration;
        this.engine = this.getAxisClient();
    }

    public Service(URL uRL, QName qName) throws ServiceException {
        this.serviceName = qName;
        this.engine = this.getAxisClient();
        this.wsdlLocation = uRL.toString();
        Parser parser2 = null;
        if (cachingWSDL && (parser2 = (Parser)cachedWSDL.get(this.wsdlLocation.toString())) != null) {
            this.initService(parser2, qName);
        } else {
            this.initService(uRL.toString(), qName);
        }
    }

    public Service(Parser parser2, QName qName) throws ServiceException {
        this.serviceName = qName;
        this.engine = this.getAxisClient();
        this.initService(parser2, qName);
    }

    public Service(String string, QName qName) throws ServiceException {
        this.serviceName = qName;
        this.wsdlLocation = string;
        this.engine = this.getAxisClient();
        Parser parser2 = null;
        if (cachingWSDL && (parser2 = (Parser)cachedWSDL.get(string)) != null) {
            this.initService(parser2, qName);
        } else {
            this.initService(string, qName);
        }
    }

    public Service(InputStream inputStream, QName qName) throws ServiceException {
        this.engine = this.getAxisClient();
        Document document = null;
        try {
            document = XMLUtils.newDocument(inputStream);
        }
        catch (Exception exception) {
            throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exception));
        }
        this.initService(null, document, qName);
    }

    private void initService(String string, QName qName) throws ServiceException {
        try {
            Parser parser2 = new Parser();
            parser2.run(string);
            if (cachingWSDL && this.wsdlLocation != null) {
                cachedWSDL.put(string, parser2);
            }
            this.initService(parser2, qName);
        }
        catch (Exception exception) {
            throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exception), exception);
        }
    }

    private void initService(String string, Document document, QName qName) throws ServiceException {
        try {
            Parser parser2 = new Parser();
            parser2.run(string, document);
            this.initService(parser2, qName);
        }
        catch (Exception exception) {
            throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exception));
        }
    }

    private void initService(Parser parser2, QName qName) throws ServiceException {
        try {
            this.wsdlParser = parser2;
            ServiceEntry serviceEntry = parser2.getSymbolTable().getServiceEntry(qName);
            if (serviceEntry != null) {
                this.wsdlService = serviceEntry.getService();
            }
            if (this.wsdlService == null) {
                throw new ServiceException(Messages.getMessage("noService00", "" + qName));
            }
        }
        catch (Exception exception) {
            throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exception));
        }
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(qName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + qName));
        }
        Remote remote = this.getGeneratedStub(qName, clazz);
        return remote != null ? remote : this.getPort(null, qName, clazz);
    }

    private Remote getGeneratedStub(QName qName, Class clazz) {
        try {
            String string = clazz.getName();
            string = string.substring(0, string.lastIndexOf(46));
            Port port = this.wsdlService.getPort(qName.getLocalPart());
            String string2 = port.getBinding().getQName().getLocalPart();
            Class clazz2 = ClassUtils.forName(string + "." + string2 + "Stub");
            if (clazz.isAssignableFrom(clazz2)) {
                Class[] classArray = new Class[]{javax.xml.rpc.Service.class};
                Object[] objectArray = new Object[]{this};
                Constructor constructor = clazz2.getConstructor(classArray);
                Stub stub = (Stub)constructor.newInstance(objectArray);
                stub._setProperty("javax.xml.rpc.service.endpoint.address", WSDLUtils.getAddressFromPort(port));
                stub.setPortName(qName);
                return (Remote)((Object)stub);
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Remote getPort(Class clazz) throws ServiceException {
        Remote remote;
        Port port;
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        Map map = this.wsdlService.getPorts();
        if (map == null || map.size() <= 0) {
            throw new ServiceException(Messages.getMessage("noPort00", ""));
        }
        String string = clazz.getName();
        if (string.lastIndexOf(46) != -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        if ((port = (Port)map.get(string)) == null) {
            port = (Port)map.values().iterator().next();
        }
        return (remote = this.getGeneratedStub(new QName(port.getName()), clazz)) != null ? remote : this.getPort(null, new QName(port.getName()), clazz);
    }

    public Remote getPort(String string, Class clazz) throws ServiceException {
        return this.getPort(string, null, clazz);
    }

    private Remote getPort(String string, QName qName, Class clazz) throws ServiceException {
        Object object;
        Object object2;
        Object object3;
        if (!clazz.isInterface()) {
            throw new ServiceException(Messages.getMessage("mustBeIface00"));
        }
        if (!Remote.class.isAssignableFrom(clazz)) {
            throw new ServiceException(Messages.getMessage("mustExtendRemote00"));
        }
        if (this.wsdlParser != null) {
            object3 = this.wsdlService.getPort(qName.getLocalPart());
            if (object3 == null) {
                throw new ServiceException(Messages.getMessage("noPort00", "" + clazz.getName()));
            }
            object2 = object3.getBinding();
            object = this.wsdlParser.getSymbolTable();
            BindingEntry bindingEntry = ((SymbolTable)object).getBindingEntry(object2.getQName());
            if (bindingEntry.getParameters().size() != clazz.getMethods().length) {
                throw new ServiceException(Messages.getMessage("incompatibleSEI00", "" + clazz.getName()));
            }
        }
        try {
            object3 = null;
            if (qName == null) {
                object3 = (Call)this.createCall();
                if (string != null) {
                    ((Call)object3).setTargetEndpointAddress(new URL(string));
                }
            } else {
                object3 = (Call)this.createCall(qName);
            }
            object2 = Thread.currentThread().getContextClassLoader();
            object = (javax.xml.rpc.Stub)Proxy.newProxyInstance((ClassLoader)object2, new Class[]{clazz, javax.xml.rpc.Stub.class}, (InvocationHandler)new AxisClientProxy((Call)object3, qName));
            if (object instanceof Stub) {
                ((Stub)object).setPortName(qName);
            }
            return (Remote)object;
        }
        catch (Exception exception) {
            throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exception));
        }
    }

    public javax.xml.rpc.Call createCall(QName qName) throws ServiceException {
        Call call = (Call)this.createCall();
        call.setPortName(qName);
        if (this.wsdlParser == null) {
            return call;
        }
        Port port = this.wsdlService.getPort(qName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + qName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new ServiceException(Messages.getMessage("noPortType00", "" + qName));
        }
        List list = port.getExtensibilityElements();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof SOAPAddress)) continue;
            try {
                SOAPAddress sOAPAddress = (SOAPAddress)e;
                URL uRL = new URL(sOAPAddress.getLocationURI());
                call.setTargetEndpointAddress(uRL);
                continue;
            }
            catch (Exception exception) {
                throw new ServiceException(Messages.getMessage("cantSetURI00", "" + exception));
            }
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName qName, String string) throws ServiceException {
        Call call = (Call)this.createCall();
        call.setOperation(qName, string);
        return call;
    }

    public javax.xml.rpc.Call createCall(QName qName, QName qName2) throws ServiceException {
        Call call = (Call)this.createCall();
        call.setOperation(qName, qName2);
        return call;
    }

    public javax.xml.rpc.Call createCall() throws ServiceException {
        this._call = new Call(this);
        return this._call;
    }

    public javax.xml.rpc.Call[] getCalls(QName qName) throws ServiceException {
        javax.xml.rpc.Call[] callArray;
        if (qName == null) {
            throw new ServiceException(Messages.getMessage("badPort00"));
        }
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(qName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + qName));
        }
        Binding binding = port.getBinding();
        SymbolTable symbolTable = this.wsdlParser.getSymbolTable();
        BindingEntry bindingEntry = symbolTable.getBindingEntry(binding.getQName());
        Iterator iterator = bindingEntry.getParameters().keySet().iterator();
        Vector<javax.xml.rpc.Call> vector = new Vector<javax.xml.rpc.Call>();
        while (iterator.hasNext()) {
            callArray = (javax.xml.rpc.Call[])iterator.next();
            javax.xml.rpc.Call call = this.createCall(QName.valueOf(port.getName()), QName.valueOf(callArray.getName()));
            vector.add(call);
        }
        callArray = new javax.xml.rpc.Call[vector.size()];
        vector.toArray(callArray);
        return callArray;
    }

    public HandlerRegistry getHandlerRegistry() {
        return this.registry;
    }

    public URL getWSDLDocumentLocation() {
        try {
            return new URL(this.wsdlLocation);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public QName getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        if (this.wsdlService == null) {
            return null;
        }
        QName qName = this.wsdlService.getQName();
        return new QName(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public Iterator getPorts() throws ServiceException {
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        if (this.wsdlService.getPorts() == null) {
            return new Vector().iterator();
        }
        Map map = this.wsdlService.getPorts();
        ArrayList<QName> arrayList = new ArrayList<QName>(map.size());
        for (Port port : map.values()) {
            arrayList.add(new QName(this.wsdlService.getQName().getNamespaceURI(), port.getName()));
        }
        return arrayList.iterator();
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) throws ServiceException {
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.engine.getTypeMappingRegistry();
    }

    public Reference getReference() {
        String string = this.getClass().getName();
        Reference reference = new Reference(string, "org.apache.axis.client.ServiceFactory", null);
        StringRefAddr stringRefAddr = null;
        if (!string.equals("org.apache.axis.client.Service")) {
            stringRefAddr = new StringRefAddr("service classname", string);
            reference.add(stringRefAddr);
        } else {
            QName qName;
            if (this.wsdlLocation != null) {
                stringRefAddr = new StringRefAddr("WSDL location", this.wsdlLocation.toString());
                reference.add(stringRefAddr);
            }
            if ((qName = this.getServiceName()) != null) {
                stringRefAddr = new StringRefAddr("service namespace", qName.getNamespaceURI());
                reference.add(stringRefAddr);
                stringRefAddr = new StringRefAddr("service local part", qName.getLocalPart());
                reference.add(stringRefAddr);
            }
        }
        if (this.maintainSession) {
            stringRefAddr = new StringRefAddr("maintain session", "true");
            reference.add(stringRefAddr);
        }
        return reference;
    }

    public void setEngine(AxisEngine axisEngine) {
        this.engine = axisEngine;
    }

    public AxisEngine getEngine() {
        return this.engine;
    }

    public void setEngineConfiguration(EngineConfiguration engineConfiguration) {
        this.config = engineConfiguration;
    }

    protected EngineConfiguration getEngineConfiguration() {
        if (this.config == null) {
            this.config = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        }
        return this.config;
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public Call getCall() throws ServiceException {
        return this._call;
    }

    public boolean getCacheWSDL() {
        return cachingWSDL;
    }

    public void setCacheWSDL(boolean bl) {
        cachingWSDL = bl;
    }

    void registerTransportForURL(URL uRL, Transport transport) {
        this.transportImpls.put(uRL.toString(), transport);
    }

    Transport getTransportForURL(URL uRL) {
        return (Transport)this.transportImpls.get(uRL.toString());
    }

    public void setTypeMappingVersion(String string) {
        ((TypeMappingRegistryImpl)this.getTypeMappingRegistry()).doRegisterFromVersion(string);
    }

    protected static class HandlerRegistryImpl
    implements HandlerRegistry {
        Map map = new HashMap();

        protected HandlerRegistryImpl() {
        }

        public List getHandlerChain(QName qName) {
            String string = qName.getLocalPart();
            ArrayList arrayList = (ArrayList)this.map.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.setHandlerChain(qName, arrayList);
            }
            return arrayList;
        }

        public void setHandlerChain(QName qName, List list) {
            this.map.put(qName.getLocalPart(), list);
        }
    }
}

