/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.Messages;

public abstract class Stub
implements javax.xml.rpc.Stub {
    protected Service service = null;
    protected boolean maintainSessionSet = false;
    protected boolean maintainSession = false;
    protected Properties cachedProperties = new Properties();
    protected String cachedUsername = null;
    protected String cachedPassword = null;
    protected URL cachedEndpoint = null;
    protected Integer cachedTimeout = null;
    protected QName cachedPortName = null;
    private Vector headers = new Vector();
    private Vector attachments = new Vector();
    private boolean firstCall = true;
    protected Call _call = null;

    protected boolean firstCall() {
        boolean bl = this.firstCall;
        this.firstCall = false;
        return bl;
    }

    public void _setProperty(String string, Object object) {
        if (string == null || object == null) {
            throw new JAXRPCException(Messages.getMessage(string == null ? "badProp03" : "badProp04"));
        }
        if (string.equals("javax.xml.rpc.security.auth.username")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.cachedUsername = (String)object;
        } else if (string.equals("javax.xml.rpc.security.auth.password")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.cachedPassword = (String)object;
        } else if (string.equals("javax.xml.rpc.service.endpoint.address")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            try {
                this.cachedEndpoint = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw new JAXRPCException(malformedURLException.getMessage());
            }
        } else if (string.equals("javax.xml.rpc.session.maintain")) {
            if (!(object instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
            }
            this.maintainSessionSet = true;
            this.maintainSession = (Boolean)object;
        } else {
            if (string.startsWith("java.") || string.startsWith("javax.")) {
                throw new JAXRPCException(Messages.getMessage("badProp05", string));
            }
            this.cachedProperties.put(string, object);
        }
    }

    public Object _getProperty(String string) {
        if (string == null) {
            throw new JAXRPCException(Messages.getMessage("badProp05", string));
        }
        if (string.equals("javax.xml.rpc.security.auth.username")) {
            return this.cachedUsername;
        }
        if (string.equals("javax.xml.rpc.security.auth.password")) {
            return this.cachedPassword;
        }
        if (string.equals("javax.xml.rpc.service.endpoint.address")) {
            return this.cachedEndpoint.toString();
        }
        if (string.equals("javax.xml.rpc.session.maintain")) {
            return this.maintainSessionSet ? (this.maintainSession ? Boolean.TRUE : Boolean.FALSE) : null;
        }
        if (string.startsWith("java.") || string.startsWith("javax.")) {
            throw new JAXRPCException(Messages.getMessage("badProp05", string));
        }
        return this.cachedProperties.get(string);
    }

    public Object removeProperty(String string) {
        return this.cachedProperties.remove(string);
    }

    public Iterator _getPropertyNames() {
        return this.cachedProperties.keySet().iterator();
    }

    public void setUsername(String string) {
        this.cachedUsername = string;
    }

    public String getUsername() {
        return this.cachedUsername;
    }

    public void setPassword(String string) {
        this.cachedPassword = string;
    }

    public String getPassword() {
        return this.cachedPassword;
    }

    public int getTimeout() {
        return this.cachedTimeout == null ? 0 : this.cachedTimeout;
    }

    public void setTimeout(int n) {
        this.cachedTimeout = new Integer(n);
    }

    public QName getPortName() {
        return this.cachedPortName;
    }

    public void setPortName(QName qName) {
        this.cachedPortName = qName;
    }

    public void setPortName(String string) {
        this.setPortName(new QName(string));
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSessionSet = true;
        this.maintainSession = bl;
        this.cachedProperties.put("javax.xml.rpc.session.maintain", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setHeader(String string, String string2, Object object) {
        this.headers.add(new SOAPHeaderElement(string, string2, object));
    }

    public void setHeader(SOAPHeaderElement sOAPHeaderElement) {
        this.headers.add(sOAPHeaderElement);
    }

    public void extractAttachments(Call call) {
        this.attachments.clear();
        if (call.getResponseMessage() != null) {
            Iterator iterator = call.getResponseMessage().getAttachments();
            while (iterator.hasNext()) {
                this.attachments.add(iterator.next());
            }
        }
    }

    public void addAttachment(Object object) {
        this.attachments.add(object);
    }

    public SOAPHeaderElement getHeader(String string, String string2) {
        for (int i = 0; i < this.headers.size(); ++i) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.headers.get(i);
            if (!sOAPHeaderElement.getNamespaceURI().equals(string) || !sOAPHeaderElement.getName().equals(string2)) continue;
            return sOAPHeaderElement;
        }
        return null;
    }

    public SOAPHeaderElement getResponseHeader(String string, String string2) {
        try {
            if (this._call == null) {
                return null;
            }
            return this._call.getResponseMessage().getSOAPEnvelope().getHeaderByName(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SOAPHeaderElement[] getHeaders() {
        Object[] objectArray = new SOAPHeaderElement[this.headers.size()];
        this.headers.copyInto(objectArray);
        return objectArray;
    }

    public SOAPHeaderElement[] getResponseHeaders() {
        Object[] objectArray = new SOAPHeaderElement[]{};
        try {
            if (this._call == null) {
                return objectArray;
            }
            Vector vector = this._call.getResponseMessage().getSOAPEnvelope().getHeaders();
            objectArray = new SOAPHeaderElement[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return objectArray;
        }
    }

    public Object[] getAttachments() {
        Object[] objectArray = new Object[this.attachments.size()];
        this.attachments.copyInto(objectArray);
        this.attachments.clear();
        return objectArray;
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    protected void setRequestHeaders(Call call) throws AxisFault {
        SOAPHeaderElement[] sOAPHeaderElementArray = this.getHeaders();
        for (int i = 0; i < sOAPHeaderElementArray.length; ++i) {
            call.addHeader(sOAPHeaderElementArray[i]);
        }
    }

    protected void setAttachments(Call call) throws AxisFault {
        Object[] objectArray = this.getAttachments();
        for (int i = 0; i < objectArray.length; ++i) {
            call.addAttachmentPart(objectArray[i]);
        }
        this.clearAttachments();
    }

    public Service _getService() {
        return this.service;
    }

    public Call _createCall() throws ServiceException {
        this._call = (Call)this.service.createCall();
        return this._call;
    }

    public Call _getCall() {
        return this._call;
    }

    protected void getResponseHeaders(Call call) throws AxisFault {
    }
}

