/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.components.encoding.DefaultXMLEncoder;
import org.apache.axis.components.encoding.UTF16Encoder;
import org.apache.axis.components.encoding.UTF8Encoder;
import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.apache.commons.logging.Log;

public class XMLEncoderFactory {
    protected static Log log = LogFactory.getLog(XMLEncoderFactory.class.getName());
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_UTF_16 = "UTF-16";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static Map encoderMap = new HashMap();
    private static final String PLUGABLE_PROVIDER_FILENAME = "org.apache.axis.components.encoding.XMLEncoder";

    public static XMLEncoder getDefaultEncoder() {
        try {
            return XMLEncoderFactory.getEncoder("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(Messages.getMessage("unsupportedDefaultEncoding00", "UTF-8"));
        }
    }

    public static XMLEncoder getEncoder(String string) throws UnsupportedEncodingException {
        XMLEncoder xMLEncoder = (XMLEncoder)encoderMap.get(string);
        if (xMLEncoder == null) {
            xMLEncoder = new DefaultXMLEncoder(string);
            encoderMap.put(string, xMLEncoder);
        }
        return xMLEncoder;
    }

    private static void loadPluggableEncoders() {
        ClassLoader classLoader = XMLEncoder.class.getClassLoader();
        ClassLoaders classLoaders = new ClassLoaders();
        classLoaders.put(classLoader);
        DiscoverServiceNames discoverServiceNames = new DiscoverServiceNames(classLoaders);
        ResourceNameIterator resourceNameIterator = discoverServiceNames.findResourceNames(PLUGABLE_PROVIDER_FILENAME);
        while (resourceNameIterator.hasNext()) {
            Object object;
            String string = resourceNameIterator.nextResourceName();
            try {
                Object obj = Class.forName(string).newInstance();
                if (!(obj instanceof XMLEncoder)) continue;
                object = (XMLEncoder)obj;
                encoderMap.put(object.getEncoding(), object);
                encoderMap.put(object.getEncoding().toLowerCase(), object);
            }
            catch (Exception exception) {
                object = exception + JavaUtils.LS + JavaUtils.stackToString(exception);
                log.info(Messages.getMessage("exception01", (String)object));
            }
        }
    }

    static {
        encoderMap.put("UTF-8", new UTF8Encoder());
        encoderMap.put(ENCODING_UTF_16, new UTF16Encoder());
        encoderMap.put("UTF-8".toLowerCase(), new UTF8Encoder());
        encoderMap.put(ENCODING_UTF_16.toLowerCase(), new UTF16Encoder());
        try {
            XMLEncoderFactory.loadPluggableEncoders();
        }
        catch (Throwable throwable) {
            String string = throwable + JavaUtils.LS + JavaUtils.stackToString(throwable);
            log.info(Messages.getMessage("exception01", string));
        }
    }
}

