/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.jms;

import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.transport.jms.JMSURLHelper;

public class JNDIVendorAdapter
extends JMSVendorAdapter {
    public static final String CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String _CONNECTION_FACTORY_JNDI_NAME = "ConnectionFactoryJNDIName";
    public static final String CONNECTION_FACTORY_JNDI_NAME = "transport.jms.ConnectionFactoryJNDIName";
    private Context context;

    public QueueConnectionFactory getQueueConnectionFactory(HashMap hashMap) throws Exception {
        return (QueueConnectionFactory)this.getConnectionFactory(hashMap);
    }

    public TopicConnectionFactory getTopicConnectionFactory(HashMap hashMap) throws Exception {
        return (TopicConnectionFactory)this.getConnectionFactory(hashMap);
    }

    private ConnectionFactory getConnectionFactory(HashMap hashMap) throws Exception {
        String string;
        if (hashMap == null) {
            throw new IllegalArgumentException("noCFProps");
        }
        String string2 = (String)hashMap.get(CONNECTION_FACTORY_JNDI_NAME);
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("noCFName");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(hashMap);
        String string3 = (String)hashMap.get(CONTEXT_FACTORY);
        if (string3 != null) {
            hashtable.put(CONTEXT_FACTORY, string3);
        }
        if ((string = (String)hashMap.get(PROVIDER_URL)) != null) {
            hashtable.put(PROVIDER_URL, string);
        }
        this.context = new InitialContext(hashtable);
        return (ConnectionFactory)this.context.lookup(string2);
    }

    public void addVendorConnectionFactoryProperties(JMSURLHelper jMSURLHelper, HashMap hashMap) {
        String string;
        String string2;
        String string3 = jMSURLHelper.getPropertyValue(_CONNECTION_FACTORY_JNDI_NAME);
        if (string3 != null) {
            hashMap.put(CONNECTION_FACTORY_JNDI_NAME, string3);
        }
        if ((string2 = jMSURLHelper.getPropertyValue(CONTEXT_FACTORY)) != null) {
            hashMap.put(CONTEXT_FACTORY, string2);
        }
        if ((string = jMSURLHelper.getPropertyValue(PROVIDER_URL)) != null) {
            hashMap.put(PROVIDER_URL, string);
        }
    }

    public boolean isMatchingConnectionFactory(ConnectionFactory connectionFactory, JMSURLHelper jMSURLHelper, HashMap hashMap) {
        String string;
        JMSURLHelper jMSURLHelper2 = (JMSURLHelper)hashMap.get("transport.jms.EndpointAddress");
        String string2 = jMSURLHelper2.getPropertyValue(_CONNECTION_FACTORY_JNDI_NAME);
        return string2.equalsIgnoreCase(string = jMSURLHelper.getPropertyValue(_CONNECTION_FACTORY_JNDI_NAME));
    }

    public Queue getQueue(QueueSession queueSession, String string) throws Exception {
        return (Queue)this.context.lookup(string);
    }

    public Topic getTopic(TopicSession topicSession, String string) throws Exception {
        return (Topic)this.context.lookup(string);
    }
}

