/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.util.Hashtable;
import org.apache.axis.AxisProperties;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.SocketFactory;
import org.apache.commons.logging.Log;

public class SocketFactoryFactory {
    protected static Log log = LogFactory.getLog(SocketFactoryFactory.class.getName());
    private static Hashtable factories = new Hashtable();
    private static final Class[] classes = new Class[]{Hashtable.class};

    public static synchronized SocketFactory getFactory(String string, Hashtable hashtable) {
        SocketFactory socketFactory = (SocketFactory)factories.get(string);
        if (socketFactory == null) {
            Object[] objectArray = new Object[]{hashtable};
            if (string.equalsIgnoreCase("http")) {
                socketFactory = (SocketFactory)AxisProperties.newInstance(SocketFactory.class, classes, objectArray);
            } else if (string.equalsIgnoreCase("https")) {
                socketFactory = (SecureSocketFactory)AxisProperties.newInstance(SecureSocketFactory.class, classes, objectArray);
            }
            if (socketFactory != null) {
                factories.put(string, socketFactory);
            }
        }
        return socketFactory;
    }

    static {
        AxisProperties.setClassOverrideProperty(SocketFactory.class, "axis.socketFactory");
        AxisProperties.setClassDefault(SocketFactory.class, "org.apache.axis.components.net.DefaultSocketFactory");
        AxisProperties.setClassOverrideProperty(SecureSocketFactory.class, "axis.socketSecureFactory");
        AxisProperties.setClassDefault(SecureSocketFactory.class, "org.apache.axis.components.net.JSSESocketFactory");
    }
}

