/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.logging.Log;

public class EngineConfigurationFactoryFinder {
    protected static Log log = LogFactory.getLog(EngineConfigurationFactoryFinder.class.getName());
    private static final Class mySpi = EngineConfigurationFactory.class;
    private static final Class[] newFactoryParamTypes = new Class[]{Object.class};
    private static final String requiredMethod = "public static EngineConfigurationFactory newFactory(Object)";

    private EngineConfigurationFactoryFinder() {
    }

    public static EngineConfigurationFactory newFactory(Object object) {
        final Object[] objectArray = new Object[]{object};
        return (EngineConfigurationFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator resourceClassIterator = AxisProperties.getResourceClassIterator(mySpi);
                Object object = null;
                while (object == null && resourceClassIterator.hasNext()) {
                    try {
                        Class clazz = resourceClassIterator.nextResourceClass().loadClass();
                        if (clazz == null) continue;
                        object = EngineConfigurationFactoryFinder.newFactory(clazz, newFactoryParamTypes, objectArray);
                    }
                    catch (Exception exception) {}
                }
                if (object != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("engineFactory", object.getClass().getName()));
                    }
                } else {
                    log.error(Messages.getMessage("engineConfigFactoryMissing"));
                }
                return object;
            }
        });
    }

    public static EngineConfigurationFactory newFactory() {
        return EngineConfigurationFactoryFinder.newFactory(null);
    }

    private static EngineConfigurationFactory newFactory(Class clazz, Class[] classArray, Object[] objectArray) {
        block8: {
            try {
                Method method = ClassUtils.findPublicStaticMethod(clazz, EngineConfigurationFactory.class, "newFactory", classArray);
                if (method == null) {
                    log.warn(Messages.getMessage("engineConfigMissingNewFactory", clazz.getName(), requiredMethod));
                    break block8;
                }
                try {
                    return (EngineConfigurationFactory)method.invoke(null, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof NoClassDefFoundError) {
                        log.debug(Messages.getMessage("engineConfigLoadFactory", clazz.getName()));
                    } else {
                        log.warn(Messages.getMessage("engineConfigInvokeNewFactory", clazz.getName(), requiredMethod), invocationTargetException);
                    }
                }
                catch (Exception exception) {
                    log.warn(Messages.getMessage("engineConfigInvokeNewFactory", clazz.getName(), requiredMethod), exception);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                log.debug(Messages.getMessage("engineConfigLoadFactory", clazz.getName()));
            }
        }
        return null;
    }

    static {
        AxisProperties.setClassOverrideProperty(EngineConfigurationFactory.class, "axis.EngineConfigFactory");
        AxisProperties.setClassDefaults(EngineConfigurationFactory.class, new String[]{"org.apache.axis.configuration.EngineConfigurationFactoryServlet", "org.apache.axis.configuration.EngineConfigurationFactoryDefault"});
    }
}

