/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.handlers.soap.SOAPService;

public class SimpleProvider
implements EngineConfiguration {
    HashMap handlers = new HashMap();
    HashMap transports = new HashMap();
    HashMap services = new HashMap();
    Hashtable globalOptions = null;
    Handler globalRequest = null;
    Handler globalResponse = null;
    List roles = new ArrayList();
    TypeMappingRegistry tmr = null;
    EngineConfiguration defaultConfiguration = null;
    private AxisEngine engine;

    public SimpleProvider() {
    }

    public SimpleProvider(EngineConfiguration engineConfiguration) {
        this.defaultConfiguration = engineConfiguration;
    }

    public SimpleProvider(TypeMappingRegistry typeMappingRegistry) {
        this.tmr = typeMappingRegistry;
    }

    public void configureEngine(AxisEngine axisEngine) throws ConfigurationException {
        this.engine = axisEngine;
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.configureEngine(axisEngine);
        }
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            ((SOAPService)iterator.next()).setEngine(axisEngine);
        }
    }

    public void writeEngineConfig(AxisEngine axisEngine) throws ConfigurationException {
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        if (this.globalOptions != null) {
            return this.globalOptions;
        }
        if (this.defaultConfiguration != null) {
            return this.defaultConfiguration.getGlobalOptions();
        }
        return null;
    }

    public void setGlobalOptions(Hashtable hashtable) {
        this.globalOptions = hashtable;
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        if (this.globalRequest != null) {
            return this.globalRequest;
        }
        if (this.defaultConfiguration != null) {
            return this.defaultConfiguration.getGlobalRequest();
        }
        return null;
    }

    public void setGlobalRequest(Handler handler) {
        this.globalRequest = handler;
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        if (this.globalResponse != null) {
            return this.globalResponse;
        }
        if (this.defaultConfiguration != null) {
            return this.defaultConfiguration.getGlobalResponse();
        }
        return null;
    }

    public void setGlobalResponse(Handler handler) {
        this.globalResponse = handler;
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (this.tmr != null) {
            return this.tmr;
        }
        if (this.defaultConfiguration != null) {
            return this.defaultConfiguration.getTypeMappingRegistry();
        }
        this.tmr = new TypeMappingRegistryImpl();
        return this.tmr;
    }

    public TypeMapping getTypeMapping(String string) throws ConfigurationException {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(string);
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        Handler handler = (Handler)this.transports.get(qName);
        if (this.defaultConfiguration != null && handler == null) {
            handler = this.defaultConfiguration.getTransport(qName);
        }
        return handler;
    }

    public SOAPService getService(QName qName) throws ConfigurationException {
        SOAPService sOAPService = (SOAPService)this.services.get(qName);
        if (this.defaultConfiguration != null && sOAPService == null) {
            sOAPService = this.defaultConfiguration.getService(qName);
        }
        return sOAPService;
    }

    public SOAPService getServiceByNamespaceURI(String string) throws ConfigurationException {
        SOAPService sOAPService = (SOAPService)this.services.get(new QName("", string));
        if (sOAPService == null && this.defaultConfiguration != null) {
            sOAPService = this.defaultConfiguration.getServiceByNamespaceURI(string);
        }
        return sOAPService;
    }

    public Handler getHandler(QName qName) throws ConfigurationException {
        Handler handler = (Handler)this.handlers.get(qName);
        if (this.defaultConfiguration != null && handler == null) {
            handler = this.defaultConfiguration.getHandler(qName);
        }
        return handler;
    }

    public void deployService(QName qName, SOAPService sOAPService) {
        this.services.put(qName, sOAPService);
        if (this.engine != null) {
            sOAPService.setEngine(this.engine);
        }
    }

    public void deployService(String string, SOAPService sOAPService) {
        this.deployService(new QName(null, string), sOAPService);
    }

    public void deployTransport(QName qName, Handler handler) {
        this.transports.put(qName, handler);
    }

    public void deployTransport(String string, Handler handler) {
        this.deployTransport(new QName(null, string), handler);
    }

    public Iterator getDeployedServices() throws ConfigurationException {
        ArrayList<ServiceDesc> arrayList = new ArrayList<ServiceDesc>();
        for (SOAPService sOAPService : this.services.values()) {
            arrayList.add(sOAPService.getServiceDescription());
        }
        return arrayList.iterator();
    }

    public void setRoles(List list) {
        this.roles = list;
    }

    public void addRole(String string) {
        this.roles.add(string);
    }

    public void removeRole(String string) {
        this.roles.remove(string);
    }

    public List getRoles() {
        return this.roles;
    }
}

