/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.constants;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public abstract class Enum
implements Serializable {
    private static final Hashtable types = new Hashtable(13);
    protected static Log log = LogFactory.getLog(Enum.class.getName());
    private final Type type;
    public final int value;
    public final String name;

    protected Enum(Type type, int n, String string) {
        this.type = type;
        this.value = n;
        this.name = string.intern();
    }

    public final int getValue() {
        return this.value;
    }

    public final String getName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object object) {
        return object != null && object instanceof Enum ? this._equals((Enum)object) : false;
    }

    public int hashCode() {
        return this.value;
    }

    public final boolean equals(Enum enum_) {
        return enum_ != null ? this._equals(enum_) : false;
    }

    private final boolean _equals(Enum enum_) {
        return enum_.type == this.type && enum_.value == this.value;
    }

    public static abstract class Type
    implements Serializable {
        private final String name;
        private final Enum[] enums;
        private Enum dephault = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Type(String string, Enum[] enumArray) {
            this.name = string.intern();
            this.enums = enumArray;
            Hashtable hashtable = types;
            synchronized (hashtable) {
                types.put(string, this);
            }
        }

        public void setDefault(Enum enum_) {
            this.dephault = enum_;
        }

        public Enum getDefault() {
            return this.dephault;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isValid(String string) {
            for (int i = 0; i < this.enums.length; ++i) {
                if (!this.enums[i].getName().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        public final int size() {
            return this.enums.length;
        }

        public final String[] getEnumNames() {
            String[] stringArray = new String[this.size()];
            for (int i = 0; i < this.enums.length; ++i) {
                stringArray[i] = this.enums[i].getName();
            }
            return stringArray;
        }

        public final Enum getEnum(int n) {
            return n >= 0 && n < this.enums.length ? this.enums[n] : null;
        }

        public final Enum getEnum(String string) {
            Enum enum_ = this.getEnum(string, null);
            if (enum_ == null) {
                log.error(Messages.getMessage("badEnum02", this.name, string));
            }
            return enum_;
        }

        public final Enum getEnum(String string, Enum enum_) {
            if (string != null && string.length() > 0) {
                for (int i = 0; i < this.enums.length; ++i) {
                    Enum enum_2 = this.enums[i];
                    if (!enum_2.getName().equalsIgnoreCase(string)) continue;
                    return enum_2;
                }
            }
            return enum_;
        }

        private Object readResolve() throws ObjectStreamException {
            Object object = types.get(this.name);
            if (object == null) {
                object = this;
                types.put(this.name, object);
            }
            return object;
        }
    }
}

