/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.encoding.SerializationContext;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDChain
extends WSDDHandler {
    private Vector handlers = new Vector();

    public WSDDChain() {
    }

    public WSDDChain(Element element) throws WSDDException {
        super(element);
        WSDDHandler wSDDHandler;
        int n;
        if (this.type != null) {
            return;
        }
        Element[] elementArray = this.getChildElements(element, "handler");
        if (elementArray.length != 0) {
            for (n = 0; n < elementArray.length; ++n) {
                wSDDHandler = new WSDDHandler(elementArray[n]);
                this.addHandler(wSDDHandler);
            }
        }
        if ((elementArray = this.getChildElements(element, "chain")).length != 0) {
            for (n = 0; n < elementArray.length; ++n) {
                wSDDHandler = new WSDDChain(elementArray[n]);
                this.addHandler(wSDDHandler);
            }
        }
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_CHAIN;
    }

    public void addHandler(WSDDHandler wSDDHandler) {
        this.handlers.add(wSDDHandler);
    }

    public Vector getHandlers() {
        return this.handlers;
    }

    public void removeHandler(WSDDHandler wSDDHandler) {
        this.handlers.remove(wSDDHandler);
    }

    public Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        SimpleChain simpleChain = new SimpleChain();
        for (int i = 0; i < this.handlers.size(); ++i) {
            WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(i);
            Handler handler = wSDDHandler.getInstance(engineConfiguration);
            if (handler == null) {
                throw new ConfigurationException("Can't find handler name:'" + wSDDHandler.getQName() + "' type:'" + wSDDHandler.getType() + "' in the registry");
            }
            simpleChain.addHandler(handler);
        }
        return simpleChain;
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        QName qName = this.getQName();
        if (qName != null) {
            attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.qName2String(qName));
        }
        if (this.getType() != null) {
            attributesImpl.addAttribute("", "type", "type", "CDATA", serializationContext.qName2String(this.getType()));
        }
        serializationContext.startElement(this.getElementName(), attributesImpl);
        for (int i = 0; i < this.handlers.size(); ++i) {
            WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(i);
            wSDDHandler.writeToContext(serializationContext);
        }
        serializationContext.endElement();
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) {
        if (this.getQName() != null) {
            wSDDDeployment.addHandler(this);
        }
        for (int i = 0; i < this.handlers.size(); ++i) {
            WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(i);
            if (wSDDHandler.getQName() == null) continue;
            wSDDHandler.deployToRegistry(wSDDDeployment);
        }
    }
}

