/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.axis.ConfigurationException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDUndeployment;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDDDocument
extends WSDDConstants {
    protected static Log log = LogFactory.getLog(WSDDDocument.class.getName());
    private Document doc;
    private WSDDDeployment deployment;
    private WSDDUndeployment undeployment;

    public WSDDDocument() {
    }

    public WSDDDocument(Document document) throws WSDDException {
        this.setDocument(document);
    }

    public WSDDDocument(Element element) throws WSDDException {
        this.doc = element.getOwnerDocument();
        if ("undeployment".equals(element.getLocalName())) {
            this.undeployment = new WSDDUndeployment(element);
        } else {
            this.deployment = new WSDDDeployment(element);
        }
    }

    public WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new WSDDDeployment();
        }
        return this.deployment;
    }

    public Document getDOMDocument() throws ConfigurationException {
        StringWriter stringWriter = new StringWriter();
        SerializationContext serializationContext = new SerializationContext(stringWriter, null);
        serializationContext.setPretty(true);
        try {
            this.deployment.writeToContext(serializationContext);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
        }
        try {
            stringWriter.close();
            return XMLUtils.newDocument(new InputSource(new StringReader(stringWriter.getBuffer().toString())));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        this.getDeployment().writeToContext(serializationContext);
    }

    public void setDocument(Document document) throws WSDDException {
        this.doc = document;
        Element element = this.doc.getDocumentElement();
        if ("undeployment".equals(element.getLocalName())) {
            this.undeployment = new WSDDUndeployment(element);
        } else {
            this.deployment = new WSDDDeployment(element);
        }
    }

    public void deploy(WSDDDeployment wSDDDeployment) throws ConfigurationException {
        if (this.deployment != null) {
            this.deployment.deployToRegistry(wSDDDeployment);
        }
        if (this.undeployment != null) {
            this.undeployment.undeployFromRegistry(wSDDDeployment);
        }
    }
}

