/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Use;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.message.EnvelopeBuilder;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.IDResolver;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.NullAttributes;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.utils.cache.MethodCache;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DeserializationContext
extends DefaultHandler
implements javax.xml.rpc.encoding.DeserializationContext,
LexicalHandler {
    protected static Log log = LogFactory.getLog(DeserializationContext.class.getName());
    private final boolean debugEnabled = log.isDebugEnabled();
    static final SchemaVersion[] schemaVersions = new SchemaVersion[]{SchemaVersion.SCHEMA_1999, SchemaVersion.SCHEMA_2000, SchemaVersion.SCHEMA_2001};
    private NSStack namespaces = new NSStack();
    private Locator locator;
    private Class destClass;
    private SOAPHandler topHandler = null;
    private ArrayList pushedDownHandlers = new ArrayList();
    private SAX2EventRecorder recorder = null;
    private SOAPEnvelope envelope;
    private HashMap idMap;
    private LocalIDResolver localIDs;
    private HashMap fixups;
    static final SOAPHandler nullHandler = new SOAPHandler();
    protected MessageContext msgContext;
    private boolean doneParsing = false;
    protected InputSource inputSource = null;
    private MessageElement curElement;
    protected int startOfMappingsPos = -1;
    private static final Class[] DESERIALIZER_CLASSES = new Class[]{String.class, Class.class, QName.class};
    private static final String DESERIALIZER_METHOD = "getDeserializer";
    protected boolean haveSeenSchemaNS = false;
    private SOAPConstants soapConstants = null;
    boolean processingRef = false;
    private static final NullLexicalHandler nullLexicalHandler = new NullLexicalHandler();

    public void deserializing(boolean bl) {
        this.doneParsing = bl;
    }

    public DeserializationContext(MessageContext messageContext, SOAPHandler sOAPHandler) {
        this.msgContext = messageContext;
        if (messageContext == null || messageContext.isHighFidelity()) {
            this.recorder = new SAX2EventRecorder();
        }
        if (sOAPHandler instanceof EnvelopeBuilder) {
            this.envelope = ((EnvelopeBuilder)sOAPHandler).getEnvelope();
            this.envelope.setRecorder(this.recorder);
        }
        this.pushElementHandler(new EnvelopeHandler(sOAPHandler));
    }

    public DeserializationContext(InputSource inputSource, MessageContext messageContext, String string) {
        this.msgContext = messageContext;
        EnvelopeBuilder envelopeBuilder = new EnvelopeBuilder(string, null);
        if (messageContext == null || messageContext.isHighFidelity()) {
            this.recorder = new SAX2EventRecorder();
        }
        this.envelope = envelopeBuilder.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(envelopeBuilder));
        this.inputSource = inputSource;
    }

    public SOAPConstants getSOAPConstants() {
        if (this.soapConstants != null) {
            return this.soapConstants;
        }
        if (this.msgContext != null) {
            this.soapConstants = this.msgContext.getSOAPConstants();
            return this.soapConstants;
        }
        return Constants.DEFAULT_SOAP_VERSION;
    }

    public DeserializationContext(InputSource inputSource, MessageContext messageContext, String string, SOAPEnvelope sOAPEnvelope) {
        EnvelopeBuilder envelopeBuilder = new EnvelopeBuilder(sOAPEnvelope, string);
        this.msgContext = messageContext;
        if (messageContext == null || messageContext.isHighFidelity()) {
            this.recorder = new SAX2EventRecorder();
        }
        this.envelope = envelopeBuilder.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(envelopeBuilder));
        this.inputSource = inputSource;
    }

    public void parse() throws SAXException {
        if (this.inputSource != null) {
            SAXParser sAXParser = XMLUtils.getSAXParser();
            try {
                sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                sAXParser.parse(this.inputSource, (DefaultHandler)this);
                try {
                    sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", nullLexicalHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                XMLUtils.releaseSAXParser(sAXParser);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.inputSource = null;
        }
    }

    public MessageElement getCurElement() {
        return this.curElement;
    }

    public void setCurElement(MessageElement messageElement) {
        this.curElement = messageElement;
        if (this.curElement != null && this.curElement.getRecorder() != this.recorder) {
            this.recorder = this.curElement.getRecorder();
        }
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public String getEncodingStyle() {
        return this.msgContext == null ? Use.ENCODED.getEncoding() : this.msgContext.getEncodingStyle();
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder sAX2EventRecorder) {
        this.recorder = sAX2EventRecorder;
    }

    public ArrayList getCurrentNSMappings() {
        return this.namespaces.cloneFrame();
    }

    public String getNamespaceURI(String string) {
        String string2 = this.namespaces.getNamespaceURI(string);
        if (string2 != null) {
            return string2;
        }
        if (this.curElement != null) {
            return this.curElement.getNamespaceURI(string);
        }
        return null;
    }

    public QName getQNameFromString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        String string2 = n == -1 ? this.getNamespaceURI("") : this.getNamespaceURI(string.substring(0, n));
        return new QName(string2, string.substring(n + 1));
    }

    public QName getTypeFromXSITypeAttr(String string, String string2, Attributes attributes) {
        String string3 = Constants.getValue(attributes, Constants.URIS_SCHEMA_XSI, "type");
        if (string3 != null) {
            return this.getQNameFromString(string3);
        }
        return null;
    }

    public QName getTypeFromAttributes(String string, String string2, Attributes attributes) {
        QName qName = this.getTypeFromXSITypeAttr(string, string2, attributes);
        if (qName == null && Constants.isSOAP_ENC(string)) {
            if (string.equals("http://www.w3.org/2003/05/soap-encoding")) {
                qName = new QName(string, string2);
            } else if (string2.equals(Constants.SOAP_ARRAY.getLocalPart())) {
                qName = Constants.SOAP_ARRAY;
            } else if (string2.equals(Constants.SOAP_STRING.getLocalPart())) {
                qName = Constants.SOAP_STRING;
            } else if (string2.equals(Constants.SOAP_BOOLEAN.getLocalPart())) {
                qName = Constants.SOAP_BOOLEAN;
            } else if (string2.equals(Constants.SOAP_DOUBLE.getLocalPart())) {
                qName = Constants.SOAP_DOUBLE;
            } else if (string2.equals(Constants.SOAP_FLOAT.getLocalPart())) {
                qName = Constants.SOAP_FLOAT;
            } else if (string2.equals(Constants.SOAP_INT.getLocalPart())) {
                qName = Constants.SOAP_INT;
            } else if (string2.equals(Constants.SOAP_LONG.getLocalPart())) {
                qName = Constants.SOAP_LONG;
            } else if (string2.equals(Constants.SOAP_SHORT.getLocalPart())) {
                qName = Constants.SOAP_SHORT;
            } else if (string2.equals(Constants.SOAP_BYTE.getLocalPart())) {
                qName = Constants.SOAP_BYTE;
            }
        }
        if (qName == null && attributes != null) {
            String string3 = this.getSOAPConstants().getEncodingURI();
            String string4 = this.getSOAPConstants().getAttrItemType();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!string3.equals(attributes.getURI(i)) || !string4.equals(attributes.getLocalName(i))) continue;
                return new QName(string3, "Array");
            }
        }
        return qName;
    }

    public boolean isNil(Attributes attributes) {
        return JavaUtils.isTrueExplicitly(Constants.getValue(attributes, Constants.QNAMES_NIL), false);
    }

    public final Deserializer getDeserializer(Class clazz, QName qName) {
        if (qName == null) {
            return null;
        }
        DeserializerFactory deserializerFactory = null;
        Deserializer deserializer = null;
        try {
            deserializerFactory = (DeserializerFactory)this.getTypeMapping().getDeserializer(clazz, qName);
        }
        catch (JAXRPCException jAXRPCException) {
            log.error(Messages.getMessage("noFactory00", qName.toString()));
        }
        if (deserializerFactory != null) {
            try {
                deserializer = (Deserializer)deserializerFactory.getDeserializerAs("Axis SAX Mechanism");
            }
            catch (JAXRPCException jAXRPCException) {
                log.error(Messages.getMessage("noDeser00", qName.toString()));
            }
        }
        return deserializer;
    }

    public Deserializer getDeserializerForClass(Class clazz) {
        if (clazz == null) {
            clazz = this.destClass;
        }
        if (clazz == null) {
            return null;
        }
        if (Holder.class.isAssignableFrom(clazz)) {
            try {
                clazz = clazz.getField("value").getType();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Deserializer deserializer = null;
        QName qName = this.getTypeMapping().getTypeQName(clazz);
        deserializer = this.getDeserializer(clazz, qName);
        if (deserializer != null) {
            return deserializer;
        }
        try {
            TypeDesc typeDesc;
            Method method = MethodCache.getInstance().getMethod(clazz, DESERIALIZER_METHOD, DESERIALIZER_CLASSES);
            if (method != null && (typeDesc = TypeDesc.getTypeDescForClass(clazz)) != null) {
                deserializer = (Deserializer)method.invoke(null, this.getEncodingStyle(), clazz, typeDesc.getXmlType());
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("noDeser00", clazz.getName()));
        }
        return deserializer;
    }

    public void setDestinationClass(Class clazz) {
        this.destClass = clazz;
    }

    public Class getDestinationClass() {
        return this.destClass;
    }

    public final Deserializer getDeserializerForType(QName qName) {
        return this.getDeserializer(null, qName);
    }

    public TypeMapping getTypeMapping() {
        if (this.msgContext == null || this.msgContext.getTypeMappingRegistry() == null) {
            return (TypeMapping)new TypeMappingRegistryImpl().getTypeMapping(null);
        }
        TypeMappingRegistry typeMappingRegistry = this.msgContext.getTypeMappingRegistry();
        return (TypeMapping)typeMappingRegistry.getTypeMapping(this.getEncodingStyle());
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.msgContext.getTypeMappingRegistry();
    }

    public MessageElement getElementByID(String string) {
        Object object;
        IDResolver iDResolver;
        if (this.idMap != null && (iDResolver = (IDResolver)this.idMap.get(string)) != null && (object = iDResolver.getReferencedObject(string)) instanceof MessageElement) {
            return (MessageElement)object;
        }
        return null;
    }

    public Object getObjectByRef(String string) {
        Object object = null;
        if (string != null) {
            Object object2;
            if (this.idMap != null && (object2 = (IDResolver)this.idMap.get(string)) != null) {
                object = object2.getReferencedObject(string);
            }
            if (null == object && !string.startsWith("#")) {
                object2 = null;
                object2 = this.msgContext.getCurrentMessage();
                if (null != object2) {
                    Attachments attachments = null;
                    attachments = ((Message)object2).getAttachmentsImpl();
                    if (null != attachments) {
                        try {
                            object = attachments.getAttachmentByReference(string);
                        }
                        catch (AxisFault axisFault) {
                            throw new RuntimeException(axisFault.toString() + JavaUtils.stackToString(axisFault));
                        }
                    }
                }
            }
        }
        return object;
    }

    public void addObjectById(String string, Object object) {
        String string2 = '#' + string;
        if (this.idMap == null || string == null) {
            return;
        }
        IDResolver iDResolver = (IDResolver)this.idMap.get(string2);
        if (iDResolver == null) {
            return;
        }
        iDResolver.addReferencedObject(string2, object);
    }

    public void registerFixup(String string, Deserializer deserializer) {
        Deserializer deserializer2;
        if (this.fixups == null) {
            this.fixups = new HashMap();
        }
        if ((deserializer2 = this.fixups.put(string, deserializer)) != null && deserializer2 != deserializer) {
            deserializer.moveValueTargets(deserializer2);
            if (deserializer.getDefaultType() == null) {
                deserializer.setDefaultType(deserializer2.getDefaultType());
            }
        }
    }

    public void registerElementByID(String string, MessageElement messageElement) {
        Deserializer deserializer;
        if (this.localIDs == null) {
            this.localIDs = new LocalIDResolver();
        }
        String string2 = '#' + string;
        this.localIDs.addReferencedObject(string2, messageElement);
        this.registerResolverForID(string2, this.localIDs);
        if (this.fixups != null && (deserializer = (Deserializer)this.fixups.get(string2)) != null) {
            messageElement.setFixupDeserializer(deserializer);
        }
    }

    public void registerResolverForID(String string, IDResolver iDResolver) {
        if (string == null || iDResolver == null) {
            return;
        }
        if (this.idMap == null) {
            this.idMap = new HashMap();
        }
        this.idMap.put(string, iDResolver);
    }

    public boolean hasElementsByID() {
        return this.idMap == null ? false : this.idMap.size() > 0;
    }

    public int getCurrentRecordPos() {
        if (this.recorder == null) {
            return -1;
        }
        return this.recorder.getLength() - 1;
    }

    public int getStartOfMappingsPos() {
        if (this.startOfMappingsPos == -1) {
            return this.getCurrentRecordPos() + 1;
        }
        return this.startOfMappingsPos;
    }

    public void pushNewElement(MessageElement messageElement) {
        if (this.debugEnabled) {
            log.debug("Pushing element " + messageElement.getName());
        }
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.newElement(messageElement);
        }
        try {
            if (this.curElement != null) {
                messageElement.setParentElement(this.curElement);
            }
        }
        catch (Exception exception) {
            log.fatal(Messages.getMessage("exception00"), exception);
        }
        this.curElement = messageElement;
        if (messageElement.getRecorder() != this.recorder) {
            this.recorder = messageElement.getRecorder();
        }
    }

    public void pushElementHandler(SOAPHandler sOAPHandler) {
        if (this.debugEnabled) {
            log.debug(Messages.getMessage("pushHandler00", "" + sOAPHandler));
        }
        if (this.topHandler != null) {
            this.pushedDownHandlers.add(this.topHandler);
        }
        this.topHandler = sOAPHandler;
    }

    public void replaceElementHandler(SOAPHandler sOAPHandler) {
        this.topHandler = sOAPHandler;
    }

    public SOAPHandler popElementHandler() {
        SOAPHandler sOAPHandler = this.topHandler;
        int n = this.pushedDownHandlers.size();
        this.topHandler = n > 0 ? (SOAPHandler)this.pushedDownHandlers.remove(n - 1) : null;
        if (this.debugEnabled) {
            if (sOAPHandler == null) {
                log.debug(Messages.getMessage("popHandler00", "(null)"));
            } else {
                log.debug(Messages.getMessage("popHandler00", "" + sOAPHandler));
            }
        }
        return sOAPHandler;
    }

    public void setProcessingRef(boolean bl) {
        this.processingRef = bl;
    }

    public boolean isProcessingRef() {
        return this.processingRef;
    }

    public void startDocument() throws SAXException {
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.debugEnabled) {
            log.debug("Enter: DeserializationContext::endDocument()");
        }
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.endDocument();
        }
        this.doneParsing = true;
        if (this.debugEnabled) {
            log.debug("Exit: DeserializationContext::endDocument()");
        }
    }

    public boolean isDoneParsing() {
        return this.doneParsing;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.debugEnabled) {
            log.debug("Enter: DeserializationContext::startPrefixMapping(" + string + ", " + string2 + ")");
        }
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.startPrefixMapping(string, string2);
        }
        if (this.startOfMappingsPos == -1) {
            this.namespaces.push();
            this.startOfMappingsPos = this.getCurrentRecordPos();
        }
        if (string != null) {
            this.namespaces.add(string2, string);
        } else {
            this.namespaces.add(string2, "");
        }
        if (!this.haveSeenSchemaNS && this.msgContext != null) {
            for (int i = 0; !this.haveSeenSchemaNS && i < schemaVersions.length; ++i) {
                SchemaVersion schemaVersion = schemaVersions[i];
                if (!string2.equals(schemaVersion.getXsdURI()) && !string2.equals(schemaVersion.getXsiURI())) continue;
                this.msgContext.setSchemaVersion(schemaVersion);
                this.haveSeenSchemaNS = true;
            }
        }
        if (this.topHandler != null) {
            this.topHandler.startPrefixMapping(string, string2);
        }
        if (this.debugEnabled) {
            log.debug("Exit: DeserializationContext::startPrefixMapping()");
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.debugEnabled) {
            log.debug("Enter: DeserializationContext::endPrefixMapping(" + string + ")");
        }
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.endPrefixMapping(string);
        }
        if (this.topHandler != null) {
            this.topHandler.endPrefixMapping(string);
        }
        if (this.debugEnabled) {
            log.debug("Exit: DeserializationContext::endPrefixMapping()");
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.setDocumentLocator(locator);
        }
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.characters(cArray, n, n2);
        }
        if (this.topHandler != null) {
            this.topHandler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.ignorableWhitespace(cArray, n, n2);
        }
        if (this.topHandler != null) {
            this.topHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        throw new SAXException(Messages.getMessage("noInstructions00"));
    }

    public void skippedEntity(String string) throws SAXException {
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.skippedEntity(string);
        }
        this.topHandler.skippedEntity(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        if (this.debugEnabled) {
            log.debug("Enter: DeserializationContext::startElement(" + string + ", " + string2 + ")");
        }
        if (attributes == null || attributes.getLength() == 0) {
            attributes = NullAttributes.singleton;
        } else {
            attributes = new AttributesImpl(attributes);
            object = this.getSOAPConstants();
            if (object == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue(object.getAttrHref()) != null && attributes.getValue("id") != null) {
                AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noIDandHREFonSameElement"), null, null, null);
                throw new SAXException(axisFault);
            }
        }
        object = null;
        String string4 = "";
        int n = string3.indexOf(58);
        if (n > 0) {
            string4 = string3.substring(0, n);
        }
        if (this.topHandler != null) {
            object = this.topHandler.onStartChild(string, string2, string4, attributes, this);
        }
        if (object == null) {
            object = new SOAPHandler();
        }
        this.pushElementHandler((SOAPHandler)object);
        ((SOAPHandler)object).startElement(string, string2, string4, attributes, this);
        if (!this.doneParsing && this.recorder != null) {
            this.recorder.startElement(string, string2, string3, attributes);
            if (!this.doneParsing) {
                this.curElement.setContentsIndex(this.recorder.getLength());
            }
        }
        if (this.startOfMappingsPos != -1) {
            this.startOfMappingsPos = -1;
        } else {
            this.namespaces.push();
        }
        if (this.debugEnabled) {
            log.debug("Exit: DeserializationContext::startElement()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        block8: {
            if (this.debugEnabled) {
                log.debug("Enter: DeserializationContext::endElement(" + string + ", " + string2 + ")");
            }
            if (!this.doneParsing && this.recorder != null) {
                this.recorder.endElement(string, string2, string3);
            }
            try {
                SOAPHandler sOAPHandler = this.popElementHandler();
                sOAPHandler.endElement(string, string2, this);
                if (this.topHandler != null) {
                    this.topHandler.onEndChild(string, string2, this);
                }
                Object var6_5 = null;
                if (this.curElement == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.curElement != null) {
                    this.curElement = (MessageElement)this.curElement.getParentElement();
                }
                this.namespaces.pop();
                if (this.debugEnabled) {
                    String string4 = this.curElement != null ? this.curElement.getClass().getName() + ":" + this.curElement.getName() : null;
                    log.debug("Popped element stack to " + string4);
                    log.debug("Exit: DeserializationContext::endElement()");
                }
                throw throwable;
            }
            this.curElement = (MessageElement)this.curElement.getParentElement();
        }
        this.namespaces.pop();
        if (this.debugEnabled) {
            String string5 = this.curElement != null ? this.curElement.getClass().getName() + ":" + this.curElement.getName() : null;
            log.debug("Popped element stack to " + string5);
            log.debug("Exit: DeserializationContext::endElement()");
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        throw new SAXException(Messages.getMessage("noInstructions00"));
    }

    public void endDTD() throws SAXException {
        if (this.recorder != null) {
            this.recorder.endDTD();
        }
    }

    public void startEntity(String string) throws SAXException {
        if (this.recorder != null) {
            this.recorder.startEntity(string);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.recorder != null) {
            this.recorder.endEntity(string);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.recorder != null) {
            this.recorder.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.recorder != null) {
            this.recorder.endCDATA();
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.recorder != null) {
            this.recorder.comment(cArray, n, n2);
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        return XMLUtils.getEmptyInputSource();
    }

    private static class NullLexicalHandler
    implements LexicalHandler {
        private NullLexicalHandler() {
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }
    }

    private static class LocalIDResolver
    implements IDResolver {
        HashMap idMap = null;

        private LocalIDResolver() {
        }

        public void addReferencedObject(String string, Object object) {
            if (this.idMap == null) {
                this.idMap = new HashMap();
            }
            this.idMap.put(string, object);
        }

        public Object getReferencedObject(String string) {
            if (this.idMap == null || string == null) {
                return null;
            }
            return this.idMap.get(string);
        }
    }
}

