/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.ser.BaseFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.ElementDeserializerFactory;
import org.apache.axis.encoding.ser.EnumDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleListDeserializerFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public abstract class BaseDeserializerFactory
extends BaseFactory
implements DeserializerFactory {
    protected static Log log = LogFactory.getLog(BaseDeserializerFactory.class.getName());
    static transient Vector mechanisms = null;
    protected Class deserClass = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected transient Constructor deserClassConstructor = null;
    protected transient Method getDeserializer = null;
    private static final Class[] CLASS_QNAME_CLASS = new Class[]{Class.class, QName.class};

    public BaseDeserializerFactory(Class clazz) {
        if (!Deserializer.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(org.apache.axis.i18n.Messages.getMessage("BadImplementation00", clazz.getName(), Deserializer.class.getName()));
        }
        this.deserClass = clazz;
    }

    public BaseDeserializerFactory(Class clazz, QName qName, Class clazz2) {
        this(clazz);
        this.xmlType = qName;
        this.javaType = clazz2;
    }

    public javax.xml.rpc.encoding.Deserializer getDeserializerAs(String string) throws JAXRPCException {
        Deserializer deserializer = null;
        deserializer = this.getSpecialized(string);
        if (deserializer == null) {
            deserializer = this.getGeneralPurpose(string);
        }
        try {
            if (deserializer == null) {
                deserializer = (Deserializer)this.deserClass.newInstance();
            }
        }
        catch (Exception exception) {
            throw new JAXRPCException(exception);
        }
        return deserializer;
    }

    protected Deserializer getGeneralPurpose(String string) {
        block7: {
            Constructor constructor;
            if (this.javaType != null && this.xmlType != null && (constructor = this.getDeserClassConstructor()) != null) {
                try {
                    return (Deserializer)constructor.newInstance(this.javaType, this.xmlType);
                }
                catch (InstantiationException instantiationException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        try {
            return clazz.getConstructor(CLASS_QNAME_CLASS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected Deserializer getSpecialized(String string) {
        block5: {
            Method method;
            if (this.javaType != null && this.xmlType != null && (method = this.getGetDeserializer()) != null) {
                try {
                    return (Deserializer)method.invoke(null, string, this.javaType, this.xmlType);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
        }
        return null;
    }

    public Iterator getSupportedMechanismTypes() {
        if (mechanisms == null) {
            mechanisms = new Vector(1);
            mechanisms.add("Axis SAX Mechanism");
        }
        return mechanisms.iterator();
    }

    public static DeserializerFactory createFactory(Class clazz, Class clazz2, QName qName) {
        DeserializerFactory deserializerFactory;
        block29: {
            Executable executable;
            block28: {
                if (clazz == null) {
                    return null;
                }
                try {
                    if (clazz == BeanDeserializerFactory.class) {
                        return new BeanDeserializerFactory(clazz2, qName);
                    }
                    if (clazz == SimpleDeserializerFactory.class) {
                        return new SimpleDeserializerFactory(clazz2, qName);
                    }
                    if (clazz == EnumDeserializerFactory.class) {
                        return new EnumDeserializerFactory(clazz2, qName);
                    }
                    if (clazz == ElementDeserializerFactory.class) {
                        return new ElementDeserializerFactory();
                    }
                    if (clazz == SimpleListDeserializerFactory.class) {
                        return new SimpleListDeserializerFactory(clazz2, qName);
                    }
                }
                catch (Exception exception) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), exception);
                    }
                    return null;
                }
                deserializerFactory = null;
                try {
                    executable = clazz.getMethod("create", CLASS_QNAME_CLASS);
                    deserializerFactory = (DeserializerFactory)((Method)executable).invoke(null, clazz2, qName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), noSuchMethodException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block28;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
            if (deserializerFactory == null) {
                try {
                    executable = clazz.getConstructor(CLASS_QNAME_CLASS);
                    deserializerFactory = (DeserializerFactory)((Constructor)executable).newInstance(clazz2, qName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), noSuchMethodException);
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block29;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
        }
        if (deserializerFactory == null) {
            try {
                deserializerFactory = (DeserializerFactory)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return deserializerFactory;
    }

    protected Constructor getDeserClassConstructor() {
        if (this.deserClassConstructor == null) {
            this.deserClassConstructor = this.getConstructor(this.deserClass);
        }
        return this.deserClassConstructor;
    }

    protected Method getGetDeserializer() {
        if (this.getDeserializer == null) {
            this.getDeserializer = this.getMethod(this.javaType, "getDeserializer");
        }
        return this.getDeserializer;
    }
}

