/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.BaseFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.encoding.ser.ElementSerializerFactory;
import org.apache.axis.encoding.ser.EnumSerializerFactory;
import org.apache.axis.encoding.ser.SimpleListSerializerFactory;
import org.apache.axis.encoding.ser.SimpleSerializerFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public abstract class BaseSerializerFactory
extends BaseFactory
implements SerializerFactory {
    protected static Log log = LogFactory.getLog(BaseSerializerFactory.class.getName());
    static transient Vector mechanisms = null;
    protected Class serClass = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected transient Serializer ser = null;
    protected transient Constructor serClassConstructor = null;
    protected transient Method getSerializer = null;
    private static final Class[] CLASS_QNAME_CLASS = new Class[]{Class.class, QName.class};

    public BaseSerializerFactory(Class clazz) {
        if (!Serializer.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Messages.getMessage("BadImplementation00", clazz.getName(), Serializer.class.getName()));
        }
        this.serClass = clazz;
    }

    public BaseSerializerFactory(Class clazz, QName qName, Class clazz2) {
        this(clazz);
        this.xmlType = qName;
        this.javaType = clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.rpc.encoding.Serializer getSerializerAs(String string) throws JAXRPCException {
        BaseSerializerFactory baseSerializerFactory = this;
        synchronized (baseSerializerFactory) {
            if (this.ser == null) {
                this.ser = this.getSerializerAsInternal(string);
            }
            return this.ser;
        }
    }

    protected Serializer getSerializerAsInternal(String string) throws JAXRPCException {
        Serializer serializer = this.getSpecialized(string);
        if (serializer == null) {
            serializer = this.getGeneralPurpose(string);
        }
        try {
            if (serializer == null) {
                serializer = (Serializer)this.serClass.newInstance();
            }
        }
        catch (Exception exception) {
            throw new JAXRPCException(Messages.getMessage("CantGetSerializer", this.serClass.getName()), exception);
        }
        return serializer;
    }

    protected Serializer getGeneralPurpose(String string) {
        block7: {
            Constructor constructor;
            if (this.javaType != null && this.xmlType != null && (constructor = this.getSerClassConstructor()) != null) {
                try {
                    return (Serializer)constructor.newInstance(this.javaType, this.xmlType);
                }
                catch (InstantiationException instantiationException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        try {
            return clazz.getConstructor(CLASS_QNAME_CLASS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected Serializer getSpecialized(String string) {
        block5: {
            Method method;
            if (this.javaType != null && this.xmlType != null && (method = this.getGetSerializer()) != null) {
                try {
                    return (Serializer)method.invoke(null, string, this.javaType, this.xmlType);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
        }
        return null;
    }

    public Iterator getSupportedMechanismTypes() {
        if (mechanisms == null) {
            mechanisms = new Vector(1);
            mechanisms.add("Axis SAX Mechanism");
        }
        return mechanisms.iterator();
    }

    public QName getXMLType() {
        return this.xmlType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static SerializerFactory createFactory(Class clazz, Class clazz2, QName qName) {
        SerializerFactory serializerFactory;
        block29: {
            Executable executable;
            block28: {
                if (clazz == null) {
                    return null;
                }
                try {
                    if (clazz == BeanSerializerFactory.class) {
                        return new BeanSerializerFactory(clazz2, qName);
                    }
                    if (clazz == SimpleSerializerFactory.class) {
                        return new SimpleSerializerFactory(clazz2, qName);
                    }
                    if (clazz == EnumSerializerFactory.class) {
                        return new EnumSerializerFactory(clazz2, qName);
                    }
                    if (clazz == ElementSerializerFactory.class) {
                        return new ElementSerializerFactory();
                    }
                    if (clazz == SimpleListSerializerFactory.class) {
                        return new SimpleListSerializerFactory(clazz2, qName);
                    }
                }
                catch (Exception exception) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), exception);
                    }
                    return null;
                }
                serializerFactory = null;
                try {
                    executable = clazz.getMethod("create", CLASS_QNAME_CLASS);
                    serializerFactory = (SerializerFactory)((Method)executable).invoke(null, clazz2, qName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), noSuchMethodException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block28;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
            if (serializerFactory == null) {
                try {
                    executable = clazz.getConstructor(CLASS_QNAME_CLASS);
                    serializerFactory = (SerializerFactory)((Constructor)executable).newInstance(clazz2, qName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), noSuchMethodException);
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!log.isDebugEnabled()) break block29;
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
            }
        }
        if (serializerFactory == null) {
            try {
                serializerFactory = (SerializerFactory)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return serializerFactory;
    }

    protected Method getGetSerializer() {
        if (this.getSerializer == null) {
            this.getSerializer = this.getMethod(this.javaType, "getSerializer");
        }
        return this.getSerializer;
    }

    protected Constructor getSerClassConstructor() {
        if (this.serClassConstructor == null) {
            this.serClassConstructor = this.getConstructor(this.serClass);
        }
        return this.serClassConstructor;
    }
}

