/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.ConstructorTarget;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.Target;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.ArrayDeserializer;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanPropertyTarget;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.message.Text;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends DeserializerImpl
implements Serializable {
    protected static Log log = LogFactory.getLog(BeanDeserializer.class.getName());
    private final CharArrayWriter val = new CharArrayWriter();
    QName xmlType;
    Class javaType;
    protected Map propertyMap = null;
    protected QName prevQName;
    protected Constructor constructorToUse = null;
    protected Target constructorTarget = null;
    protected TypeDesc typeDesc = null;
    protected int collectionIndex = -1;
    protected SimpleDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;

    public BeanDeserializer(Class clazz, QName qName) {
        this(clazz, qName, TypeDesc.getTypeDescForClass(clazz));
    }

    public BeanDeserializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this(clazz, qName, typeDesc, BeanDeserializerFactory.getProperties(clazz, typeDesc));
    }

    public BeanDeserializer(Class clazz, QName qName, TypeDesc typeDesc, Map map) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.typeDesc = typeDesc;
        this.propertyMap = map;
        try {
            this.value = clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        block4: {
            if (this.value == null) {
                try {
                    this.value = this.javaType.newInstance();
                }
                catch (Exception exception) {
                    Constructor<?>[] constructorArray = this.javaType.getConstructors();
                    if (constructorArray.length > 0) {
                        this.constructorToUse = constructorArray[0];
                    }
                    if (this.constructorToUse != null) break block4;
                    throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), exception.toString()));
                }
            }
        }
        super.startElement(string, string2, string3, attributes, deserializationContext);
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        Deserializer deserializer;
        Object object;
        Object object2;
        this.handleMixedContent();
        BeanPropertyDescriptor beanPropertyDescriptor = null;
        FieldDesc fieldDesc = null;
        SOAPConstants sOAPConstants = deserializationContext.getSOAPConstants();
        String string4 = deserializationContext.getEncodingStyle();
        boolean bl = Constants.isSOAP_ENC(string4);
        QName qName = new QName(string, string2);
        if (this.prevQName == null || !this.prevQName.equals(qName)) {
            this.collectionIndex = -1;
        }
        boolean bl2 = false;
        QName qName2 = null;
        if (this.typeDesc != null) {
            object2 = this.typeDesc.getFieldNameForElement(qName, bl);
            beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(object2);
            fieldDesc = this.typeDesc.getFieldByName((String)object2);
            if (fieldDesc != null) {
                object = (ElementDesc)fieldDesc;
                bl2 = ((ElementDesc)object).isMaxOccursUnbounded();
                qName2 = ((ElementDesc)object).getItemQName();
            }
        }
        if (beanPropertyDescriptor == null) {
            beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string2);
        }
        if (beanPropertyDescriptor == null || this.prevQName != null && this.prevQName.equals(qName) && !beanPropertyDescriptor.isIndexed() && !bl2 && this.getAnyPropertyDesc() != null) {
            this.prevQName = qName;
            beanPropertyDescriptor = this.getAnyPropertyDesc();
            if (beanPropertyDescriptor != null) {
                try {
                    MessageElement messageElement;
                    object2 = (MessageElement[])beanPropertyDescriptor.get(this.value);
                    int n = 0;
                    if (object2 != null) {
                        n = ((MessageElement[])object2).length;
                    }
                    MessageElement[] messageElementArray = new MessageElement[n + 1];
                    if (object2 != null) {
                        System.arraycopy(object2, 0, messageElementArray, 0, n);
                    }
                    messageElementArray[n] = messageElement = deserializationContext.getCurElement();
                    beanPropertyDescriptor.set(this.value, messageElementArray);
                    if (!string2.equals(messageElement.getName())) {
                        return new SOAPHandler(messageElementArray, n);
                    }
                    return new SOAPHandler();
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
        }
        if (beanPropertyDescriptor == null) {
            throw new SAXException(Messages.getMessage("badElem00", this.javaType.getName(), string2));
        }
        this.prevQName = qName;
        object2 = deserializationContext.getTypeFromAttributes(string, string2, attributes);
        object = attributes.getValue(sOAPConstants.getAttrHref());
        Class clazz = beanPropertyDescriptor.getType();
        if (object2 == null && fieldDesc != null && object == null) {
            object2 = fieldDesc.getXmlType();
            if (qName2 != null) {
                object2 = Constants.SOAP_ARRAY;
                clazz = beanPropertyDescriptor.getActualType();
            } else {
                object2 = fieldDesc.getXmlType();
            }
        }
        if ((deserializer = this.getDeserializer((QName)object2, clazz, (String)object, deserializationContext)) == null) {
            deserializer = deserializationContext.getDeserializerForClass(beanPropertyDescriptor.getType());
        }
        if (deserializationContext.isNil(attributes)) {
            if (!(beanPropertyDescriptor == null || !beanPropertyDescriptor.isIndexed() && !bl2 || deserializer != null && deserializer instanceof ArrayDeserializer)) {
                ++this.collectionIndex;
                deserializer.registerValueTarget(new BeanPropertyTarget(this.value, beanPropertyDescriptor, this.collectionIndex));
                this.addChildDeserializer(deserializer);
                return (SOAPHandler)((Object)deserializer);
            }
            return null;
        }
        if (deserializer == null) {
            throw new SAXException(Messages.getMessage("noDeser00", ((QName)object2).toString()));
        }
        if (this.constructorToUse != null) {
            if (this.constructorTarget == null) {
                this.constructorTarget = new ConstructorTarget(this.constructorToUse, this);
            }
            deserializer.registerValueTarget(this.constructorTarget);
        } else if (beanPropertyDescriptor.isWriteable()) {
            if ((qName2 != null || beanPropertyDescriptor.isIndexed() || bl2) && !(deserializer instanceof ArrayDeserializer)) {
                ++this.collectionIndex;
                deserializer.registerValueTarget(new BeanPropertyTarget(this.value, beanPropertyDescriptor, this.collectionIndex));
            } else {
                this.collectionIndex = -1;
                deserializer.registerValueTarget(new BeanPropertyTarget(this.value, beanPropertyDescriptor));
            }
        }
        this.addChildDeserializer(deserializer);
        return (SOAPHandler)((Object)deserializer);
    }

    public BeanPropertyDescriptor getAnyPropertyDesc() {
        if (this.typeDesc == null) {
            return null;
        }
        return this.typeDesc.getAnyDesc();
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (this.value == null && this.constructorToUse == null) {
            try {
                this.value = this.javaType.newInstance();
            }
            catch (Exception exception) {
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), exception.toString()));
            }
        }
        if (this.typeDesc == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName qName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String string4 = this.typeDesc.getFieldNameForAttribute(qName);
            if (string4 == null) continue;
            FieldDesc fieldDesc = this.typeDesc.getFieldByName(string4);
            BeanPropertyDescriptor beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string4);
            if (beanPropertyDescriptor == null || this.constructorToUse == null && (!beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed())) continue;
            Deserializer deserializer = this.getDeserializer(fieldDesc.getXmlType(), beanPropertyDescriptor.getType(), null, deserializationContext);
            if (deserializer == null) {
                deserializer = deserializationContext.getDeserializerForClass(beanPropertyDescriptor.getType());
            }
            if (deserializer == null) {
                throw new SAXException(Messages.getMessage("unregistered00", beanPropertyDescriptor.getType().toString()));
            }
            if (!(deserializer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", beanPropertyDescriptor.getName(), beanPropertyDescriptor.getType().toString()));
            }
            try {
                deserializer.onStartElement(string, string2, string3, attributes, deserializationContext);
                Object object = ((SimpleDeserializer)deserializer).makeValue(attributes.getValue(i));
                if (this.constructorToUse == null) {
                    beanPropertyDescriptor.set(this.value, object);
                    continue;
                }
                if (this.constructorTarget == null) {
                    this.constructorTarget = new ConstructorTarget(this.constructorToUse, this);
                }
                this.constructorTarget.set(object);
                continue;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    protected Deserializer getDeserializer(QName qName, Class clazz, String string, DeserializationContext deserializationContext) {
        if (clazz.isArray()) {
            deserializationContext.setDestinationClass(clazz);
        }
        if (this.cacheStringDSer != null && String.class.equals((Object)clazz) && string == null && (this.cacheXMLType == null && qName == null || this.cacheXMLType != null && this.cacheXMLType.equals(qName))) {
            this.cacheStringDSer.reset();
            return this.cacheStringDSer;
        }
        Deserializer deserializer = null;
        if (qName != null && string == null) {
            deserializer = deserializationContext.getDeserializerForType(qName);
        } else {
            TypeMapping typeMapping = deserializationContext.getTypeMapping();
            QName qName2 = typeMapping.getTypeQName(clazz);
            if (string == null) {
                deserializer = deserializationContext.getDeserializer(clazz, qName2);
            } else {
                deserializer = new DeserializerImpl();
                deserializationContext.setDestinationClass(clazz);
                deserializer.setDefaultType(qName2);
            }
        }
        if (clazz.equals(String.class) && deserializer instanceof SimpleDeserializer) {
            this.cacheStringDSer = (SimpleDeserializer)deserializer;
            this.cacheXMLType = qName;
        }
        return deserializer;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.val.write(cArray, n, n2);
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        this.handleMixedContent();
    }

    protected void handleMixedContent() throws SAXException {
        BeanPropertyDescriptor beanPropertyDescriptor = this.getAnyPropertyDesc();
        if (beanPropertyDescriptor == null || this.val.size() == 0) {
            return;
        }
        String string = this.val.toString().trim();
        this.val.reset();
        if (string.length() == 0) {
            return;
        }
        try {
            MessageElement messageElement;
            MessageElement[] messageElementArray = (MessageElement[])beanPropertyDescriptor.get(this.value);
            int n = 0;
            if (messageElementArray != null) {
                n = messageElementArray.length;
            }
            MessageElement[] messageElementArray2 = new MessageElement[n + 1];
            if (messageElementArray != null) {
                System.arraycopy(messageElementArray, 0, messageElementArray2, 0, n);
            }
            messageElementArray2[n] = messageElement = new MessageElement(new Text(string));
            beanPropertyDescriptor.set(this.value, messageElementArray2);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }
}

