/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.encoding.ser.QNameSerializer;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleListSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private TypeDesc typeDesc = null;

    public SimpleListSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
    }

    public SimpleListSerializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.typeDesc = typeDesc;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        if (object != null && object.getClass() == Object.class) {
            throw new IOException(Messages.getMessage("cantSerialize02"));
        }
        if (object instanceof SimpleType) {
            attributes = this.getObjectAttributes(object, attributes, serializationContext);
        }
        String string = null;
        if (object != null) {
            string = this.getValueAsString(object, serializationContext);
        }
        serializationContext.startElement(qName, attributes);
        if (string != null) {
            serializationContext.writeSafeString(string);
        }
        serializationContext.endElement();
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        int n = Array.getLength(object);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 instanceof Float || object2 instanceof Double) {
                double d = 0.0;
                d = object2 instanceof Float ? ((Float)object2).doubleValue() : ((Double)object2).doubleValue();
                if (Double.isNaN(d)) {
                    stringBuffer.append("NaN");
                } else if (d == Double.POSITIVE_INFINITY) {
                    stringBuffer.append("INF");
                } else if (d == Double.NEGATIVE_INFINITY) {
                    stringBuffer.append("-INF");
                } else {
                    stringBuffer.append(object2.toString());
                }
            } else if (object2 instanceof QName) {
                stringBuffer.append(QNameSerializer.qName2String((QName)object2, serializationContext));
            } else {
                stringBuffer.append(object2.toString());
            }
            if (i >= n - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private Attributes getObjectAttributes(Object object, Attributes attributes, SerializationContext serializationContext) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object object2;
                FieldDesc fieldDesc;
                String string = this.propertyDescriptor[i].getName();
                if (string.equals("class") || (fieldDesc = this.typeDesc.getFieldByName(string)) == null || fieldDesc.isElement()) continue;
                QName qName = fieldDesc.getXmlName();
                if (qName == null) {
                    qName = new QName("", string);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (object2 = this.propertyDescriptor[i].get(object)) == null) continue;
                String string2 = this.getValueAsString(object2, serializationContext);
                String string3 = qName.getNamespaceURI();
                String string4 = qName.getLocalPart();
                attributesImpl.addAttribute(string3, string4, serializationContext.qName2String(qName), "CDATA", string2);
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        if (!SimpleType.class.isAssignableFrom(clazz)) {
            return null;
        }
        Element element = types.createElement("complexType");
        types.writeSchemaElementDecl(this.xmlType, element);
        element.setAttribute("name", this.xmlType.getLocalPart());
        Element element2 = types.createElement("simpleContent");
        element.appendChild(element2);
        Element element3 = types.createElement("extension");
        element2.appendChild(element3);
        String string = "string";
        for (int i = 0; i < this.propertyDescriptor.length; ++i) {
            Serializable serializable;
            Object object;
            String string2 = this.propertyDescriptor[i].getName();
            if (!string2.equals("value")) {
                Class clazz2;
                if (this.typeDesc == null || (object = this.typeDesc.getFieldByName(string2)) == null) continue;
                if (((FieldDesc)object).isElement()) {
                    // empty if block
                }
                if ((serializable = ((FieldDesc)object).getXmlName()) == null) {
                    serializable = new QName("", string2);
                }
                if (!types.isAcceptableAsAttribute(clazz2 = this.propertyDescriptor[i].getType())) {
                    throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", string2, clazz2.getName()));
                }
                Element element4 = types.createAttributeElement(string2, clazz2, ((FieldDesc)object).getXmlType(), false, element3.getOwnerDocument());
                element3.appendChild(element4);
                continue;
            }
            object = this.propertyDescriptor[i];
            serializable = ((BeanPropertyDescriptor)object).getType();
            if (!types.isAcceptableAsAttribute((Class)serializable)) {
                throw new AxisFault(Messages.getMessage("AttrNotSimpleType01", ((Class)serializable).getName()));
            }
            string = types.writeType((Class)serializable);
            element3.setAttribute("base", string);
        }
        return element;
    }
}

