/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class DebugHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(DebugHandler.class.getName());
    public static final String NS_URI_DEBUG = "http://xml.apache.org/axis/debug";

    public void invoke(MessageContext messageContext) throws AxisFault {
        log.debug("Enter: DebugHandler::invoke");
        try {
            Message message = messageContext.getRequestMessage();
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeaderElement sOAPHeaderElement = sOAPEnvelope.getHeaderByName(NS_URI_DEBUG, "Debug");
            if (sOAPHeaderElement != null) {
                Integer n = (Integer)sOAPHeaderElement.getValueAsType(Constants.XSD_INT);
                if (n == null) {
                    throw new AxisFault(Messages.getMessage("cantConvert03"));
                }
                int n2 = n;
                log.debug(Messages.getMessage("debugLevel00", "" + n2));
                sOAPHeaderElement.setProcessed(true);
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            throw AxisFault.makeFault(exception);
        }
        log.debug("Exit: DebugHandler::invoke");
    }

    public void onFault(MessageContext messageContext) {
        log.debug("Enter: DebugHandler::onFault");
        log.debug("Exit: DebugHandler::onFault");
    }
}

