/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class LogHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(LogHandler.class.getName());
    long start = -1L;
    private boolean writeToConsole = false;
    private String filename = "axis.log";

    public void init() {
        super.init();
        Object object = this.getOption("LogHandler.writeToConsole");
        if (object != null && object instanceof String && "true".equalsIgnoreCase((String)object)) {
            this.writeToConsole = true;
        }
        if ((object = this.getOption("LogHandler.fileName")) != null && object instanceof String) {
            this.filename = (String)object;
        }
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        log.debug("Enter: LogHandler::invoke");
        if (!messageContext.getPastPivot()) {
            this.start = System.currentTimeMillis();
        } else {
            this.logMessages(messageContext);
        }
        log.debug("Exit: LogHandler::invoke");
    }

    private void logMessages(MessageContext messageContext) throws AxisFault {
        try {
            PrintWriter printWriter = null;
            printWriter = this.getWriter();
            Message message = messageContext.getRequestMessage();
            Message message2 = messageContext.getResponseMessage();
            printWriter.println("=======================================================");
            if (this.start != -1L) {
                printWriter.println("= " + Messages.getMessage("elapsed00", "" + (System.currentTimeMillis() - this.start)));
            }
            printWriter.println("= " + Messages.getMessage("inMsg00", message == null ? "null" : message.getSOAPPartAsString()));
            printWriter.println("= " + Messages.getMessage("outMsg00", message2 == null ? "null" : message2.getSOAPPartAsString()));
            printWriter.println("=======================================================");
            if (!this.writeToConsole) {
                printWriter.close();
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            throw AxisFault.makeFault(exception);
        }
    }

    private PrintWriter getWriter() throws IOException {
        PrintWriter printWriter;
        if (this.writeToConsole) {
            printWriter = new PrintWriter(System.out);
        } else {
            if (this.filename == null) {
                this.filename = "axis.log";
            }
            printWriter = new PrintWriter(new FileWriter(this.filename, true));
        }
        return printWriter;
    }

    public void onFault(MessageContext messageContext) {
        try {
            this.logMessages(messageContext);
        }
        catch (AxisFault axisFault) {
            log.error(Messages.getMessage("exception00"), axisFault);
        }
    }
}

