/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.i18n.Messages;
import org.apache.commons.logging.Log;

public class Registrar {
    protected static Log log = LogFactory.getLog(Registrar.class.getName());
    private static ModelerBinding modelerBinding = null;

    public static boolean register(Object object, String string, String string2) {
        if (Registrar.isBound()) {
            if (log.isDebugEnabled()) {
                log.debug("Registering " + object + " as " + string);
            }
            return modelerBinding.register(object, string, string2);
        }
        return false;
    }

    public static boolean isBound() {
        Registrar.createModelerBinding();
        return modelerBinding.canBind();
    }

    private static void createModelerBinding() {
        if (modelerBinding == null) {
            modelerBinding = new ModelerBinding();
        }
    }

    static class ModelerBinding {
        protected static Log log = LogFactory.getLog(ModelerBinding.class.getName());
        Object registry;
        Method registerComponent;

        public ModelerBinding() {
            this.bindToModeler();
        }

        public boolean canBind() {
            return this.registry != null;
        }

        public boolean register(Object object, String string, String string2) {
            if (this.registry != null) {
                Object[] objectArray = new Object[]{object, string, string2};
                try {
                    this.registerComponent.invoke(this.registry, objectArray);
                    if (log.isDebugEnabled()) {
                        log.debug("Registered " + string + " in " + string2);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    log.error(illegalAccessException);
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error(illegalArgumentException);
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    log.error(invocationTargetException);
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean bindToModeler() {
            Class<?> clazz;
            Exception exception = null;
            try {
                clazz = Class.forName("org.apache.commons.modeler.Registry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.registry = null;
                return false;
            }
            try {
                Class[] classArray = new Class[]{Object.class, Object.class};
                Method method = clazz.getMethod("getRegistry", classArray);
                Object[] objectArray = new Object[]{null, null};
                this.registry = method.invoke(null, objectArray);
                Class[] classArray2 = new Class[]{Object.class, String.class, String.class};
                this.registerComponent = clazz.getMethod("registerComponent", classArray2);
            }
            catch (IllegalAccessException illegalAccessException) {
                exception = illegalAccessException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                exception = illegalArgumentException;
            }
            catch (InvocationTargetException invocationTargetException) {
                exception = invocationTargetException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                exception = noSuchMethodException;
            }
            if (exception != null) {
                log.warn(Messages.getMessage("Registrar.cantregister"), exception);
                this.registry = null;
                return false;
            }
            return true;
        }
    }
}

