/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.NodeListImpl;
import org.apache.axis.message.NullAttributes;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPDocumentImpl;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.message.Text;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MessageElement
extends NodeImpl
implements SOAPElement,
Serializable,
NodeList,
Cloneable {
    protected static Log log = LogFactory.getLog(MessageElement.class.getName());
    private static final Mapping enc11Mapping = new Mapping("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
    private static final Mapping enc12Mapping = new Mapping("http://www.w3.org/2003/05/soap-encoding", "SOAP-ENC");
    protected String id;
    protected String href;
    protected boolean _isRoot = true;
    protected SOAPEnvelope message = null;
    protected transient DeserializationContext context;
    protected transient QName typeQName = null;
    protected Vector qNameAttrs = null;
    protected transient SAX2EventRecorder recorder = null;
    protected int startEventIndex = 0;
    protected int startContentsIndex = 0;
    protected int endEventIndex = -1;
    public ArrayList namespaces = null;
    protected String encodingStyle = null;
    private Object objectValue = null;
    protected Deserializer fixupDeserializer;

    public MessageElement() {
    }

    public MessageElement(String string, String string2) {
        this.namespaceURI = string;
        this.name = string2;
    }

    public MessageElement(String string, String string2, String string3) {
        this.namespaceURI = string3;
        this.name = string;
        this.prefix = string2;
        this.addMapping(new Mapping(string3, string2));
    }

    public MessageElement(Name name) {
        this(name.getLocalName(), name.getPrefix(), name.getURI());
    }

    public MessageElement(String string, String string2, Object object) {
        this(string, string2);
        this.objectValue = object;
    }

    public MessageElement(QName qName) {
        this(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public MessageElement(QName qName, Object object) {
        this(qName.getNamespaceURI(), qName.getLocalPart());
        this.objectValue = object;
    }

    public MessageElement(Element element) {
        this.namespaceURI = element.getNamespaceURI();
        this.name = element.getLocalName();
        this.copyNode(element);
    }

    public MessageElement(CharacterData characterData) {
        this.textRep = characterData;
        this.namespaceURI = characterData.getNamespaceURI();
        this.name = characterData.getLocalName();
    }

    public MessageElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("newElem00", super.toString(), "{" + string3 + "}" + string2));
            for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
                log.debug("  " + attributes.getQName(i) + " = '" + attributes.getValue(i) + "'");
            }
        }
        this.namespaceURI = string;
        this.name = string2;
        this.prefix = string3;
        this.context = deserializationContext;
        this.startEventIndex = deserializationContext.getStartOfMappingsPos();
        this.setNSMappings(deserializationContext.getCurrentNSMappings());
        this.recorder = deserializationContext.getRecorder();
        if (attributes != null && attributes.getLength() > 0) {
            TypeMapping typeMapping;
            MessageContext messageContext;
            this.attributes = attributes;
            this.typeQName = deserializationContext.getTypeFromAttributes(string, string2, attributes);
            String string4 = attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "root");
            if (string4 != null) {
                this._isRoot = "1".equals(string4);
            }
            this.id = attributes.getValue("id");
            if (this.id != null) {
                deserializationContext.registerElementByID(this.id, this);
                if (this.recorder == null) {
                    this.recorder = new SAX2EventRecorder();
                    deserializationContext.setRecorder(this.recorder);
                }
            }
            SOAPConstants sOAPConstants = (messageContext = deserializationContext.getMessageContext()) != null ? messageContext.getSOAPConstants() : SOAPConstants.SOAP11_CONSTANTS;
            this.href = attributes.getValue(sOAPConstants.getAttrHref());
            if (attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
                this.typeQName = Constants.SOAP_ARRAY;
            }
            this.encodingStyle = attributes.getValue(sOAPConstants.getEncodingURI(), "encodingStyle");
            if ("http://www.w3.org/2003/05/soap-envelope/encoding/none".equals(this.encodingStyle)) {
                this.encodingStyle = null;
            }
            if (this.encodingStyle != null && sOAPConstants.equals(SOAPConstants.SOAP12_CONSTANTS) && messageContext.getOperationStyle() != Style.MESSAGE && ((typeMapping = messageContext.getTypeMappingRegistry().getTypeMapping(this.encodingStyle)) == null || typeMapping.equals(messageContext.getTypeMappingRegistry().getDefaultTypeMapping()))) {
                AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_DATAENCODINGUNKNOWN, "bad encoding style", null, null);
                throw axisFault;
            }
        }
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String string, boolean bl) {
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) {
    }

    public void setIdAttributeNode(Attr attr, boolean bl) {
    }

    public DeserializationContext getDeserializationContext() {
        return this.context;
    }

    public void setFixupDeserializer(Deserializer deserializer) {
        this.fixupDeserializer = deserializer;
    }

    public Deserializer getFixupDeserializer() {
        return this.fixupDeserializer;
    }

    public void setEndIndex(int n) {
        this.endEventIndex = n;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getID() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public Attributes getAttributesEx() {
        return this.attributes;
    }

    public Node cloneNode(boolean bl) {
        try {
            MessageElement messageElement = (MessageElement)this.cloning();
            if (bl && this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    NodeImpl nodeImpl = (NodeImpl)this.children.get(i);
                    if (nodeImpl == null) continue;
                    NodeImpl nodeImpl2 = (NodeImpl)nodeImpl.cloneNode(bl);
                    nodeImpl2.setParent(messageElement);
                    nodeImpl2.setOwnerDocument(this.getOwnerDocument());
                    messageElement.childDeepCloned(nodeImpl, nodeImpl2);
                }
            }
            return messageElement;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void childDeepCloned(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
    }

    protected Object cloning() throws CloneNotSupportedException {
        try {
            MessageElement messageElement = null;
            messageElement = (MessageElement)this.clone();
            messageElement.setName(this.name);
            messageElement.setNamespaceURI(this.namespaceURI);
            messageElement.setPrefix(this.prefix);
            messageElement.setAllAttributes(new AttributesImpl(this.attributes));
            messageElement.namespaces = new ArrayList();
            if (this.namespaces != null) {
                for (int i = 0; i < this.namespaces.size(); ++i) {
                    Mapping mapping = (Mapping)this.namespaces.get(i);
                    messageElement.addNamespaceDeclaration(mapping.getPrefix(), mapping.getNamespaceURI());
                }
            }
            messageElement.children = new ArrayList();
            messageElement.parent = null;
            messageElement.setDirty(this._isDirty);
            if (this.encodingStyle != null) {
                messageElement.setEncodingStyle(this.encodingStyle);
            }
            return messageElement;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setAllAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void detachAllChildren() {
        this.removeContents();
    }

    public Attributes getCompleteAttributes() {
        if (this.namespaces == null) {
            return this.attributes;
        }
        AttributesImpl attributesImpl = null;
        attributesImpl = this.attributes == NullAttributes.singleton ? new AttributesImpl() : new AttributesImpl(this.attributes);
        for (Mapping mapping : this.namespaces) {
            String string = mapping.getPrefix();
            String string2 = mapping.getNamespaceURI();
            attributesImpl.addAttribute("http://www.w3.org/2000/xmlns/", string, "xmlns:" + string, string2, "CDATA");
        }
        return attributesImpl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public QName getQName() {
        return new QName(this.namespaceURI, this.name);
    }

    public void setQName(QName qName) {
        this.name = qName.getLocalPart();
        this.namespaceURI = qName.getNamespaceURI();
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public QName getType() {
        MessageElement messageElement;
        if (this.typeQName == null && this.href != null && this.context != null && (messageElement = this.context.getElementByID(this.href)) != null) {
            this.typeQName = messageElement.getType();
        }
        return this.typeQName;
    }

    public void setType(QName qName) {
        this.typeQName = qName;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder sAX2EventRecorder) {
        this.recorder = sAX2EventRecorder;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.parent == null) {
                return "";
            }
            return ((MessageElement)this.parent).getEncodingStyle();
        }
        return this.encodingStyle;
    }

    public void removeContents() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                try {
                    ((NodeImpl)this.children.get(i)).setParent(null);
                    continue;
                }
                catch (SOAPException sOAPException) {
                    log.debug("ignoring", sOAPException);
                }
            }
            this.children.clear();
            this.setDirty(true);
        }
    }

    public Iterator getVisibleNamespacePrefixes() {
        Iterator iterator;
        Vector vector = new Vector();
        if (this.parent != null && (iterator = ((MessageElement)this.parent).getVisibleNamespacePrefixes()) != null) {
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        }
        if ((iterator = this.getNamespacePrefixes()) != null) {
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        }
        return vector.iterator();
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (string == null) {
            string = "";
        }
        this.encodingStyle = string;
        if (string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            this.addMapping(enc11Mapping);
        } else if (string.equals("http://www.w3.org/2003/05/soap-encoding")) {
            this.addMapping(enc12Mapping);
        }
    }

    public void addChild(MessageElement messageElement) throws SOAPException {
        if (this.objectValue != null) {
            IllegalStateException illegalStateException = new IllegalStateException(Messages.getMessage("valuePresent"));
            log.error(Messages.getMessage("valuePresent"), illegalStateException);
            throw illegalStateException;
        }
        this.initializeChildren();
        this.children.add(messageElement);
        messageElement.parent = this;
    }

    public List getChildren() {
        return this.children;
    }

    public void setContentsIndex(int n) {
        this.startContentsIndex = n;
    }

    public void setNSMappings(ArrayList arrayList) {
        this.namespaces = arrayList;
    }

    public String getPrefix(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        if (this.href != null && this.getRealElement() != null) {
            return this.getRealElement().getPrefix(string);
        }
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            Mapping mapping = (Mapping)this.namespaces.get(i);
            if (!mapping.getNamespaceURI().equals(string)) continue;
            return mapping.getPrefix();
        }
        if (this.parent != null) {
            return ((MessageElement)this.parent).getPrefix(string);
        }
        return null;
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            string = "";
        }
        if (this.href != null && this.getRealElement() != null) {
            return this.getRealElement().getNamespaceURI(string);
        }
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            Mapping mapping = (Mapping)this.namespaces.get(i);
            if (!mapping.getPrefix().equals(string)) continue;
            return mapping.getNamespaceURI();
        }
        if (this.parent != null) {
            return ((MessageElement)this.parent).getNamespaceURI(string);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("noPrefix00", "" + this, string));
        }
        return null;
    }

    public Object getObjectValue() {
        Object object = null;
        try {
            object = this.getObjectValue(null);
        }
        catch (Exception exception) {
            log.debug("getValue()", exception);
        }
        return object;
    }

    public Object getObjectValue(Class clazz) throws Exception {
        if (this.objectValue == null) {
            this.objectValue = this.getValueAsType(this.getType(), clazz);
        }
        return this.objectValue;
    }

    public void setObjectValue(Object object) throws SOAPException {
        if (this.children != null && !this.children.isEmpty()) {
            SOAPException sOAPException = new SOAPException(Messages.getMessage("childPresent"));
            log.error(Messages.getMessage("childPresent"), sOAPException);
            throw sOAPException;
        }
        if (this.textRep != null) {
            SOAPException sOAPException = new SOAPException(Messages.getMessage("xmlPresent"));
            log.error(Messages.getMessage("xmlPresent"), sOAPException);
            throw sOAPException;
        }
        this.objectValue = object;
    }

    public Object getValueAsType(QName qName) throws Exception {
        return this.getValueAsType(qName, null);
    }

    public Object getValueAsType(QName qName, Class clazz) throws Exception {
        if (this.context == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer deserializer = null;
        deserializer = clazz == null ? this.context.getDeserializerForType(qName) : this.context.getDeserializerForClass(clazz);
        if (deserializer == null) {
            throw new Exception(Messages.getMessage("noDeser00", "" + qName));
        }
        boolean bl = this.context.isDoneParsing();
        this.context.deserializing(true);
        this.context.pushElementHandler(new EnvelopeHandler((SOAPHandler)((Object)deserializer)));
        this.publishToHandler(this.context);
        this.context.deserializing(bl);
        return deserializer.getValue();
    }

    public void addAttribute(String string, String string2, QName qName) {
        if (this.qNameAttrs == null) {
            this.qNameAttrs = new Vector();
        }
        QNameAttr qNameAttr = new QNameAttr();
        qNameAttr.name = new QName(string, string2);
        qNameAttr.value = qName;
        this.qNameAttrs.addElement(qNameAttr);
    }

    public void addAttribute(String string, String string2, String string3) {
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        attributesImpl.addAttribute(string, string2, "", "CDATA", string3);
    }

    public void addAttribute(String string, String string2, String string3, String string4) {
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        String string5 = string3;
        if (string != null && string.length() > 0) {
            string5 = string + ":" + string3;
        }
        attributesImpl.addAttribute(string2, string3, string5, "CDATA", string4);
    }

    public void setAttribute(String string, String string2, String string3) {
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        int n = attributesImpl.getIndex(string, string2);
        if (n > -1) {
            if (string3 != null) {
                attributesImpl.setValue(n, string3);
            } else {
                attributesImpl.removeAttribute(n);
            }
            return;
        }
        this.addAttribute(string, string2, string3);
    }

    public String getAttributeValue(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(string);
    }

    public void setEnvelope(SOAPEnvelope sOAPEnvelope) {
        sOAPEnvelope.setDirty(true);
        this.message = sOAPEnvelope;
    }

    public SOAPEnvelope getEnvelope() {
        return this.message;
    }

    public MessageElement getRealElement() {
        if (this.href == null) {
            return this;
        }
        Object object = this.context.getObjectByRef(this.href);
        if (object == null) {
            return null;
        }
        if (!(object instanceof MessageElement)) {
            return null;
        }
        return (MessageElement)object;
    }

    public Document getAsDocument() throws Exception {
        String string = this.getAsString();
        StringReader stringReader = new StringReader(string);
        Document document = XMLUtils.newDocument(new InputSource(stringReader));
        if (document == null) {
            throw new Exception(Messages.getMessage("noDoc00", string));
        }
        return document;
    }

    public String getAsString() throws Exception {
        SerializationContext serializationContext = null;
        StringWriter stringWriter = new StringWriter();
        MessageContext messageContext = this.context != null ? this.context.getMessageContext() : MessageContext.getCurrentContext();
        serializationContext = new SerializationContext(stringWriter, messageContext);
        serializationContext.setSendDecl(false);
        this.setDirty(false);
        this.output(serializationContext);
        stringWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public Element getAsDOM() throws Exception {
        return this.getAsDocument().getDocumentElement();
    }

    public void publishToHandler(ContentHandler contentHandler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startEventIndex, this.endEventIndex, contentHandler);
    }

    public void publishContents(ContentHandler contentHandler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startContentsIndex, this.endEventIndex - 1, contentHandler);
    }

    public final void output(SerializationContext serializationContext) throws Exception {
        Object object;
        if (this.recorder != null && !this._isDirty) {
            this.recorder.replay(this.startEventIndex, this.endEventIndex, new SAXOutputter(serializationContext));
            return;
        }
        if (this.qNameAttrs != null) {
            for (int i = 0; i < this.qNameAttrs.size(); ++i) {
                object = (QNameAttr)this.qNameAttrs.get(i);
                QName qName = ((QNameAttr)object).name;
                this.setAttribute(qName.getNamespaceURI(), qName.getLocalPart(), serializationContext.qName2String(((QNameAttr)object).value));
            }
        }
        if (this.encodingStyle != null) {
            MessageContext messageContext = serializationContext.getMessageContext();
            Object object2 = object = messageContext != null ? messageContext.getSOAPConstants() : SOAPConstants.SOAP11_CONSTANTS;
            if (this.parent == null) {
                if (!"".equals(this.encodingStyle)) {
                    this.setAttribute(object.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
                }
            } else if (!this.encodingStyle.equals(((MessageElement)this.parent).getEncodingStyle())) {
                this.setAttribute(object.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
            }
        }
        this.outputImpl(serializationContext);
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        if (this.textRep != null) {
            boolean bl = serializationContext.getPretty();
            serializationContext.setPretty(false);
            if (this.textRep instanceof CDATASection) {
                serializationContext.writeString("<![CDATA[");
                serializationContext.writeString(this.textRep.getData());
                serializationContext.writeString("]]>");
            } else if (this.textRep instanceof Comment) {
                serializationContext.writeString("<!--");
                serializationContext.writeString(this.textRep.getData());
                serializationContext.writeString("-->");
            } else if (this.textRep instanceof org.w3c.dom.Text) {
                serializationContext.writeSafeString(this.textRep.getData());
            }
            serializationContext.setPretty(bl);
            return;
        }
        if (this.prefix != null) {
            serializationContext.registerPrefixForURI(this.prefix, this.namespaceURI);
        }
        if (this.namespaces != null) {
            for (Mapping mapping : this.namespaces) {
                serializationContext.registerPrefixForURI(mapping.getPrefix(), mapping.getNamespaceURI());
            }
        }
        if (this.objectValue != null) {
            serializationContext.serialize(new QName(this.namespaceURI, this.name), this.attributes, this.objectValue);
            return;
        }
        serializationContext.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((NodeImpl)iterator.next()).output(serializationContext);
            }
        }
        serializationContext.endElement();
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            return super.toString();
        }
    }

    public void addMapping(Mapping mapping) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(mapping);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        MessageElement messageElement = new MessageElement(name.getLocalName(), name.getPrefix(), name.getURI());
        this.addChild(messageElement);
        return messageElement;
    }

    public SOAPElement addChildElement(String string) throws SOAPException {
        MessageElement messageElement = new MessageElement(this.getNamespaceURI(), string);
        this.addChild(messageElement);
        return messageElement;
    }

    public SOAPElement addChildElement(String string, String string2) throws SOAPException {
        MessageElement messageElement = new MessageElement(this.getNamespaceURI(string2), string);
        messageElement.setPrefix(string2);
        this.addChild(messageElement);
        return messageElement;
    }

    public SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        MessageElement messageElement = new MessageElement(string3, string);
        messageElement.setPrefix(string2);
        messageElement.addNamespaceDeclaration(string2, string3);
        this.addChild(messageElement);
        return messageElement;
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        try {
            this.addChild((MessageElement)sOAPElement);
            this.setDirty(true);
            return sOAPElement;
        }
        catch (ClassCastException classCastException) {
            throw new SOAPException(classCastException);
        }
    }

    public SOAPElement addTextNode(String string) throws SOAPException {
        try {
            org.w3c.dom.Text text = this.getOwnerDocument().createTextNode(string);
            ((Text)text).setParentElement(this);
            return this;
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            Text text = new Text(string);
            this.appendChild(text);
            return this;
        }
        catch (ClassCastException classCastException) {
            throw new SOAPException(classCastException);
        }
    }

    public SOAPElement addAttribute(Name name, String string) throws SOAPException {
        try {
            this.addAttribute(name.getPrefix(), name.getURI(), name.getLocalName(), string);
        }
        catch (RuntimeException runtimeException) {
            throw new SOAPException(runtimeException);
        }
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String string, String string2) throws SOAPException {
        try {
            Mapping mapping = new Mapping(string2, string);
            this.addMapping(mapping);
        }
        catch (RuntimeException runtimeException) {
            throw new SOAPException(runtimeException);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        return this.attributes.getValue(name.getURI(), name.getLocalName());
    }

    public Iterator getAllAttributes() {
        int n = this.attributes.getLength();
        Vector<PrefixedQName> vector = new Vector<PrefixedQName>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.attributes.getQName(i);
            String string2 = "";
            if (string != null) {
                int n2 = string.indexOf(":");
                string2 = n2 > 0 ? string.substring(0, n2) : "";
            }
            vector.add(new PrefixedQName(this.attributes.getURI(i), this.attributes.getLocalName(i), string2));
        }
        return vector.iterator();
    }

    public Iterator getNamespacePrefixes() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            vector.add(((Mapping)this.namespaces.get(i)).getPrefix());
        }
        return vector.iterator();
    }

    public Name getElementName() {
        return new PrefixedQName(this.getNamespaceURI(), this.getName(), this.getPrefix());
    }

    public boolean removeAttribute(Name name) {
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        boolean bl = false;
        for (int i = 0; i < attributesImpl.getLength() && !bl; ++i) {
            if (!attributesImpl.getURI(i).equals(name.getURI()) || !attributesImpl.getLocalName(i).equals(name.getLocalName())) continue;
            attributesImpl.removeAttribute(i);
            bl = true;
        }
        return bl;
    }

    public boolean removeNamespaceDeclaration(String string) {
        this.makeAttributesEditable();
        boolean bl = false;
        for (int i = 0; this.namespaces != null && i < this.namespaces.size() && !bl; ++i) {
            if (!((Mapping)this.namespaces.get(i)).getPrefix().equals(string)) continue;
            this.namespaces.remove(i);
            bl = true;
        }
        return bl;
    }

    public Iterator getChildElements() {
        this.initializeChildren();
        return this.children.iterator();
    }

    public MessageElement getChildElement(QName qName) {
        if (this.children != null) {
            for (MessageElement messageElement : this.children) {
                if (!messageElement.getQName().equals(qName)) continue;
                return messageElement;
            }
        }
        return null;
    }

    public Iterator getChildElements(QName qName) {
        this.initializeChildren();
        int n = this.children.size();
        Vector<MessageElement> vector = new Vector<MessageElement>(n);
        for (int i = 0; i < n; ++i) {
            MessageElement messageElement = (MessageElement)this.children.get(i);
            Name name = messageElement.getElementName();
            if (!name.getURI().equals(qName.getNamespaceURI()) || !name.getLocalName().equals(qName.getLocalPart())) continue;
            vector.add(messageElement);
        }
        return vector.iterator();
    }

    public Iterator getChildElements(Name name) {
        return this.getChildElements(new QName(name.getURI(), name.getLocalName()));
    }

    public String getTagName() {
        return this.prefix == null ? this.name : this.prefix + ":" + this.name;
    }

    public void removeAttribute(String string) throws DOMException {
        AttributesImpl attributesImpl = (AttributesImpl)this.attributes;
        int n = attributesImpl.getIndex(string);
        if (n >= 0) {
            AttributesImpl attributesImpl2 = new AttributesImpl();
            for (int i = 0; i < attributesImpl.getLength(); ++i) {
                if (i == n) continue;
                String string2 = attributesImpl.getURI(i);
                String string3 = attributesImpl.getLocalName(i);
                String string4 = attributesImpl.getQName(i);
                String string5 = attributesImpl.getType(i);
                String string6 = attributesImpl.getValue(i);
                attributesImpl2.addAttribute(string2, string3, string4, string5, string6);
            }
            this.attributes = attributesImpl2;
        }
    }

    public boolean hasAttribute(String string) {
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!string.equals(this.attributes.getQName(i))) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(String string) {
        return this.attributes.getValue(string);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.makeAttributesEditable();
        PrefixedQName prefixedQName = new PrefixedQName(string, string2, null);
        this.removeAttribute(prefixedQName);
    }

    public void setAttribute(String string, String string2) throws DOMException {
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        int n = attributesImpl.getIndex(string);
        if (n < 0) {
            String string3 = "";
            String string4 = string;
            String string5 = string;
            String string6 = "CDDATA";
            attributesImpl.addAttribute(string3, string4, string5, string6, string2);
        } else {
            attributesImpl.setLocalName(n, string2);
        }
    }

    public boolean hasAttributeNS(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!string.equals(this.attributes.getURI(i)) || !string2.equals(this.attributes.getLocalName(i))) continue;
            return true;
        }
        return false;
    }

    public Attr getAttributeNode(String string) {
        return null;
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.makeAttributesEditable();
        PrefixedQName prefixedQName = new PrefixedQName(attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix());
        this.removeAttribute(prefixedQName);
        return attr;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        return attr;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        attributesImpl.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getLocalName(), "CDATA", attr.getValue());
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            if (!(this.children.get(i) instanceof Node)) continue;
            Node node = (Node)this.children.get(i);
            if (node.getLocalName() != null && node.getLocalName().equals(string)) {
                nodeListImpl.addNode(node);
            }
            if (!(node instanceof Element)) continue;
            NodeList nodeList = ((Element)node).getElementsByTagName(string);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                nodeListImpl.addNode(nodeList.item(j));
            }
        }
        return nodeListImpl;
    }

    public String getAttributeNS(String string, String string2) {
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!this.attributes.getURI(i).equals(string) || !this.attributes.getLocalName(i).equals(string2)) continue;
            return this.attributes.getValue(i);
        }
        return null;
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        String string4 = string2.substring(string2.indexOf(":") + 1, string2.length());
        if (string == null) {
            string = "intentionalNullURI";
        }
        attributesImpl.addAttribute(string, string4, string2, "CDATA", string3);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return this.getElementsNS(this, string, string2);
    }

    protected NodeList getElementsNS(Element element, String string, String string2) {
        NodeList nodeList = element.getChildNodes();
        NodeListImpl nodeListImpl = new NodeListImpl();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) instanceof org.w3c.dom.Text) continue;
            Element element2 = (Element)nodeList.item(i);
            if (string.equals(element2.getNamespaceURI()) && string2.equals(element2.getLocalName())) {
                nodeListImpl.addNode(element2);
            }
            nodeListImpl.addNodeList(element2.getElementsByTagNameNS(string, string2));
        }
        return nodeListImpl;
    }

    public Node item(int n) {
        if (this.children != null && this.children.size() > n) {
            return (Node)this.children.get(n);
        }
        return null;
    }

    public int getLength() {
        return this.children == null ? 0 : this.children.size();
    }

    protected MessageElement findElement(Vector vector, String string, String string2) {
        if (vector.isEmpty()) {
            return null;
        }
        QName qName = new QName(string, string2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)enumeration.nextElement();
            if (!messageElement.getQName().equals(qName)) continue;
            return messageElement;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MessageElement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.getLocalName().equals(((MessageElement)object).getLocalName())) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    private void copyNode(Node node) {
        this.copyNode(this, node);
    }

    private void copyNode(MessageElement messageElement, Node node) {
        Object object;
        messageElement.setPrefix(node.getPrefix());
        if (node.getLocalName() != null) {
            messageElement.setQName(new QName(node.getNamespaceURI(), node.getLocalName()));
        } else {
            messageElement.setQName(new QName(node.getNamespaceURI(), node.getNodeName()));
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNamespaceURI() != null && node2.getPrefix() != null && node2.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") && "xmlns".equals(node2.getPrefix())) {
                object = new Mapping(node2.getNodeValue(), node2.getLocalName());
                messageElement.addMapping((Mapping)object);
            }
            if (node2.getLocalName() != null) {
                messageElement.addAttribute(node2.getPrefix(), node2.getNamespaceURI() != null ? node2.getNamespaceURI() : "", node2.getLocalName(), node2.getNodeValue());
                continue;
            }
            if (node2.getNodeName() == null) continue;
            messageElement.addAttribute(node2.getPrefix(), node2.getNamespaceURI() != null ? node2.getNamespaceURI() : "", node2.getNodeName(), node2.getNodeValue());
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeImpl nodeImpl;
            object = nodeList.item(i);
            if (object.getNodeType() == 3 || object.getNodeType() == 4 || object.getNodeType() == 8) {
                nodeImpl = new Text((CharacterData)object);
                messageElement.appendChild(nodeImpl);
                continue;
            }
            nodeImpl = new MessageElement();
            messageElement.appendChild(nodeImpl);
            this.copyNode((MessageElement)nodeImpl, (Node)object);
        }
    }

    public String getValue() {
        if (this.textRep != null) {
            return this.textRep.getNodeValue();
        }
        if (this.objectValue != null) {
            return this.getValueDOM();
        }
        Iterator iterator = this.getChildElements();
        while (iterator.hasNext()) {
            NodeImpl nodeImpl = (NodeImpl)iterator.next();
            if (!(nodeImpl instanceof org.w3c.dom.Text)) continue;
            return ((org.w3c.dom.Text)((Object)nodeImpl)).getNodeValue();
        }
        return null;
    }

    protected String getValueDOM() {
        try {
            Node node;
            Element element = this.getAsDOM();
            if (element.hasChildNodes() && (node = element.getFirstChild()).getNodeType() == 3) {
                return node.getNodeValue();
            }
        }
        catch (Exception exception) {
            log.debug("getValue()", exception);
        }
        return null;
    }

    public void setValue(String string) {
        if (this.children == null) {
            try {
                this.setObjectValue(string);
            }
            catch (SOAPException sOAPException) {
                log.debug("setValue()", sOAPException);
            }
        }
        super.setValue(string);
    }

    public Document getOwnerDocument() {
        Document document = null;
        if (this.context != null && this.context.getEnvelope() != null && this.context.getEnvelope().getOwnerDocument() != null) {
            document = this.context.getEnvelope().getOwnerDocument();
        }
        if (document == null) {
            document = super.getOwnerDocument();
        }
        if (document == null) {
            document = new SOAPDocumentImpl(null);
        }
        return document;
    }

    protected static class QNameAttr {
        public QName name;
        public QName value;

        protected QNameAttr() {
        }
    }
}

