/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.toJava.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RPCElement
extends SOAPBodyElement {
    protected boolean needDeser = false;
    OperationDesc[] operations = null;

    public RPCElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext, OperationDesc[] operationDescArray) throws AxisFault {
        super(string, string2, string3, attributes, deserializationContext);
        this.needDeser = true;
        if (operationDescArray == null) {
            this.updateOperationsByName();
        } else {
            this.operations = operationDescArray;
        }
    }

    public RPCElement(String string, String string2, Object[] objectArray) {
        this.setNamespaceURI(string);
        this.name = string2;
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (objectArray[i] instanceof RPCParam) {
                this.addParam((RPCParam)objectArray[i]);
                continue;
            }
            String string3 = null;
            if (string3 == null) {
                string3 = "arg" + i;
            }
            this.addParam(new RPCParam(string, string3, objectArray[i]));
        }
    }

    public RPCElement(String string) {
        this.name = string;
    }

    public void updateOperationsByName() throws AxisFault {
        if (this.context == null) {
            return;
        }
        MessageContext messageContext = this.context.getMessageContext();
        if (messageContext == null) {
            return;
        }
        SOAPService sOAPService = messageContext.getService();
        if (sOAPService == null) {
            return;
        }
        ServiceDesc serviceDesc = sOAPService.getInitializedServiceDesc(messageContext);
        String string = Utils.xmlNameToJava(this.name);
        if (serviceDesc == null) {
            throw AxisFault.makeFault(new ClassNotFoundException(Messages.getMessage("noClassForService00", string)));
        }
        this.operations = serviceDesc.getOperationsByName(string);
    }

    public void updateOperationsByQName() throws AxisFault {
        if (this.context == null) {
            return;
        }
        MessageContext messageContext = this.context.getMessageContext();
        if (messageContext == null) {
            return;
        }
        this.operations = messageContext.getPossibleOperationsByQName(this.getQName());
    }

    public OperationDesc[] getOperations() {
        return this.operations;
    }

    public String getMethodName() {
        return this.name;
    }

    public void setNeedDeser(boolean bl) {
        this.needDeser = bl;
    }

    public void deserialize() throws SAXException {
        this.needDeser = false;
        MessageContext messageContext = this.context.getMessageContext();
        Message message = messageContext.getCurrentMessage();
        SOAPConstants sOAPConstants = messageContext.getSOAPConstants();
        boolean bl = message != null && "response".equals(message.getMessageType());
        RPCHandler rPCHandler = new RPCHandler(this, bl);
        if (this.operations != null) {
            Serializable serializable;
            int n = this.getChildren() == null ? 0 : this.getChildren().size();
            SAXException sAXException = null;
            boolean bl2 = messageContext.isPropertyTrue("acceptMissingParams", true);
            for (int i = 0; i < this.operations.length; ++i) {
                serializable = this.operations[i];
                boolean bl3 = this.needHeaderProcessing((OperationDesc)serializable, bl);
                if (((OperationDesc)serializable).getStyle() != Style.DOCUMENT && ((OperationDesc)serializable).getStyle() != Style.WRAPPED && ((OperationDesc)serializable).getUse() != Use.LITERAL && !(bl2 ? ((OperationDesc)serializable).getNumInParams() >= n : ((OperationDesc)serializable).getNumInParams() == n)) continue;
                boolean bl4 = ((OperationDesc)serializable).getUse() == Use.ENCODED;
                rPCHandler.setOperation((OperationDesc)serializable);
                try {
                    if (messageContext.isClient() && ((OperationDesc)serializable).getStyle() == Style.DOCUMENT || !messageContext.isClient() && ((OperationDesc)serializable).getStyle() == Style.DOCUMENT && ((OperationDesc)serializable).getNumInParams() > 0) {
                        this.context.pushElementHandler(rPCHandler);
                        this.context.setCurElement(null);
                    } else {
                        this.context.pushElementHandler(new EnvelopeHandler(rPCHandler));
                        this.context.setCurElement(this);
                    }
                    this.publishToHandler(this.context);
                    if (bl3) {
                        this.processHeaders((OperationDesc)serializable, bl, this.context, rPCHandler);
                    }
                    boolean bl5 = true;
                    List list = this.getParams2();
                    for (int j = 0; j < list.size() && bl5; ++j) {
                        RPCParam rPCParam = (RPCParam)list.get(j);
                        ArrayList arrayList = rPCParam.getObjectValue();
                        ParameterDesc parameterDesc = rPCParam.getParamDesc();
                        if (parameterDesc == null || parameterDesc.getJavaType() == null) continue;
                        Class clazz = parameterDesc.getJavaType();
                        if (clazz.isArray() && arrayList != null && JavaUtils.isConvertable(arrayList, clazz.getComponentType()) && !arrayList.getClass().isArray() && !(arrayList instanceof Collection)) {
                            ArrayList arrayList2 = new ArrayList();
                            arrayList2.add(arrayList);
                            arrayList = arrayList2;
                            rPCParam.setObjectValue(arrayList);
                        }
                        if (JavaUtils.isConvertable(arrayList, clazz, bl4)) continue;
                        bl5 = false;
                    }
                    if (bl5) {
                        messageContext.setOperation((OperationDesc)serializable);
                        return;
                    }
                    this.children = new ArrayList();
                    continue;
                }
                catch (SAXException sAXException2) {
                    sAXException = sAXException2;
                    this.children = new ArrayList();
                    continue;
                }
                catch (AxisFault axisFault) {
                    sAXException = new SAXException(axisFault);
                    this.children = new ArrayList();
                }
            }
            if (!messageContext.isClient() && sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_SENDER, "string", null, null);
                axisFault.addFaultSubCode(Constants.FAULT_SUBCODE_BADARGS);
                throw new SAXException(axisFault);
            }
            if (sAXException != null) {
                throw sAXException;
            }
            if (!messageContext.isClient()) {
                QName qName = new QName("Server.userException");
                if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    qName = Constants.FAULT_SOAP12_SENDER;
                }
                serializable = new AxisFault(qName, null, Messages.getMessage("noSuchOperation", this.name), null, null, null);
                throw new SAXException((Exception)serializable);
            }
        }
        if (this.operations != null) {
            rPCHandler.setOperation(this.operations[0]);
        }
        if (this.operations != null && this.operations.length > 0 && this.operations[0].getStyle() == Style.DOCUMENT) {
            this.context.pushElementHandler(rPCHandler);
            this.context.setCurElement(null);
        } else {
            this.context.pushElementHandler(new EnvelopeHandler(rPCHandler));
            this.context.setCurElement(this);
        }
        this.publishToHandler(this.context);
    }

    private List getParams2() {
        return this.getParams(new ArrayList());
    }

    private List getParams(List list) {
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (!(e instanceof RPCParam)) continue;
            list.add(e);
        }
        return list;
    }

    public RPCParam getParam(String string) throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        List list = this.getParams2();
        for (int i = 0; i < list.size(); ++i) {
            RPCParam rPCParam = (RPCParam)list.get(i);
            if (!rPCParam.getName().equals(string)) continue;
            return rPCParam;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        return (Vector)this.getParams(new Vector());
    }

    public void addParam(RPCParam rPCParam) {
        rPCParam.setRPCCall(this);
        this.initializeChildren();
        this.children.add(rPCParam);
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        boolean bl;
        MessageContext messageContext = serializationContext.getMessageContext();
        boolean bl2 = messageContext == null || messageContext.getOperationStyle() == Style.RPC || messageContext.getOperationStyle() == Style.WRAPPED;
        boolean bl3 = bl = this.getParams2().size() == 0;
        if (bl2 || bl) {
            if (this.encodingStyle != null && this.encodingStyle.equals("")) {
                serializationContext.registerPrefixForURI("", this.getNamespaceURI());
            }
            serializationContext.startElement(new QName(this.getNamespaceURI(), this.name), this.attributes);
        }
        if (bl) {
            if (this.children != null) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((NodeImpl)iterator.next()).output(serializationContext);
                }
            }
        } else {
            List list = this.getParams2();
            for (int i = 0; i < list.size(); ++i) {
                RPCParam rPCParam = (RPCParam)list.get(i);
                if (!bl2 && this.encodingStyle != null && this.encodingStyle.equals("")) {
                    serializationContext.registerPrefixForURI("", rPCParam.getQName().getNamespaceURI());
                }
                rPCParam.serialize(serializationContext);
            }
        }
        if (bl2 || bl) {
            serializationContext.endElement();
        }
    }

    private boolean needHeaderProcessing(OperationDesc operationDesc, boolean bl) {
        ArrayList arrayList = operationDesc.getParameters();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
                if ((bl || !parameterDesc.isInHeader()) && (!bl || !parameterDesc.isOutHeader())) continue;
                return true;
            }
        }
        return bl && operationDesc.getReturnParamDesc() != null && operationDesc.getReturnParamDesc().isOutHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeaders(OperationDesc operationDesc, boolean bl, DeserializationContext deserializationContext, RPCHandler rPCHandler) throws AxisFault, SAXException {
        try {
            Object object;
            SOAPElement sOAPElement;
            rPCHandler.setHeaderElement(true);
            for (sOAPElement = this.getParentElement(); sOAPElement != null && !(sOAPElement instanceof SOAPEnvelope); sOAPElement = sOAPElement.getParentElement()) {
            }
            if (sOAPElement == null) {
                return;
            }
            ArrayList arrayList = operationDesc.getParameters();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (ParameterDesc)arrayList.get(i);
                    if ((bl || !((ParameterDesc)object).isInHeader()) && (!bl || !((ParameterDesc)object).isOutHeader())) continue;
                    Enumeration enumeration = ((SOAPEnvelope)sOAPElement).getHeadersByName(((ParameterDesc)object).getQName().getNamespaceURI(), ((ParameterDesc)object).getQName().getLocalPart(), true);
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        deserializationContext.pushElementHandler(rPCHandler);
                        deserializationContext.setCurElement(null);
                        ((MessageElement)enumeration.nextElement()).publishToHandler(deserializationContext);
                    }
                }
            }
            if (bl && operationDesc.getReturnParamDesc() != null && operationDesc.getReturnParamDesc().isOutHeader()) {
                ParameterDesc parameterDesc = operationDesc.getReturnParamDesc();
                object = ((SOAPEnvelope)sOAPElement).getHeadersByName(parameterDesc.getQName().getNamespaceURI(), parameterDesc.getQName().getLocalPart(), true);
                while (object != null && object.hasMoreElements()) {
                    deserializationContext.pushElementHandler(rPCHandler);
                    deserializationContext.setCurElement(null);
                    ((MessageElement)object.nextElement()).publishToHandler(deserializationContext);
                }
            }
        }
        finally {
            rPCHandler.setHeaderElement(false);
        }
    }
}

