/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class RPCParam
extends MessageElement
implements Serializable {
    protected static Log log = LogFactory.getLog(RPCParam.class.getName());
    private Object value = null;
    private int countSetCalls = 0;
    private ParameterDesc paramDesc;
    private Boolean wantXSIType = null;
    private static Method valueSetMethod;

    public RPCParam(String string, Object object) {
        this(new QName("", string), object);
    }

    public RPCParam(QName qName, Object object) {
        super(qName);
        if (object instanceof String) {
            try {
                this.addTextNode((String)object);
            }
            catch (SOAPException sOAPException) {
                throw new RuntimeException(Messages.getMessage("cannotCreateTextNode00"));
            }
        } else {
            this.value = object;
        }
    }

    public RPCParam(String string, String string2, Object object) {
        this(new QName(string, string2), object);
    }

    public void setRPCCall(RPCElement rPCElement) {
        this.parent = rPCElement;
    }

    public Object getObjectValue() {
        return this.value;
    }

    public void setObjectValue(Object object) {
        this.value = object;
    }

    public void set(Object object) {
        ++this.countSetCalls;
        if (this.countSetCalls == 1) {
            this.value = object;
            return;
        }
        if (this.countSetCalls == 2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.value);
            this.value = arrayList;
        }
        ((ArrayList)this.value).add(object);
    }

    public static Method getValueSetMethod() {
        return valueSetMethod;
    }

    public ParameterDesc getParamDesc() {
        return this.paramDesc;
    }

    public void setParamDesc(ParameterDesc parameterDesc) {
        this.paramDesc = parameterDesc;
    }

    public void setXSITypeGeneration(Boolean bl) {
        this.wantXSIType = bl;
    }

    public Boolean getXSITypeGeneration() {
        return this.wantXSIType;
    }

    public void serialize(SerializationContext serializationContext) throws IOException {
        Class clazz = this.value == null ? null : this.value.getClass();
        QName qName = null;
        if (this.paramDesc != null) {
            Object object;
            Serializable serializable;
            if (clazz == null) {
                clazz = this.paramDesc.getJavaType() != null ? this.paramDesc.getJavaType() : clazz;
            } else if (!(clazz.equals(this.paramDesc.getJavaType()) || (serializable = JavaUtils.getPrimitiveClass(clazz)) != null && serializable.equals(this.paramDesc.getJavaType()) || clazz.equals(JavaUtils.getHolderValueType(this.paramDesc.getJavaType())))) {
                this.wantXSIType = Boolean.TRUE;
            }
            qName = this.paramDesc.getTypeQName();
            serializable = this.paramDesc.getItemQName();
            if (serializable == null && (object = serializationContext.getMessageContext()) != null && ((MessageContext)object).getOperation() != null && ((MessageContext)object).getOperation().getStyle() == Style.DOCUMENT) {
                serializable = Constants.QNAME_LITERAL_ITEM;
            }
            serializationContext.setItemQName((QName)serializable);
            object = this.paramDesc.getItemType();
            serializationContext.setItemType((QName)object);
        }
        serializationContext.serialize(this.getQName(), (Attributes)null, this.value, qName, Boolean.TRUE, this.wantXSIType);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getQName() == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.getQName().getNamespaceURI());
            objectOutputStream.writeObject(this.getQName().getLocalPart());
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream.readBoolean()) {
            this.setQName(new QName((String)objectInputStream.readObject(), (String)objectInputStream.readObject()));
        }
        objectInputStream.defaultReadObject();
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        this.serialize(serializationContext);
    }

    public String getValue() {
        return this.getValueDOM();
    }

    public SOAPElement addTextNode(String string) throws SOAPException {
        this.value = string;
        return super.addTextNode(string);
    }

    public void setValue(String string) {
        this.value = string;
        super.setValue(string);
    }

    static {
        Class<RPCParam> clazz = RPCParam.class;
        try {
            valueSetMethod = clazz.getMethod("set", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.error(Messages.getMessage("noValue00", "" + noSuchMethodException));
            throw new RuntimeException(noSuchMethodException.getMessage());
        }
    }
}

