/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.MessageElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAX2EventRecorder {
    private static final Integer Z = new Integer(0);
    private static final Integer STATE_SET_DOCUMENT_LOCATOR = new Integer(0);
    private static final Integer STATE_START_DOCUMENT = new Integer(1);
    private static final Integer STATE_END_DOCUMENT = new Integer(2);
    private static final Integer STATE_START_PREFIX_MAPPING = new Integer(3);
    private static final Integer STATE_END_PREFIX_MAPPING = new Integer(4);
    private static final Integer STATE_START_ELEMENT = new Integer(5);
    private static final Integer STATE_END_ELEMENT = new Integer(6);
    private static final Integer STATE_CHARACTERS = new Integer(7);
    private static final Integer STATE_IGNORABLE_WHITESPACE = new Integer(8);
    private static final Integer STATE_PROCESSING_INSTRUCTION = new Integer(9);
    private static final Integer STATE_SKIPPED_ENTITY = new Integer(10);
    private static final Integer STATE_NEWELEMENT = new Integer(11);
    private static final Integer STATE_START_DTD = new Integer(12);
    private static final Integer STATE_END_DTD = new Integer(13);
    private static final Integer STATE_START_ENTITY = new Integer(14);
    private static final Integer STATE_END_ENTITY = new Integer(15);
    private static final Integer STATE_START_CDATA = new Integer(16);
    private static final Integer STATE_END_CDATA = new Integer(17);
    private static final Integer STATE_COMMENT = new Integer(18);
    Locator locator;
    objArrayVector events = new objArrayVector();

    public void clear() {
        this.locator = null;
        this.events = new objArrayVector();
    }

    public int getLength() {
        return this.events.getLength();
    }

    public int setDocumentLocator(Locator locator) {
        this.locator = locator;
        return this.events.add(STATE_SET_DOCUMENT_LOCATOR, Z, Z, Z, Z);
    }

    public int startDocument() {
        return this.events.add(STATE_START_DOCUMENT, Z, Z, Z, Z);
    }

    public int endDocument() {
        return this.events.add(STATE_END_DOCUMENT, Z, Z, Z, Z);
    }

    public int startPrefixMapping(String string, String string2) {
        return this.events.add(STATE_START_PREFIX_MAPPING, string, string2, Z, Z);
    }

    public int endPrefixMapping(String string) {
        return this.events.add(STATE_END_PREFIX_MAPPING, string, Z, Z, Z);
    }

    public int startElement(String string, String string2, String string3, Attributes attributes) {
        return this.events.add(STATE_START_ELEMENT, string, string2, string3, attributes);
    }

    public int endElement(String string, String string2, String string3) {
        return this.events.add(STATE_END_ELEMENT, string, string2, string3, Z);
    }

    public int characters(char[] cArray, int n, int n2) {
        return this.events.add(STATE_CHARACTERS, SAX2EventRecorder.clone(cArray, n, n2), Z, Z, Z);
    }

    public int ignorableWhitespace(char[] cArray, int n, int n2) {
        return this.events.add(STATE_IGNORABLE_WHITESPACE, SAX2EventRecorder.clone(cArray, n, n2), Z, Z, Z);
    }

    public int processingInstruction(String string, String string2) {
        return this.events.add(STATE_PROCESSING_INSTRUCTION, string, string2, Z, Z);
    }

    public int skippedEntity(String string) {
        return this.events.add(STATE_SKIPPED_ENTITY, string, Z, Z, Z);
    }

    public void startDTD(String string, String string2, String string3) {
        this.events.add(STATE_START_DTD, string, string2, string3, Z);
    }

    public void endDTD() {
        this.events.add(STATE_END_DTD, Z, Z, Z, Z);
    }

    public void startEntity(String string) {
        this.events.add(STATE_START_ENTITY, string, Z, Z, Z);
    }

    public void endEntity(String string) {
        this.events.add(STATE_END_ENTITY, string, Z, Z, Z);
    }

    public void startCDATA() {
        this.events.add(STATE_START_CDATA, Z, Z, Z, Z);
    }

    public void endCDATA() {
        this.events.add(STATE_END_CDATA, Z, Z, Z, Z);
    }

    public void comment(char[] cArray, int n, int n2) {
        this.events.add(STATE_COMMENT, SAX2EventRecorder.clone(cArray, n, n2), Z, Z, Z);
    }

    public int newElement(MessageElement messageElement) {
        return this.events.add(STATE_NEWELEMENT, messageElement, Z, Z, Z);
    }

    public void replay(ContentHandler contentHandler) throws SAXException {
        if (this.events.getLength() > 0) {
            this.replay(0, this.events.getLength() - 1, contentHandler);
        }
    }

    public void replay(int n, int n2, ContentHandler contentHandler) throws SAXException {
        if (n == 0 && n2 == -1) {
            this.replay(contentHandler);
            return;
        }
        if (n2 + 1 > this.events.getLength() || n2 < n) {
            return;
        }
        LexicalHandler lexicalHandler = null;
        if (contentHandler instanceof LexicalHandler) {
            lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
        for (int i = n; i <= n2; ++i) {
            Object object;
            Object object2 = this.events.get(i, 0);
            if (object2 == STATE_START_ELEMENT) {
                contentHandler.startElement((String)this.events.get(i, 1), (String)this.events.get(i, 2), (String)this.events.get(i, 3), (Attributes)this.events.get(i, 4));
                continue;
            }
            if (object2 == STATE_END_ELEMENT) {
                contentHandler.endElement((String)this.events.get(i, 1), (String)this.events.get(i, 2), (String)this.events.get(i, 3));
                continue;
            }
            if (object2 == STATE_CHARACTERS) {
                object = (char[])this.events.get(i, 1);
                contentHandler.characters((char[])object, 0, ((char[])object).length);
                continue;
            }
            if (object2 == STATE_IGNORABLE_WHITESPACE) {
                object = (char[])this.events.get(i, 1);
                contentHandler.ignorableWhitespace((char[])object, 0, ((char[])object).length);
                continue;
            }
            if (object2 == STATE_PROCESSING_INSTRUCTION) {
                contentHandler.processingInstruction((String)this.events.get(i, 1), (String)this.events.get(i, 2));
                continue;
            }
            if (object2 == STATE_SKIPPED_ENTITY) {
                contentHandler.skippedEntity((String)this.events.get(i, 1));
                continue;
            }
            if (object2 == STATE_SET_DOCUMENT_LOCATOR) {
                contentHandler.setDocumentLocator(this.locator);
                continue;
            }
            if (object2 == STATE_START_DOCUMENT) {
                contentHandler.startDocument();
                continue;
            }
            if (object2 == STATE_END_DOCUMENT) {
                contentHandler.endDocument();
                continue;
            }
            if (object2 == STATE_START_PREFIX_MAPPING) {
                contentHandler.startPrefixMapping((String)this.events.get(i, 1), (String)this.events.get(i, 2));
                continue;
            }
            if (object2 == STATE_END_PREFIX_MAPPING) {
                contentHandler.endPrefixMapping((String)this.events.get(i, 1));
                continue;
            }
            if (object2 == STATE_START_DTD && lexicalHandler != null) {
                lexicalHandler.startDTD((String)this.events.get(i, 1), (String)this.events.get(i, 2), (String)this.events.get(i, 3));
                continue;
            }
            if (object2 == STATE_END_DTD && lexicalHandler != null) {
                lexicalHandler.endDTD();
                continue;
            }
            if (object2 == STATE_START_ENTITY && lexicalHandler != null) {
                lexicalHandler.startEntity((String)this.events.get(i, 1));
                continue;
            }
            if (object2 == STATE_END_ENTITY && lexicalHandler != null) {
                lexicalHandler.endEntity((String)this.events.get(i, 1));
                continue;
            }
            if (object2 == STATE_START_CDATA && lexicalHandler != null) {
                lexicalHandler.startCDATA();
                continue;
            }
            if (object2 == STATE_END_CDATA && lexicalHandler != null) {
                lexicalHandler.endCDATA();
                continue;
            }
            if (object2 == STATE_COMMENT && lexicalHandler != null) {
                object = (char[])this.events.get(i, 1);
                lexicalHandler.comment((char[])object, 0, ((char[])object).length);
                continue;
            }
            if (object2 != STATE_NEWELEMENT || !(contentHandler instanceof DeserializationContext)) continue;
            object = (DeserializationContext)contentHandler;
            ((DeserializationContext)object).setCurElement((MessageElement)this.events.get(i, 1));
        }
    }

    private static char[] clone(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    class objArrayVector {
        private int RECORD_SIZE = 5;
        private int currentSize = 0;
        private Object[] objarray = new Object[50 * this.RECORD_SIZE];

        objArrayVector() {
        }

        public int add(Object object, Object object2, Object object3, Object object4, Object object5) {
            if (this.currentSize == this.objarray.length) {
                Object[] objectArray = new Object[this.currentSize * 2];
                System.arraycopy(this.objarray, 0, objectArray, 0, this.currentSize);
                this.objarray = objectArray;
            }
            int n = this.currentSize / this.RECORD_SIZE;
            this.objarray[this.currentSize++] = object;
            this.objarray[this.currentSize++] = object2;
            this.objarray[this.currentSize++] = object3;
            this.objarray[this.currentSize++] = object4;
            this.objarray[this.currentSize++] = object5;
            return n;
        }

        public Object get(int n, int n2) {
            return this.objarray[n * this.RECORD_SIZE + n2];
        }

        public int getLength() {
            return this.currentSize / this.RECORD_SIZE;
        }
    }
}

