/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXOutputter
extends DefaultHandler
implements LexicalHandler {
    protected static Log log = LogFactory.getLog(SAXOutputter.class.getName());
    SerializationContext context;
    boolean isCDATA = false;

    public SAXOutputter(SerializationContext serializationContext) {
        this.context = serializationContext;
    }

    public void startDocument() throws SAXException {
        this.context.setSendDecl(true);
    }

    public void endDocument() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("SAXOutputter.endDocument");
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.context.registerPrefixForURI(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("SAXOutputter.characters ['" + new String(cArray, n, n2) + "']");
        }
        try {
            if (!this.isCDATA) {
                this.context.writeChars(cArray, n, n2);
            } else {
                this.context.writeString(new String(cArray, n, n2));
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.context.writeChars(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("SAXOutputter.startElement ['" + string + "' " + string2 + "]");
        }
        try {
            this.context.startElement(new QName(string, string2), attributes);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("SAXOutputter.endElement ['" + string + "' " + string2 + "]");
        }
        try {
            this.context.endElement();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        try {
            this.isCDATA = true;
            this.context.writeString("<![CDATA[");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endCDATA() throws SAXException {
        try {
            this.isCDATA = false;
            this.context.writeString("]]>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("SAXOutputter.comment ['" + new String(cArray, n, n2) + "']");
        }
        try {
            this.context.writeString("<!--");
            this.context.writeChars(cArray, n, n2);
            this.context.writeString("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }
}

