/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.SOAPPart;
import org.apache.axis.message.CDATAImpl;
import org.apache.axis.message.CommentImpl;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.NodeListImpl;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.Text;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.UserDataHandler;

public class SOAPDocumentImpl
implements Document,
Serializable {
    protected Document delegate = null;
    protected SOAPPart soapPart = null;
    private String[] features = new String[]{"foo", "bar"};
    private String version = "version 2.0";

    public SOAPDocumentImpl(SOAPPart sOAPPart) {
        try {
            this.delegate = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.soapPart = sOAPPart;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node node) {
        return 0;
    }

    public String getTextContent() {
        return null;
    }

    public void setTextContent(String string) {
    }

    public boolean isSameNode(Node node) {
        return false;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return true;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public boolean isEqualNode(Node node) {
        return false;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return true;
    }

    public void setXmlStandalone(boolean bl) {
    }

    public String getXmlVersion() {
        return "1.0";
    }

    public void setXmlVersion(String string) {
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean bl) {
    }

    public String getDocumentURI() {
        return null;
    }

    public void setDocumentURI(String string) {
    }

    public Node adoptNode(Node node) {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node node, String string, String string2) {
        return node;
    }

    public DocumentType getDoctype() {
        return this.delegate.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.delegate.getImplementation();
    }

    public Element getDocumentElement() {
        return this.soapPart.getDocumentElement();
    }

    public Element createElement(String string) throws DOMException {
        String string2;
        String string3;
        int n = string.indexOf(":");
        if (n < 0) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        try {
            SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.soapPart.getEnvelope();
            if (sOAPEnvelope != null) {
                if (string.equalsIgnoreCase("Envelope")) {
                    new SOAPEnvelope();
                }
                if (string.equalsIgnoreCase("Header")) {
                    return new SOAPHeader(sOAPEnvelope, sOAPEnvelope.getSOAPConstants());
                }
                if (string.equalsIgnoreCase("Body")) {
                    return new SOAPBody(sOAPEnvelope, sOAPEnvelope.getSOAPConstants());
                }
                if (string.equalsIgnoreCase("Fault")) {
                    return new SOAPEnvelope();
                }
                if (string.equalsIgnoreCase("detail")) {
                    return new SOAPFault(new AxisFault(string));
                }
                return new MessageElement("", string3, string2);
            }
            return new MessageElement("", string3, string2);
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public DocumentFragment createDocumentFragment() {
        return this.delegate.createDocumentFragment();
    }

    public org.w3c.dom.Text createTextNode(String string) {
        Text text = new Text(this.delegate.createTextNode(string));
        text.setOwnerDocument(this.soapPart);
        return text;
    }

    public Comment createComment(String string) {
        return new CommentImpl(string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATAImpl(string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new UnsupportedOperationException("createProcessingInstruction");
    }

    public Attr createAttribute(String string) throws DOMException {
        return this.delegate.createAttribute(string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        throw new UnsupportedOperationException("createEntityReference");
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2 = null;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Element element = (Element)node;
                if (bl) {
                    node2 = new SOAPBodyElement(element);
                    break;
                }
                SOAPBodyElement sOAPBodyElement = new SOAPBodyElement();
                NamedNodeMap namedNodeMap = element.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node3 = namedNodeMap.item(i);
                    if (node3.getNamespaceURI() != null && node3.getPrefix() != null && node3.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") && node3.getPrefix().equals("xmlns")) {
                        Mapping mapping = new Mapping(node3.getNodeValue(), node3.getLocalName());
                        sOAPBodyElement.addMapping(mapping);
                    }
                    if (node3.getLocalName() != null) {
                        sOAPBodyElement.addAttribute(node3.getPrefix(), node3.getNamespaceURI(), node3.getLocalName(), node3.getNodeValue());
                        continue;
                    }
                    if (node3.getNodeName() == null) continue;
                    sOAPBodyElement.addAttribute(node3.getPrefix(), node3.getNamespaceURI(), node3.getNodeName(), node3.getNodeValue());
                }
                if (element.getLocalName() == null) {
                    sOAPBodyElement.setName(element.getNodeName());
                } else {
                    sOAPBodyElement.setQName(new QName(element.getNamespaceURI(), element.getLocalName()));
                }
                node2 = sOAPBodyElement;
                break;
            }
            case 2: {
                if (node.getLocalName() == null) {
                    node2 = this.createAttribute(node.getNodeName());
                    break;
                }
                node2 = this.createAttributeNS(node.getNamespaceURI(), node.getLocalName());
                break;
            }
            case 3: {
                node2 = this.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                node2 = this.createCDATASection(node.getNodeValue());
                break;
            }
            case 8: {
                node2 = this.createComment(node.getNodeValue());
                break;
            }
            case 11: {
                node2 = this.createDocumentFragment();
                if (!bl) break;
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node2.appendChild(this.importNode(nodeList.item(i), true));
                }
                break;
            }
            case 5: {
                node2 = this.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                node2 = this.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 6: {
                throw new DOMException(9, "Entity nodes are not supported.");
            }
            case 12: {
                throw new DOMException(9, "Notation nodes are not supported.");
            }
            case 10: {
                throw new DOMException(9, "DocumentType nodes cannot be imported.");
            }
            case 9: {
                throw new DOMException(9, "Document nodes cannot be imported.");
            }
            default: {
                throw new DOMException(9, "Node type (" + s + ") cannot be imported.");
            }
        }
        return node2;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        SOAPConstants sOAPConstants = null;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(string)) {
            sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
        } else if ("http://www.w3.org/2003/05/soap-envelope".equals(string)) {
            sOAPConstants = SOAPConstants.SOAP12_CONSTANTS;
        }
        MessageElement messageElement = null;
        if (sOAPConstants != null) {
            if (string2.equals("Envelope")) {
                messageElement = new SOAPEnvelope(sOAPConstants);
            } else if (string2.equals("Header")) {
                messageElement = new SOAPHeader(null, sOAPConstants);
            } else if (string2.equals("Body")) {
                messageElement = new SOAPBody(null, sOAPConstants);
            } else if (string2.equals("Fault")) {
                messageElement = null;
            } else if (string2.equals("detail")) {
                messageElement = null;
            } else {
                throw new DOMException(11, "No such Localname for SOAP URI");
            }
            return null;
        }
        messageElement = new MessageElement(string, string2);
        if (messageElement != null) {
            messageElement.setOwnerDocument(this.soapPart);
        }
        return messageElement;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return this.delegate.createAttributeNS(string, string2);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        try {
            NodeListImpl nodeListImpl = new NodeListImpl();
            if (this.soapPart != null) {
                SOAPBody sOAPBody;
                SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.soapPart.getEnvelope();
                SOAPHeader sOAPHeader = (SOAPHeader)sOAPEnvelope.getHeader();
                if (sOAPHeader != null) {
                    nodeListImpl.addNodeList(sOAPHeader.getElementsByTagNameNS(string, string2));
                }
                if ((sOAPBody = (SOAPBody)sOAPEnvelope.getBody()) != null) {
                    nodeListImpl.addNodeList(sOAPBody.getElementsByTagNameNS(string, string2));
                }
            }
            return nodeListImpl;
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public NodeList getElementsByTagName(String string) {
        try {
            NodeListImpl nodeListImpl = new NodeListImpl();
            if (this.soapPart != null) {
                SOAPBody sOAPBody;
                SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.soapPart.getEnvelope();
                SOAPHeader sOAPHeader = (SOAPHeader)sOAPEnvelope.getHeader();
                if (sOAPHeader != null) {
                    nodeListImpl.addNodeList(sOAPHeader.getElementsByTagName(string));
                }
                if ((sOAPBody = (SOAPBody)sOAPEnvelope.getBody()) != null) {
                    nodeListImpl.addNodeList(sOAPBody.getElementsByTagName(string));
                }
            }
            return nodeListImpl;
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public Element getElementById(String string) {
        return this.delegate.getElementById(string);
    }

    public String getNodeName() {
        return null;
    }

    public String getNodeValue() throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.get in " + this);
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.set in " + this);
    }

    public short getNodeType() {
        return 9;
    }

    public Node getParentNode() {
        return null;
    }

    public NodeList getChildNodes() {
        try {
            if (this.soapPart != null) {
                NodeListImpl nodeListImpl = new NodeListImpl();
                nodeListImpl.addNode(this.soapPart.getEnvelope());
                return nodeListImpl;
            }
            return NodeListImpl.EMPTY_NODELIST;
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public Node getFirstChild() {
        try {
            if (this.soapPart != null) {
                return (SOAPEnvelope)this.soapPart.getEnvelope();
            }
            return null;
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public Node getLastChild() {
        try {
            if (this.soapPart != null) {
                return (SOAPEnvelope)this.soapPart.getEnvelope();
            }
            return null;
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DOMException(9, "");
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DOMException(9, "");
    }

    public Node removeChild(Node node) throws DOMException {
        try {
            javax.xml.soap.SOAPEnvelope sOAPEnvelope;
            if (this.soapPart != null && (sOAPEnvelope = this.soapPart.getEnvelope()).equals(node)) {
                return sOAPEnvelope;
            }
            throw new DOMException(9, "");
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public Node appendChild(Node node) throws DOMException {
        throw new DOMException(9, "");
    }

    public boolean hasChildNodes() {
        try {
            return this.soapPart != null && this.soapPart.getEnvelope() != null;
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, "");
        }
    }

    public Node cloneNode(boolean bl) {
        throw new DOMException(9, "");
    }

    public void normalize() {
        throw new DOMException(9, "");
    }

    public boolean isSupported(String string, String string2) {
        return string2.equalsIgnoreCase(string2);
    }

    public String getPrefix() {
        throw new DOMException(9, "");
    }

    public void setPrefix(String string) {
        throw new DOMException(9, "");
    }

    public String getNamespaceURI() {
        throw new DOMException(9, "");
    }

    public void setNamespaceURI(String string) {
        throw new DOMException(9, "");
    }

    public String getLocalName() {
        throw new DOMException(9, "");
    }

    public boolean hasAttributes() {
        throw new DOMException(9, "");
    }
}

