/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.security.servlet;

import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.security.AuthenticatedUser;
import org.apache.axis.security.SecurityProvider;
import org.apache.axis.security.servlet.ServletAuthenticatedUser;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class ServletSecurityProvider
implements SecurityProvider {
    protected static Log log = LogFactory.getLog(ServletSecurityProvider.class.getName());
    static HashMap users = null;

    public AuthenticatedUser authenticate(MessageContext messageContext) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (httpServletRequest == null) {
            return null;
        }
        log.debug(Messages.getMessage("got00", "HttpServletRequest"));
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal == null) {
            log.debug(Messages.getMessage("noPrincipal00"));
            return null;
        }
        log.debug(Messages.getMessage("gotPrincipal00", principal.getName()));
        return new ServletAuthenticatedUser(httpServletRequest);
    }

    public boolean userMatches(AuthenticatedUser authenticatedUser, String string) {
        if (authenticatedUser == null) {
            return string == null;
        }
        if (authenticatedUser instanceof ServletAuthenticatedUser) {
            ServletAuthenticatedUser servletAuthenticatedUser = (ServletAuthenticatedUser)authenticatedUser;
            return servletAuthenticatedUser.getRequest().isUserInRole(string);
        }
        return false;
    }
}

