/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.i18n.Messages;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisServletBase;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AutoRegisterServlet
extends AxisServletBase {
    private static Log log = LogFactory.getLog(AutoRegisterServlet.class.getName());

    public void init() throws ServletException {
        log.debug(Messages.getMessage("autoRegServletInit00"));
        this.autoRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStream(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        try {
            Document document = XMLUtils.newDocument(inputStream);
            WSDDDocument wSDDDocument = new WSDDDocument(document);
            WSDDDeployment wSDDDeployment = this.getDeployment();
            if (wSDDDeployment != null) {
                wSDDDocument.deploy(wSDDDeployment);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public void registerResource(String string) throws SAXException, ParserConfigurationException, IOException {
        InputStream inputStream = this.getServletContext().getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        this.registerStream(inputStream);
    }

    public void registerFile(File file) throws IOException, SAXException, ParserConfigurationException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        this.registerStream(bufferedInputStream);
    }

    public String[] getResourcesToRegister() {
        return null;
    }

    private WSDDDeployment getDeployment() throws AxisFault {
        AxisServer axisServer = this.getEngine();
        EngineConfiguration engineConfiguration = axisServer.getConfig();
        WSDDDeployment wSDDDeployment = engineConfiguration instanceof WSDDEngineConfiguration ? ((WSDDEngineConfiguration)engineConfiguration).getDeployment() : null;
        return wSDDDeployment;
    }

    protected void logSuccess(String string) {
        log.debug(Messages.getMessage("autoRegServletLoaded01", string));
    }

    protected void autoRegister() {
        String[] stringArray = this.getResourcesToRegister();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.registerAndLogResource(string);
        }
        this.registerAnythingElse();
        try {
            this.applyAndSaveSettings();
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("autoRegServletApplyAndSaveSettings00"), exception);
        }
    }

    protected void registerAnythingElse() {
    }

    public void registerAndLogResource(String string) {
        try {
            this.registerResource(string);
            this.logSuccess(string);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("autoRegServletLoadFailed01", string), exception);
        }
    }

    protected void applyAndSaveSettings() throws AxisFault, ConfigurationException {
        AxisServer axisServer = this.getEngine();
        axisServer.refreshGlobalOptions();
        axisServer.saveConfiguration();
    }
}

