/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis.session.Session;

public class AxisHttpSession
implements Session {
    public static final String AXIS_SESSION_MARKER = "axis.isAxisSession";
    private HttpSession rep;
    private HttpServletRequest req;

    public AxisHttpSession(HttpServletRequest httpServletRequest) {
        this.req = httpServletRequest;
    }

    public AxisHttpSession(HttpSession httpSession) {
        if (httpSession != null) {
            this.setRep(httpSession);
        }
    }

    public HttpSession getRep() {
        this.ensureSession();
        return this.rep;
    }

    private void setRep(HttpSession httpSession) {
        this.rep = httpSession;
        this.rep.setAttribute(AXIS_SESSION_MARKER, Boolean.TRUE);
    }

    public Object get(String string) {
        this.ensureSession();
        return this.rep.getAttribute(string);
    }

    public void set(String string, Object object) {
        this.ensureSession();
        this.rep.setAttribute(string, object);
    }

    public void remove(String string) {
        this.ensureSession();
        this.rep.removeAttribute(string);
    }

    public Enumeration getKeys() {
        this.ensureSession();
        return this.rep.getAttributeNames();
    }

    public void setTimeout(int n) {
        this.ensureSession();
        this.rep.setMaxInactiveInterval(n);
    }

    public int getTimeout() {
        this.ensureSession();
        return this.rep.getMaxInactiveInterval();
    }

    public void touch() {
    }

    public void invalidate() {
        this.rep.invalidate();
    }

    protected void ensureSession() {
        if (this.rep == null) {
            this.setRep(this.req.getSession());
        }
    }

    public Object getLockObject() {
        this.ensureSession();
        return this.rep;
    }
}

