/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSEndpoint;
import org.apache.axis.transport.jms.JMSURLHelper;
import org.apache.axis.transport.jms.Subscription;

public class QueueConnector
extends JMSConnector {
    public QueueConnector(ConnectionFactory connectionFactory, int n, int n2, long l, long l2, long l3, boolean bl, String string, String string2, String string3, JMSVendorAdapter jMSVendorAdapter, JMSURLHelper jMSURLHelper) throws JMSException {
        super(connectionFactory, n, n2, l, l2, l3, bl, string, string2, string3, jMSVendorAdapter, jMSURLHelper);
    }

    public JMSEndpoint createEndpoint(String string) {
        return new QueueEndpoint(string);
    }

    public JMSEndpoint createEndpoint(Destination destination) throws JMSException {
        if (!(destination instanceof Queue)) {
            throw new IllegalArgumentException("The input must be a queue for this connector");
        }
        return new QueueDestinationEndpoint((Queue)destination);
    }

    protected Connection internalConnect(ConnectionFactory connectionFactory, String string, String string2) throws JMSException {
        QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)connectionFactory;
        if (string == null) {
            return queueConnectionFactory.createQueueConnection();
        }
        return queueConnectionFactory.createQueueConnection(string, string2);
    }

    protected JMSConnector.SyncConnection createSyncConnection(ConnectionFactory connectionFactory, Connection connection, int n, String string, String string2, String string3, String string4) throws JMSException {
        return new QueueSyncConnection((QueueConnectionFactory)connectionFactory, (QueueConnection)connection, n, string, string2, string3, string4);
    }

    private QueueSession createQueueSession(QueueConnection queueConnection, int n) throws JMSException {
        return queueConnection.createQueueSession(false, n);
    }

    private Queue createQueue(QueueSession queueSession, String string) throws Exception {
        return this.m_adapter.getQueue(queueSession, string);
    }

    private QueueReceiver createReceiver(QueueSession queueSession, Queue queue, String string) throws JMSException {
        return queueSession.createReceiver(queue, string);
    }

    protected JMSConnector.AsyncConnection createAsyncConnection(ConnectionFactory connectionFactory, Connection connection, String string, String string2, String string3, String string4) throws JMSException {
        return new QueueAsyncConnection((QueueConnectionFactory)connectionFactory, (QueueConnection)connection, string, string2, string3, string4);
    }

    private final class QueueAsyncConnection
    extends JMSConnector.AsyncConnection {
        QueueAsyncConnection(QueueConnectionFactory queueConnectionFactory, QueueConnection queueConnection, String string, String string2, String string3, String string4) throws JMSException {
            super(queueConnectionFactory, queueConnection, string, string2, string3, string4);
        }

        protected JMSConnector.AsyncConnection.ListenerSession createListenerSession(Connection connection, Subscription subscription) throws Exception {
            QueueSession queueSession = QueueConnector.this.createQueueSession((QueueConnection)connection, subscription.m_ackMode);
            QueueReceiver queueReceiver = QueueConnector.this.createReceiver(queueSession, (Queue)subscription.m_endpoint.getDestination(queueSession), subscription.m_messageSelector);
            return new JMSConnector.AsyncConnection.ListenerSession(queueSession, queueReceiver, subscription);
        }
    }

    private final class QueueDestinationEndpoint
    extends QueueEndpoint {
        Queue m_queue;

        QueueDestinationEndpoint(Queue queue) throws JMSException {
            super(queue.getQueueName());
            this.m_queue = queue;
        }

        Destination getDestination(Session session) {
            return this.m_queue;
        }
    }

    private class QueueEndpoint
    extends JMSEndpoint {
        String m_queueName;

        QueueEndpoint(String string) {
            super(QueueConnector.this);
            this.m_queueName = string;
        }

        Destination getDestination(Session session) throws Exception {
            return QueueConnector.this.createQueue((QueueSession)session, this.m_queueName);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("QueueEndpoint:");
            stringBuffer.append(this.m_queueName);
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof QueueEndpoint)) {
                return false;
            }
            return this.m_queueName.equals(((QueueEndpoint)object).m_queueName);
        }
    }

    private final class QueueSyncConnection
    extends JMSConnector.SyncConnection {
        QueueSyncConnection(QueueConnectionFactory queueConnectionFactory, QueueConnection queueConnection, int n, String string, String string2, String string3, String string4) throws JMSException {
            super(queueConnectionFactory, queueConnection, n, string, string2, string3, string4);
        }

        protected JMSConnector.SyncConnection.SendSession createSendSession(Connection connection) throws JMSException {
            QueueSession queueSession = QueueConnector.this.createQueueSession((QueueConnection)connection, 3);
            QueueSender queueSender = queueSession.createSender(null);
            return new QueueSendSession(queueSession, queueSender);
        }

        private final class QueueSendSession
        extends JMSConnector.SyncConnection.SendSession {
            QueueSendSession(QueueSession queueSession, QueueSender queueSender) throws JMSException {
                super(queueSession, queueSender);
            }

            protected MessageConsumer createConsumer(Destination destination) throws JMSException {
                return QueueConnector.this.createReceiver((QueueSession)this.m_session, (Queue)destination, null);
            }

            protected Destination createTemporaryDestination() throws JMSException {
                return ((QueueSession)this.m_session).createTemporaryQueue();
            }

            protected void deleteTemporaryDestination(Destination destination) throws JMSException {
                ((TemporaryQueue)destination).delete();
            }

            protected void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
                ((QueueSender)this.m_producer).send((Queue)destination, message, n, n2, l);
            }
        }
    }
}

