/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSEndpoint;
import org.apache.axis.transport.jms.JMSURLHelper;
import org.apache.axis.transport.jms.MapUtils;
import org.apache.axis.transport.jms.Subscription;

public class TopicConnector
extends JMSConnector {
    public TopicConnector(TopicConnectionFactory topicConnectionFactory, int n, int n2, long l, long l2, long l3, boolean bl, String string, String string2, String string3, JMSVendorAdapter jMSVendorAdapter, JMSURLHelper jMSURLHelper) throws JMSException {
        super(topicConnectionFactory, n, n2, l, l2, l3, bl, string, string2, string3, jMSVendorAdapter, jMSURLHelper);
    }

    protected Connection internalConnect(ConnectionFactory connectionFactory, String string, String string2) throws JMSException {
        TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)connectionFactory;
        if (string == null) {
            return topicConnectionFactory.createTopicConnection();
        }
        return topicConnectionFactory.createTopicConnection(string, string2);
    }

    protected JMSConnector.SyncConnection createSyncConnection(ConnectionFactory connectionFactory, Connection connection, int n, String string, String string2, String string3, String string4) throws JMSException {
        return new TopicSyncConnection((TopicConnectionFactory)connectionFactory, (TopicConnection)connection, n, string, string2, string3, string4);
    }

    protected JMSConnector.AsyncConnection createAsyncConnection(ConnectionFactory connectionFactory, Connection connection, String string, String string2, String string3, String string4) throws JMSException {
        return new TopicAsyncConnection((TopicConnectionFactory)connectionFactory, (TopicConnection)connection, string, string2, string3, string4);
    }

    public JMSEndpoint createEndpoint(String string) {
        return new TopicEndpoint(string);
    }

    public JMSEndpoint createEndpoint(Destination destination) throws JMSException {
        if (!(destination instanceof Topic)) {
            throw new IllegalArgumentException("The input be a topic for this connector");
        }
        return new TopicDestinationEndpoint((Topic)destination);
    }

    private TopicSession createTopicSession(TopicConnection topicConnection, int n) throws JMSException {
        return topicConnection.createTopicSession(false, n);
    }

    private Topic createTopic(TopicSession topicSession, String string) throws Exception {
        return this.m_adapter.getTopic(topicSession, string);
    }

    private TopicSubscriber createSubscriber(TopicSession topicSession, TopicSubscription topicSubscription) throws Exception {
        if (topicSubscription.isDurable()) {
            return this.createDurableSubscriber(topicSession, (Topic)topicSubscription.m_endpoint.getDestination(topicSession), topicSubscription.m_subscriptionName, topicSubscription.m_messageSelector, topicSubscription.m_noLocal);
        }
        return this.createSubscriber(topicSession, (Topic)topicSubscription.m_endpoint.getDestination(topicSession), topicSubscription.m_messageSelector, topicSubscription.m_noLocal);
    }

    private TopicSubscriber createDurableSubscriber(TopicSession topicSession, Topic topic, String string, String string2, boolean bl) throws JMSException {
        return topicSession.createDurableSubscriber(topic, string, string2, bl);
    }

    private TopicSubscriber createSubscriber(TopicSession topicSession, Topic topic, String string, boolean bl) throws JMSException {
        return topicSession.createSubscriber(topic, string, bl);
    }

    private final class TopicDestinationEndpoint
    extends TopicEndpoint {
        Topic m_topic;

        TopicDestinationEndpoint(Topic topic) throws JMSException {
            super(topic.getTopicName());
            this.m_topic = topic;
        }

        Destination getDestination(Session session) {
            return this.m_topic;
        }
    }

    private final class TopicSubscription
    extends Subscription {
        String m_subscriptionName;
        boolean m_unsubscribe;
        boolean m_noLocal;

        TopicSubscription(MessageListener messageListener, JMSEndpoint jMSEndpoint, HashMap hashMap) {
            super(messageListener, jMSEndpoint, hashMap);
            this.m_subscriptionName = MapUtils.removeStringProperty(hashMap, "transport.jms.subscriptionName", null);
            this.m_unsubscribe = MapUtils.removeBooleanProperty(hashMap, "transport.jms.unsubscribe", false);
            this.m_noLocal = MapUtils.removeBooleanProperty(hashMap, "transport.jms.noLocal", false);
        }

        boolean isDurable() {
            return this.m_subscriptionName != null;
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof TopicSubscription)) {
                return false;
            }
            TopicSubscription topicSubscription = (TopicSubscription)object;
            if (topicSubscription.m_unsubscribe != this.m_unsubscribe || topicSubscription.m_noLocal != this.m_noLocal) {
                return false;
            }
            if (this.isDurable()) {
                return topicSubscription.isDurable() && topicSubscription.m_subscriptionName.equals(this.m_subscriptionName);
            }
            return !topicSubscription.isDurable();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(":").append(this.m_noLocal).append(":").append(this.m_unsubscribe);
            if (this.isDurable()) {
                stringBuffer.append(":");
                stringBuffer.append(this.m_subscriptionName);
            }
            return stringBuffer.toString();
        }
    }

    private class TopicEndpoint
    extends JMSEndpoint {
        String m_topicName;

        TopicEndpoint(String string) {
            super(TopicConnector.this);
            this.m_topicName = string;
        }

        Destination getDestination(Session session) throws Exception {
            return TopicConnector.this.createTopic((TopicSession)session, this.m_topicName);
        }

        protected Subscription createSubscription(MessageListener messageListener, HashMap hashMap) {
            return new TopicSubscription(messageListener, this, hashMap);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("TopicEndpoint:");
            stringBuffer.append(this.m_topicName);
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof TopicEndpoint)) {
                return false;
            }
            return this.m_topicName.equals(((TopicEndpoint)object).m_topicName);
        }
    }

    private final class TopicSyncConnection
    extends JMSConnector.SyncConnection {
        TopicSyncConnection(TopicConnectionFactory topicConnectionFactory, TopicConnection topicConnection, int n, String string, String string2, String string3, String string4) throws JMSException {
            super(topicConnectionFactory, topicConnection, n, string, string2, string3, string4);
        }

        protected JMSConnector.SyncConnection.SendSession createSendSession(Connection connection) throws JMSException {
            TopicSession topicSession = TopicConnector.this.createTopicSession((TopicConnection)connection, 3);
            TopicPublisher topicPublisher = topicSession.createPublisher(null);
            return new TopicSendSession(topicSession, topicPublisher);
        }

        private final class TopicSendSession
        extends JMSConnector.SyncConnection.SendSession {
            TopicSendSession(TopicSession topicSession, TopicPublisher topicPublisher) throws JMSException {
                super(topicSession, topicPublisher);
            }

            protected MessageConsumer createConsumer(Destination destination) throws JMSException {
                return TopicConnector.this.createSubscriber((TopicSession)this.m_session, (Topic)destination, null, false);
            }

            protected void deleteTemporaryDestination(Destination destination) throws JMSException {
                ((TemporaryTopic)destination).delete();
            }

            protected Destination createTemporaryDestination() throws JMSException {
                return ((TopicSession)this.m_session).createTemporaryTopic();
            }

            protected void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
                ((TopicPublisher)this.m_producer).publish((Topic)destination, message, n, n2, l);
            }
        }
    }

    private final class TopicAsyncConnection
    extends JMSConnector.AsyncConnection {
        TopicAsyncConnection(TopicConnectionFactory topicConnectionFactory, TopicConnection topicConnection, String string, String string2, String string3, String string4) throws JMSException {
            super(topicConnectionFactory, topicConnection, string, string2, string3, string4);
        }

        protected JMSConnector.AsyncConnection.ListenerSession createListenerSession(Connection connection, Subscription subscription) throws Exception {
            TopicSession topicSession = TopicConnector.this.createTopicSession((TopicConnection)connection, subscription.m_ackMode);
            TopicSubscriber topicSubscriber = TopicConnector.this.createSubscriber(topicSession, (TopicSubscription)subscription);
            return new TopicListenerSession(topicSession, topicSubscriber, (TopicSubscription)subscription);
        }

        private final class TopicListenerSession
        extends JMSConnector.AsyncConnection.ListenerSession {
            TopicListenerSession(TopicSession topicSession, TopicSubscriber topicSubscriber, TopicSubscription topicSubscription) throws Exception {
                super(topicSession, topicSubscriber, topicSubscription);
            }

            void cleanup() {
                try {
                    this.m_consumer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    TopicSubscription topicSubscription = (TopicSubscription)this.m_subscription;
                    if (topicSubscription.isDurable() && topicSubscription.m_unsubscribe) {
                        ((TopicSession)this.m_session).unsubscribe(topicSubscription.m_subscriptionName);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

