/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.mail;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.rmi.server.UID;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;

public class MailSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(MailSender.class.getName());
    private UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    Properties prop = new Properties();
    Session session = Session.getDefaultInstance(this.prop, null);

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "MailSender::invoke"));
        }
        try {
            String string = this.writeUsingSMTP(messageContext);
            this.readUsingPOP3(string, messageContext);
        }
        catch (Exception exception) {
            log.debug(exception);
            throw AxisFault.makeFault(exception);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "HTTPDispatchHandler::invoke"));
        }
    }

    private String writeUsingSMTP(MessageContext messageContext) throws Exception {
        String string;
        String string2 = new UID().toString();
        String string3 = messageContext.getStrProp("transport.mail.smtp.host");
        SMTPClient sMTPClient = new SMTPClient();
        sMTPClient.connect(string3);
        System.out.print(sMTPClient.getReplyString());
        int n = sMTPClient.getReplyCode();
        if (!SMTPReply.isPositiveCompletion(n)) {
            sMTPClient.disconnect();
            AxisFault axisFault = new AxisFault("SMTP", "( SMTP server refused connection )", null, null);
            throw axisFault;
        }
        sMTPClient.login(string3);
        System.out.print(sMTPClient.getReplyString());
        n = sMTPClient.getReplyCode();
        if (!SMTPReply.isPositiveCompletion(n)) {
            sMTPClient.disconnect();
            AxisFault axisFault = new AxisFault("SMTP", "( SMTP server refused connection )", null, null);
            throw axisFault;
        }
        String string4 = messageContext.getStrProp("transport.mail.from");
        String string5 = messageContext.getStrProp("transport.mail.to");
        MimeMessage mimeMessage = new MimeMessage(this.session);
        mimeMessage.setFrom(new InternetAddress(string4));
        mimeMessage.addRecipient(MimeMessage.RecipientType.TO, new InternetAddress(string5));
        String string6 = string = messageContext.useSOAPAction() ? messageContext.getSOAPActionURI() : "";
        if (string == null) {
            string = "";
        }
        Message message = messageContext.getRequestMessage();
        mimeMessage.addHeader("User-Agent", Messages.getMessage("axisUserAgent"));
        mimeMessage.addHeader("SOAPAction", string);
        mimeMessage.setDisposition("inline");
        mimeMessage.setSubject(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        message.writeTo(byteArrayOutputStream);
        mimeMessage.setContent(byteArrayOutputStream.toString(), message.getContentType(messageContext.getSOAPConstants()));
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(8192);
        mimeMessage.writeTo(byteArrayOutputStream2);
        sMTPClient.setSender(string4);
        System.out.print(sMTPClient.getReplyString());
        sMTPClient.addRecipient(string5);
        System.out.print(sMTPClient.getReplyString());
        Writer writer = sMTPClient.sendMessageData();
        System.out.print(sMTPClient.getReplyString());
        writer.write(byteArrayOutputStream2.toString());
        writer.flush();
        writer.close();
        System.out.print(sMTPClient.getReplyString());
        if (!sMTPClient.completePendingCommand()) {
            System.out.print(sMTPClient.getReplyString());
            AxisFault axisFault = new AxisFault("SMTP", "( Failed to send email )", null, null);
            throw axisFault;
        }
        System.out.print(sMTPClient.getReplyString());
        sMTPClient.logout();
        sMTPClient.disconnect();
        return string2;
    }

    private void readUsingPOP3(String string, MessageContext messageContext) throws Exception {
        Object object;
        String string2 = messageContext.getStrProp("transport.mail.pop3.host");
        String string3 = messageContext.getStrProp("transport.mail.pop3.userid");
        String string4 = messageContext.getStrProp("transport.mail.pop3.password");
        POP3MessageInfo[] pOP3MessageInfoArray = null;
        MimeMessage mimeMessage = null;
        POP3Client pOP3Client = new POP3Client();
        pOP3Client.setDefaultTimeout(60000);
        for (int i = 0; i < 12; ++i) {
            pOP3Client.connect(string2);
            if (!pOP3Client.login(string3, string4)) {
                pOP3Client.disconnect();
                object = new AxisFault("POP3", "( Could not login to server.  Check password. )", null, null);
                throw object;
            }
            pOP3MessageInfoArray = pOP3Client.listMessages();
            if (pOP3MessageInfoArray != null && pOP3MessageInfoArray.length > 0) {
                object = null;
                for (int j = 0; j < pOP3MessageInfoArray.length; ++j) {
                    int n;
                    Object object2;
                    Reader reader = pOP3Client.retrieveMessage(pOP3MessageInfoArray[j].number);
                    if (reader == null) {
                        object2 = new AxisFault("POP3", "( Could not retrieve message header. )", null, null);
                        throw object2;
                    }
                    object = new StringBuffer();
                    object2 = new BufferedReader(reader);
                    while ((n = ((BufferedReader)object2).read()) != -1) {
                        ((StringBuffer)object).append((char)n);
                    }
                    ((BufferedReader)object2).close();
                    if (((StringBuffer)object).toString().indexOf(string) != -1) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((StringBuffer)object).toString().getBytes());
                        Properties properties = new Properties();
                        Session session = Session.getDefaultInstance(properties, null);
                        mimeMessage = new MimeMessage(session, byteArrayInputStream);
                        pOP3Client.deleteMessage(pOP3MessageInfoArray[j].number);
                        break;
                    }
                    object = null;
                }
            }
            pOP3Client.logout();
            pOP3Client.disconnect();
            if (mimeMessage != null) break;
            Thread.sleep(5000L);
        }
        if (mimeMessage == null) {
            pOP3Client.logout();
            pOP3Client.disconnect();
            AxisFault axisFault = new AxisFault("POP3", "( Could not retrieve message list. )", null, null);
            throw axisFault;
        }
        String string5 = mimeMessage.getContentType();
        object = mimeMessage.getContentID();
        Message message = new Message(mimeMessage.getInputStream(), false, string5, (String)object);
        message.setMessageType("response");
        messageContext.setResponseMessage(message);
        if (log.isDebugEnabled()) {
            log.debug("\n" + Messages.getMessage("xmlRecd00"));
            log.debug("-----------------------------------------------");
            log.debug(message.getSOAPPartAsString());
        }
    }
}

