/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;

public class ArrayUtil {
    public static final NonConvertable NON_CONVERTABLE = new NonConvertable();

    public static Object convertObjectToArray(Object object, Class clazz) {
        try {
            ArrayInfo arrayInfo = new ArrayInfo();
            boolean bl = ArrayUtil.internalIsConvertable(object.getClass(), arrayInfo, clazz);
            if (!bl) {
                return object;
            }
            BeanPropertyDescriptor beanPropertyDescriptor = null;
            beanPropertyDescriptor = ArrayUtil.getArrayComponentPD(object.getClass());
            if (beanPropertyDescriptor == null) {
                return NON_CONVERTABLE;
            }
            Object object2 = beanPropertyDescriptor.get(object);
            if (object2 == null) {
                return null;
            }
            int n = 0;
            if (!object2.getClass().isArray()) {
                return object2;
            }
            n = Array.getLength(object2);
            int[] nArray = new int[arrayInfo.dimension];
            nArray[0] = n;
            Object object3 = Array.newInstance(arrayInfo.componentType, nArray);
            for (int i = 0; i < n; ++i) {
                Object object4 = Array.get(object2, i);
                Class<?> clazz2 = clazz.getComponentType();
                Array.set(object3, i, ArrayUtil.convertObjectToArray(object4, clazz2));
            }
            return object3;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    public static boolean isConvertable(Class clazz, Class clazz2) {
        ArrayInfo arrayInfo = new ArrayInfo();
        return ArrayUtil.internalIsConvertable(clazz, arrayInfo, clazz2);
    }

    private static boolean internalIsConvertable(Class clazz, ArrayInfo arrayInfo, Class clazz2) {
        BeanPropertyDescriptor beanPropertyDescriptor = null;
        BeanPropertyDescriptor beanPropertyDescriptor2 = null;
        if (!clazz2.isArray()) {
            return false;
        }
        Class<?> clazz3 = clazz2.getComponentType();
        Class clazz4 = clazz;
        int n = 0;
        while ((beanPropertyDescriptor = ArrayUtil.getArrayComponentPD(clazz4)) != null) {
            ++n;
            clazz4 = beanPropertyDescriptor.getType();
            beanPropertyDescriptor2 = beanPropertyDescriptor;
            if (!clazz3.isAssignableFrom(clazz4)) continue;
        }
        if (n == 0 || beanPropertyDescriptor2.getType() == null) {
            return false;
        }
        arrayInfo.componentType = beanPropertyDescriptor2.getType();
        arrayInfo.dimension = n;
        Class clazz5 = beanPropertyDescriptor2.getType();
        int[] nArray = new int[n];
        Object object = Array.newInstance(clazz5, nArray);
        arrayInfo.arrayType = object.getClass();
        return clazz2.isAssignableFrom(arrayInfo.arrayType);
    }

    private static BeanPropertyDescriptor getArrayComponentPD(Class clazz) {
        BeanPropertyDescriptor beanPropertyDescriptor = null;
        int n = 0;
        Class clazz2 = clazz;
        while (!clazz2.getName().equals("java.lang.Object")) {
            BeanPropertyDescriptor[] beanPropertyDescriptorArray = BeanUtils.getPd(clazz);
            for (int i = 0; i < beanPropertyDescriptorArray.length; ++i) {
                BeanPropertyDescriptor beanPropertyDescriptor2 = beanPropertyDescriptorArray[i];
                if (!beanPropertyDescriptor2.isReadable() || !beanPropertyDescriptor2.isWriteable() || !beanPropertyDescriptor2.isIndexed()) continue;
                if (++n >= 2) {
                    return null;
                }
                beanPropertyDescriptor = beanPropertyDescriptor2;
            }
            clazz2 = clazz2.getSuperclass();
        }
        if (n == 1) {
            return beanPropertyDescriptor;
        }
        return null;
    }

    public static int getArrayDimension(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        int n = 0;
        Class<?> clazz2 = clazz;
        do {
            ++n;
        } while ((clazz2 = (clazz = clazz2).getComponentType()).isArray());
        return n;
    }

    private static Object createNewInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        Comparable<Boolean> comparable = null;
        if (!clazz.isPrimitive()) {
            comparable = (Comparable<Boolean>)clazz.newInstance();
        } else if (Boolean.TYPE.isAssignableFrom(clazz)) {
            comparable = new Boolean(false);
        } else if (Byte.TYPE.isAssignableFrom(clazz)) {
            comparable = new Byte(0);
        } else if (Character.TYPE.isAssignableFrom(clazz)) {
            comparable = new Character('\u0000');
        } else if (Short.TYPE.isAssignableFrom(clazz)) {
            comparable = new Short(0);
        } else if (Integer.TYPE.isAssignableFrom(clazz)) {
            comparable = new Integer(0);
        } else if (Long.TYPE.isAssignableFrom(clazz)) {
            comparable = new Long(0L);
        } else if (Float.TYPE.isAssignableFrom(clazz)) {
            comparable = new Float(0.0f);
        } else if (Double.TYPE.isAssignableFrom(clazz)) {
            comparable = new Double(0.0);
        }
        return comparable;
    }

    public static Object convertArrayToObject(Object object, Class clazz) {
        int n = ArrayUtil.getArrayDimension(object.getClass());
        if (n == 0) {
            return null;
        }
        Object object2 = null;
        try {
            int n2;
            int n3 = Array.getLength(object);
            Object object3 = null;
            Class clazz2 = null;
            if (!clazz.isArray()) {
                object2 = clazz.newInstance();
                BeanPropertyDescriptor beanPropertyDescriptor = ArrayUtil.getArrayComponentPD(clazz);
                if (beanPropertyDescriptor == null) {
                    return null;
                }
                clazz2 = beanPropertyDescriptor.getType();
                object3 = Array.newInstance(clazz2, n3);
                beanPropertyDescriptor.set(object2, object3);
            } else {
                clazz2 = clazz.getComponentType();
                object3 = object2 = Array.newInstance(clazz2, n3);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Array.set(object3, n2, ArrayUtil.createNewInstance(clazz2));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Object object4 = Array.get(object, n2);
                if (object4 == null) continue;
                if (object4.getClass().isArray()) {
                    Class<?> clazz3 = Array.get(object3, n2).getClass();
                    Array.set(object3, n2, ArrayUtil.convertArrayToObject(object4, clazz3));
                    continue;
                }
                Array.set(object3, n2, object4);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        return object2;
    }

    public static class NonConvertable {
    }

    private static class ArrayInfo {
        public Class componentType;
        public Class arrayType;
        public int dimension;

        private ArrayInfo() {
        }
    }
}

