/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis.AxisProperties;
import org.apache.axis.utils.ByteArrayOutputStream;

public class ByteArray
extends OutputStream {
    protected static double DEFAULT_CACHE_INCREMENT = 2.5;
    protected static int DEFAULT_RESIDENT_SIZE = 0x20000000;
    protected static boolean DEFAULT_ENABLE_BACKING_STORE = true;
    protected static int WORKING_BUFFER_SIZE = 8192;
    protected ByteArrayOutputStream cache = null;
    protected int max_size = 0;
    protected File bs_handle = null;
    protected OutputStream bs_stream = null;
    protected long count = 0L;
    protected boolean enableBackingStore = DEFAULT_ENABLE_BACKING_STORE;

    public boolean isEnableBackingStore() {
        return this.enableBackingStore;
    }

    public void setEnableBackingStore(boolean bl) {
        this.enableBackingStore = bl;
    }

    public static boolean isDEFAULT_ENABLE_BACKING_STORE() {
        return DEFAULT_ENABLE_BACKING_STORE;
    }

    public static void setDEFAULT_ENABLE_BACKING_STORE(boolean bl) {
        DEFAULT_ENABLE_BACKING_STORE = bl;
    }

    public static int getDEFAULT_RESIDENT_SIZE() {
        return DEFAULT_RESIDENT_SIZE;
    }

    public static void setDEFAULT_RESIDENT_SIZE(int n) {
        DEFAULT_RESIDENT_SIZE = n;
    }

    public static double getDEFAULT_CACHE_INCREMENT() {
        return DEFAULT_CACHE_INCREMENT;
    }

    public static void setDEFAULT_CACHE_INCREMENT(double d) {
        DEFAULT_CACHE_INCREMENT = d;
    }

    public ByteArray() {
        this(DEFAULT_RESIDENT_SIZE);
    }

    public ByteArray(int n) {
        this(0, n);
    }

    public ByteArray(int n, int n2) {
        if (n > n2) {
            n = 0;
        }
        if (n < WORKING_BUFFER_SIZE) {
            n = WORKING_BUFFER_SIZE;
        }
        this.cache = new ByteArrayOutputStream(n);
        this.max_size = n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.count += (long)n2;
        if (this.cache != null) {
            this.increaseCapacity(n2);
        }
        if (this.cache != null) {
            this.cache.write(byArray, n, n2);
        } else if (this.bs_stream != null) {
            this.bs_stream.write(byArray, n, n2);
        } else {
            throw new IOException("ByteArray does not have a backing store!");
        }
    }

    public void write(int n) throws IOException {
        ++this.count;
        if (this.cache != null) {
            this.increaseCapacity(1);
        }
        if (this.cache != null) {
            this.cache.write(n);
        } else if (this.bs_stream != null) {
            this.bs_stream.write(n);
        } else {
            throw new IOException("ByteArray does not have a backing store!");
        }
    }

    public void close() throws IOException {
        if (this.bs_stream != null) {
            this.bs_stream.close();
            this.bs_stream = null;
        }
    }

    public long size() {
        return this.count;
    }

    public void flush() throws IOException {
        if (this.bs_stream != null) {
            this.bs_stream.flush();
        }
    }

    protected void increaseCapacity(int n) throws IOException {
        if (this.cache == null) {
            return;
        }
        if (n + this.cache.size() <= this.max_size) {
            return;
        }
        if (!this.enableBackingStore) {
            throw new IOException("ByteArray can not increase capacity by " + n + " due to max size limit of " + this.max_size);
        }
        this.switchToBackingStore();
    }

    public synchronized void discardBuffer() {
        this.cache = null;
        if (this.bs_stream != null) {
            try {
                this.bs_stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bs_stream = null;
        }
        this.discardBackingStore();
    }

    protected InputStream makeInputStream() throws IOException, FileNotFoundException {
        this.close();
        if (this.cache != null) {
            return new ByteArrayInputStream(this.cache.toByteArray());
        }
        if (this.bs_handle != null) {
            return this.createBackingStoreInputStream();
        }
        return null;
    }

    protected void finalize() {
        this.discardBuffer();
    }

    protected void switchToBackingStore() throws IOException {
        this.bs_handle = File.createTempFile("Axis", ".msg");
        this.bs_handle.createNewFile();
        this.bs_handle.deleteOnExit();
        this.bs_stream = new FileOutputStream(this.bs_handle);
        this.bs_stream.write(this.cache.toByteArray());
        this.cache = null;
    }

    public String getBackingStoreFileName() throws IOException {
        String string = null;
        if (this.bs_handle != null) {
            string = this.bs_handle.getCanonicalPath();
        }
        return string;
    }

    protected void discardBackingStore() {
        if (this.bs_handle != null) {
            this.bs_handle.delete();
            this.bs_handle = null;
        }
    }

    protected InputStream createBackingStoreInputStream() throws FileNotFoundException {
        try {
            return new BufferedInputStream(new FileInputStream(this.bs_handle.getCanonicalPath()));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(this.bs_handle.getAbsolutePath());
        }
    }

    public byte[] toByteArray() throws IOException {
        int n;
        InputStream inputStream = this.makeInputStream();
        byte[] byArray = null;
        java.io.ByteArrayOutputStream byteArrayOutputStream = new java.io.ByteArrayOutputStream();
        byArray = new byte[WORKING_BUFFER_SIZE];
        while ((n = inputStream.read(byArray, 0, WORKING_BUFFER_SIZE)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.discardBackingStore();
        return byteArrayOutputStream.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        int n;
        InputStream inputStream = this.makeInputStream();
        byte[] byArray = null;
        byArray = new byte[WORKING_BUFFER_SIZE];
        while ((n = inputStream.read(byArray, 0, WORKING_BUFFER_SIZE)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.discardBackingStore();
    }

    static {
        String string = AxisProperties.getProperty("axis.byteBuffer.cacheIncrement", "" + DEFAULT_CACHE_INCREMENT);
        DEFAULT_CACHE_INCREMENT = Double.parseDouble(string);
        string = AxisProperties.getProperty("axis.byteBuffer.residentMaxSize", "" + DEFAULT_RESIDENT_SIZE);
        DEFAULT_RESIDENT_SIZE = Integer.parseInt(string);
        string = AxisProperties.getProperty("axis.byteBuffer.workBufferSize", "" + WORKING_BUFFER_SIZE);
        WORKING_BUFFER_SIZE = Integer.parseInt(string);
        string = AxisProperties.getProperty("axis.byteBuffer.backing", "" + DEFAULT_ENABLE_BACKING_STORE);
        DEFAULT_ENABLE_BACKING_STORE = string.equalsIgnoreCase("true") || string.equals("1") || string.equalsIgnoreCase("yes");
    }
}

