/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.utils.Messages;

public class ByteArrayOutputStream
extends OutputStream {
    private List buffers = new ArrayList();
    private int currentBufferIndex;
    private int filledBufferSum;
    private byte[] currentBuffer;
    private int count;

    public ByteArrayOutputStream() {
        this(1024);
    }

    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException01", Integer.toString(n)));
        }
        this.needNewBuffer(n);
    }

    private byte[] getBuffer(int n) {
        return (byte[])this.buffers.get(n);
    }

    private void needNewBuffer(int n) {
        if (this.currentBufferIndex < this.buffers.size() - 1) {
            this.filledBufferSum += this.currentBuffer.length;
            ++this.currentBufferIndex;
            this.currentBuffer = this.getBuffer(this.currentBufferIndex);
        } else {
            int n2;
            if (this.currentBuffer == null) {
                n2 = n;
                this.filledBufferSum = 0;
            } else {
                n2 = Math.max(this.currentBuffer.length << 1, n - this.filledBufferSum);
                this.filledBufferSum += this.currentBuffer.length;
            }
            ++this.currentBufferIndex;
            this.currentBuffer = new byte[n2];
            this.buffers.add(this.currentBuffer);
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException(Messages.getMessage("indexOutOfBoundsException00"));
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        int n4 = n2;
        int n5 = this.count - this.filledBufferSum;
        while (n4 > 0) {
            int n6 = Math.min(n4, this.currentBuffer.length - n5);
            System.arraycopy(byArray, n + n2 - n4, this.currentBuffer, n5, n6);
            if ((n4 -= n6) <= 0) continue;
            this.needNewBuffer(n3);
            n5 = 0;
        }
        this.count = n3;
    }

    public synchronized void write(int n) {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public int size() {
        return this.count;
    }

    public void close() throws IOException {
    }

    public synchronized void reset() {
        this.count = 0;
        this.filledBufferSum = 0;
        this.currentBufferIndex = 0;
        this.currentBuffer = this.getBuffer(this.currentBufferIndex);
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        int n = this.count;
        for (int i = 0; i < this.buffers.size(); ++i) {
            byte[] byArray = this.getBuffer(i);
            int n2 = Math.min(byArray.length, n);
            outputStream.write(byArray, 0, n2);
            if ((n -= n2) == 0) break;
        }
    }

    public synchronized byte[] toByteArray() {
        int n = this.count;
        int n2 = 0;
        byte[] byArray = new byte[this.count];
        for (int i = 0; i < this.buffers.size(); ++i) {
            byte[] byArray2 = this.getBuffer(i);
            int n3 = Math.min(byArray2.length, n);
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
            if ((n -= n3) == 0) break;
        }
        return byArray;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), string);
    }
}

