/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisProperties;
import org.apache.axis.InternalException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.components.encoding.XMLEncoderFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Base64;
import org.apache.axis.utils.DOM2Writer;
import org.apache.axis.utils.DefaultEntityResolver;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtils {
    protected static Log log = LogFactory.getLog(XMLUtils.class.getName());
    public static final String httpAuthCharEncoding = "ISO-8859-1";
    private static final String saxParserFactoryProperty = "javax.xml.parsers.SAXParserFactory";
    private static DocumentBuilderFactory dbf = XMLUtils.getDOMFactory();
    private static SAXParserFactory saxFactory;
    private static Stack saxParsers;
    private static DefaultHandler doNothingContentHandler;
    private static String EMPTY;
    private static ByteArrayInputStream bais;
    private static boolean tryReset;
    protected static boolean enableParserReuse;
    private static ThreadLocalDocumentBuilder documentBuilder;

    public static String xmlEncodeString(String string) {
        XMLEncoder xMLEncoder = XMLUtils.getXMLEncoder(MessageContext.getCurrentContext());
        return xMLEncoder.encode(string);
    }

    public static XMLEncoder getXMLEncoder(MessageContext messageContext) {
        return XMLUtils.getXMLEncoder(XMLUtils.getEncoding(null, messageContext));
    }

    public static XMLEncoder getXMLEncoder(String string) {
        XMLEncoder xMLEncoder = null;
        try {
            xMLEncoder = XMLEncoderFactory.getEncoder(string);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            xMLEncoder = XMLEncoderFactory.getDefaultEncoder();
        }
        return xMLEncoder;
    }

    public static String getEncoding(MessageContext messageContext) {
        XMLEncoder xMLEncoder = XMLUtils.getXMLEncoder(messageContext);
        return xMLEncoder.getEncoding();
    }

    public static String getEncoding() {
        XMLEncoder xMLEncoder = XMLUtils.getXMLEncoder(MessageContext.getCurrentContext());
        return xMLEncoder.getEncoding();
    }

    public static void initSAXFactory(String string, boolean bl, boolean bl2) {
        if (string != null) {
            try {
                saxFactory = (SAXParserFactory)Class.forName(string).newInstance();
                if (System.getProperty(saxParserFactoryProperty) == null) {
                    System.setProperty(saxParserFactoryProperty, string);
                }
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("exception00"), exception);
                saxFactory = null;
            }
        } else {
            saxFactory = SAXParserFactory.newInstance();
        }
        saxFactory.setNamespaceAware(bl);
        saxFactory.setValidating(bl2);
        saxParsers.clear();
    }

    private static DocumentBuilderFactory getDOMFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            documentBuilderFactory = null;
        }
        return documentBuilderFactory;
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return (DocumentBuilder)documentBuilder.get();
    }

    public static void releaseDocumentBuilder(DocumentBuilder documentBuilder) {
        try {
            documentBuilder.setErrorHandler(null);
        }
        catch (Throwable throwable) {
            log.debug("Failed to set ErrorHandler to null on DocumentBuilder", throwable);
        }
        try {
            documentBuilder.setEntityResolver(null);
        }
        catch (Throwable throwable) {
            log.debug("Failed to set EntityResolver to null on DocumentBuilder", throwable);
        }
    }

    public static synchronized SAXParser getSAXParser() {
        if (enableParserReuse && !saxParsers.empty()) {
            return (SAXParser)saxParsers.pop();
        }
        try {
            SAXParser sAXParser = saxFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            try {
                xMLReader.setEntityResolver(new DefaultEntityResolver());
            }
            catch (Throwable throwable) {
                log.debug("Failed to set EntityResolver on DocumentBuilder", throwable);
            }
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            return sAXParser;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error(Messages.getMessage("parserConfigurationException00"), parserConfigurationException);
            return null;
        }
        catch (SAXException sAXException) {
            log.error(Messages.getMessage("SAXException00"), sAXException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseSAXParser(SAXParser sAXParser) {
        if (!tryReset || !enableParserReuse) {
            return;
        }
        try {
            XMLReader xMLReader = sAXParser.getXMLReader();
            if (null != xMLReader) {
                xMLReader.setContentHandler(doNothingContentHandler);
                xMLReader.setDTDHandler(doNothingContentHandler);
                try {
                    xMLReader.setEntityResolver(doNothingContentHandler);
                }
                catch (Throwable throwable) {
                    log.debug("Failed to set EntityResolver on DocumentBuilder", throwable);
                }
                try {
                    xMLReader.setErrorHandler(doNothingContentHandler);
                }
                catch (Throwable throwable) {
                    log.debug("Failed to set ErrorHandler on DocumentBuilder", throwable);
                }
                Class<XMLUtils> clazz = XMLUtils.class;
                synchronized (XMLUtils.class) {
                    saxParsers.push(sAXParser);
                    // ** MonitorExit[var2_5] (shouldn't be in output)
                    return;
                }
            }
            tryReset = false;
            return;
        }
        catch (SAXException sAXException) {
            tryReset = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = null;
        try {
            Document document;
            documentBuilder = XMLUtils.getDocumentBuilder();
            Document document2 = document = documentBuilder.newDocument();
            return document2;
        }
        finally {
            if (documentBuilder != null) {
                XMLUtils.releaseDocumentBuilder(documentBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = null;
        try {
            Document document;
            documentBuilder = XMLUtils.getDocumentBuilder();
            try {
                documentBuilder.setEntityResolver(new DefaultEntityResolver());
            }
            catch (Throwable throwable) {
                log.debug("Failed to set EntityResolver on DocumentBuilder", throwable);
            }
            try {
                documentBuilder.setErrorHandler(new ParserErrorHandler());
            }
            catch (Throwable throwable) {
                log.debug("Failed to set ErrorHandler on DocumentBuilder", throwable);
            }
            Document document2 = document = documentBuilder.parse(inputSource);
            return document2;
        }
        finally {
            if (documentBuilder != null) {
                XMLUtils.releaseDocumentBuilder(documentBuilder);
            }
        }
    }

    public static Document newDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(new InputSource(inputStream));
    }

    public static Document newDocument(String string) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(string, null, null);
    }

    public static Document newDocument(String string, String string2, String string3) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = XMLUtils.getInputSourceFromURI(string, string2, string3);
        Document document = XMLUtils.newDocument(inputSource);
        if (inputSource.getByteStream() != null) {
            inputSource.getByteStream().close();
        } else if (inputSource.getCharacterStream() != null) {
            inputSource.getCharacterStream().close();
        }
        return document;
    }

    private static String privateElementToString(Element element, boolean bl) {
        return DOM2Writer.nodeToString(element, bl);
    }

    public static String ElementToString(Element element) {
        return XMLUtils.privateElementToString(element, true);
    }

    public static String DocumentToString(Document document) {
        return XMLUtils.privateElementToString(document.getDocumentElement(), false);
    }

    public static String PrettyDocumentToString(Document document) {
        StringWriter stringWriter = new StringWriter();
        XMLUtils.PrettyElementToWriter(document.getDocumentElement(), stringWriter);
        return stringWriter.toString();
    }

    public static void privateElementToWriter(Element element, Writer writer, boolean bl, boolean bl2) {
        DOM2Writer.serializeAsXML(element, writer, bl, bl2);
    }

    public static void ElementToStream(Element element, OutputStream outputStream) {
        Writer writer = XMLUtils.getWriter(outputStream);
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToStream(Element element, OutputStream outputStream) {
        Writer writer = XMLUtils.getWriter(outputStream);
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void ElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void DocumentToStream(Document document, OutputStream outputStream) {
        Writer writer = XMLUtils.getWriter(outputStream);
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToStream(Document document, OutputStream outputStream) {
        Writer writer = XMLUtils.getWriter(outputStream);
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, true);
    }

    private static Writer getWriter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error(Messages.getMessage("exception00"), unsupportedEncodingException);
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        return outputStreamWriter;
    }

    public static void DocumentToWriter(Document document, Writer writer) {
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToWriter(Document document, Writer writer) {
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, true);
    }

    public static Element StringToElement(String string, String string2, String string3) {
        try {
            Document document = XMLUtils.newDocument();
            Element element = document.createElementNS(string, string2);
            Text text = document.createTextNode(string3);
            element.appendChild(text);
            return element;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalException(parserConfigurationException);
        }
    }

    public static String getInnerXMLString(Element element) {
        String string = XMLUtils.ElementToString(element);
        int n = string.indexOf(">") + 1;
        int n2 = string.lastIndexOf("</");
        if (n2 > 0) {
            return string.substring(n, n2);
        }
        return null;
    }

    public static String getPrefix(String string, Node node) {
        while (node != null && node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string2 = attr.getName();
                if (!string2.startsWith("xmlns:") || !attr.getNodeValue().equals(string)) continue;
                return string2.substring(6);
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String string, Node node, Node node2) {
        while (node != null && node.getNodeType() == 1) {
            Attr attr = null;
            attr = string == null ? ((Element)node).getAttributeNode("xmlns") : ((Element)node).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string);
            if (attr != null) {
                return attr.getValue();
            }
            if (node == node2) {
                return null;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String string, Node node) {
        return XMLUtils.getNamespace(string, node, null);
    }

    public static QName getQNameFromString(String string, Node node) {
        return XMLUtils.getQNameFromString(string, node, false);
    }

    public static QName getFullQNameFromString(String string, Node node) {
        return XMLUtils.getQNameFromString(string, node, true);
    }

    private static QName getQNameFromString(String string, Node node, boolean bl) {
        String string2;
        if (string == null || node == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > -1) {
            String string3 = string.substring(0, n);
            String string4 = XMLUtils.getNamespace(string3, node);
            if (string4 == null) {
                return null;
            }
            return new QName(string4, string.substring(n + 1));
        }
        if (bl && (string2 = XMLUtils.getNamespace(null, node)) != null) {
            return new QName(string2, string);
        }
        return new QName("", string);
    }

    public static String getStringForQName(QName qName, Element element) {
        String string = qName.getNamespaceURI();
        String string2 = XMLUtils.getPrefix(string, element);
        if (string2 == null) {
            int n = 1;
            string2 = "ns" + n;
            while (XMLUtils.getNamespace(string2, element) != null) {
                string2 = "ns" + ++n;
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, string);
        }
        return string2 + ":" + qName.getLocalPart();
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static InputSource getInputSourceFromURI(String string) {
        return new InputSource(string);
    }

    public static InputSource sourceToInputSource(Source source) {
        if (source instanceof SAXSource) {
            return ((SAXSource)source).getInputSource();
        }
        if (source instanceof DOMSource) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Node node = ((DOMSource)source).getNode();
            if (node instanceof Document) {
                node = ((Document)node).getDocumentElement();
            }
            Element element = (Element)node;
            XMLUtils.ElementToStream(element, byteArrayOutputStream);
            InputSource inputSource = new InputSource(source.getSystemId());
            inputSource.setByteStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return inputSource;
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputSource inputSource = new InputSource(streamSource.getSystemId());
            inputSource.setByteStream(streamSource.getInputStream());
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setPublicId(streamSource.getPublicId());
            return inputSource;
        }
        return XMLUtils.getInputSourceFromURI(source.getSystemId());
    }

    private static InputSource getInputSourceFromURI(String string, String string2, String string3) throws IOException, ProtocolException, UnsupportedEncodingException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return new InputSource(string);
        }
        if (string2 == null && uRL.getUserInfo() == null) {
            return new InputSource(string);
        }
        if (!uRL.getProtocol().startsWith("http")) {
            return new InputSource(string);
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return new InputSource(string);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        String string4 = uRL.getUserInfo();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(false);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setUseCaches(false);
        String string5 = null;
        if (string4 != null) {
            string5 = string4;
        } else if (string2 != null) {
            String string6 = string5 = string3 == null ? string2 : string2 + ":" + string3;
        }
        if (string5 != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + XMLUtils.base64encode(string5.getBytes(httpAuthCharEncoding)));
        }
        httpURLConnection.connect();
        return new InputSource(httpURLConnection.getInputStream());
    }

    public static final String base64encode(byte[] byArray) {
        return new String(Base64.encode(byArray));
    }

    public static InputSource getEmptyInputSource() {
        return new InputSource(bais);
    }

    public static Node findNode(Node node, QName qName) {
        if (qName.getNamespaceURI().equals(node.getNamespaceURI()) && qName.getLocalPart().equals(node.getLocalName())) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = XMLUtils.findNode(nodeList.item(i), qName);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public static void normalize(Node node) {
        char c;
        Object object;
        if (node.getNodeType() == 3 && ((String)(object = ((Text)node).getData())).length() > 0 && ((c = ((String)object).charAt(((String)object).length() - 1)) == '\n' || c == '\r' || c == ' ')) {
            String string = XMLUtils.trim((String)object);
            ((Text)node).setData(string);
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            XMLUtils.normalize((Node)object);
        }
    }

    public static String trim(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            if ("\r".equals(string) || "\n".equals(string)) {
                return "";
            }
            return string;
        }
        int n = string.length() - 1;
        char c = string.charAt(n);
        while (n > 0 && (c == '\n' || c == '\r' || c == ' ')) {
            c = string.charAt(--n);
        }
        if (n == 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static Element[] asElementArray(List list) {
        Element[] elementArray = new Element[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            elementArray[n++] = (Element)iterator.next();
        }
        return elementArray;
    }

    public static String getEncoding(Message message, MessageContext messageContext) {
        return XMLUtils.getEncoding(message, messageContext, XMLEncoderFactory.getDefaultEncoder());
    }

    public static String getEncoding(Message message, MessageContext messageContext, XMLEncoder xMLEncoder) {
        String string = null;
        try {
            if (message != null) {
                string = (String)message.getProperty("javax.xml.soap.character-set-encoding");
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        if (messageContext == null) {
            messageContext = MessageContext.getCurrentContext();
        }
        if (messageContext != null && string == null) {
            string = (String)messageContext.getProperty("javax.xml.soap.character-set-encoding");
        }
        if (messageContext != null && string == null && messageContext.getAxisEngine() != null) {
            string = (String)messageContext.getAxisEngine().getOption("axis.xmlEncoding");
        }
        if (string == null && xMLEncoder != null) {
            string = xMLEncoder.getEncoding();
        }
        return string;
    }

    static {
        saxParsers = new Stack();
        doNothingContentHandler = new DefaultHandler();
        EMPTY = "";
        bais = new ByteArrayInputStream(EMPTY.getBytes());
        tryReset = true;
        enableParserReuse = false;
        documentBuilder = new ThreadLocalDocumentBuilder();
        XMLUtils.initSAXFactory(null, true, false);
        String string = AxisProperties.getProperty("axis.xml.reuseParsers", "false");
        enableParserReuse = string.equalsIgnoreCase("true") || string.equals("1") || string.equalsIgnoreCase("yes");
    }

    public static class ParserErrorHandler
    implements ErrorHandler {
        protected static Log log = LogFactory.getLog(ParserErrorHandler.class.getName());

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("warning00", this.getParseExceptionInfo(sAXParseException)));
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }
    }

    private static class ThreadLocalDocumentBuilder
    extends ThreadLocal {
        private ThreadLocalDocumentBuilder() {
        }

        protected Object initialValue() {
            try {
                return XMLUtils.getDOMFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                log.error(Messages.getMessage("parserConfigurationException00"), parserConfigurationException);
                return null;
            }
        }
    }
}

