/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.bytecode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.utils.Messages;

public class ClassReader
extends ByteArrayInputStream {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private int[] cpoolIndex;
    private Object[] cpool;
    private Map attrMethods;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getBytes(Class clazz) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream('/' + clazz.getName().replace('.', '/') + ".class");
        if (inputStream == null) {
            throw new IOException(Messages.getMessage("cantLoadByecode", clazz.getName()));
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n > 0);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    static String classDescriptorToName(String string) {
        return string.replace('/', '.');
    }

    protected static Map findAttributeReaders(Class clazz) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith("read") || methodArray[i].getReturnType() != Void.TYPE) continue;
            hashMap.put(string.substring(4), methodArray[i]);
        }
        return hashMap;
    }

    protected static String getSignature(Member member, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer(member instanceof Method ? member.getName() : "<init>");
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            ClassReader.addDescriptor(stringBuffer, classArray[i]);
        }
        stringBuffer.append(')');
        if (member instanceof Method) {
            ClassReader.addDescriptor(stringBuffer, ((Method)member).getReturnType());
        } else if (member instanceof Constructor) {
            ClassReader.addDescriptor(stringBuffer, Void.TYPE);
        }
        return stringBuffer.toString();
    }

    private static void addDescriptor(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                stringBuffer.append('V');
            } else if (clazz == Integer.TYPE) {
                stringBuffer.append('I');
            } else if (clazz == Boolean.TYPE) {
                stringBuffer.append('Z');
            } else if (clazz == Byte.TYPE) {
                stringBuffer.append('B');
            } else if (clazz == Short.TYPE) {
                stringBuffer.append('S');
            } else if (clazz == Long.TYPE) {
                stringBuffer.append('J');
            } else if (clazz == Character.TYPE) {
                stringBuffer.append('C');
            } else if (clazz == Float.TYPE) {
                stringBuffer.append('F');
            } else if (clazz == Double.TYPE) {
                stringBuffer.append('D');
            }
        } else if (clazz.isArray()) {
            stringBuffer.append('[');
            ClassReader.addDescriptor(stringBuffer, clazz.getComponentType());
        } else {
            stringBuffer.append('L').append(clazz.getName().replace('.', '/')).append(';');
        }
    }

    protected final int readShort() {
        return this.read() << 8 | this.read();
    }

    protected final int readInt() {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    protected void skipFully(int n) throws IOException {
        while (n > 0) {
            int n2 = (int)this.skip(n);
            if (n2 <= 0) {
                throw new EOFException(Messages.getMessage("unexpectedEOF00"));
            }
            n -= n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Member resolveMethod(int n) throws IOException, ClassNotFoundException, NoSuchMethodException {
        int n2 = this.pos;
        try {
            Executable executable = (Constructor<?>)this.cpool[n];
            if (executable == null) {
                this.pos = this.cpoolIndex[n];
                Class clazz = this.resolveClass(this.readShort());
                NameAndType nameAndType = this.resolveNameAndType(this.readShort());
                String string = nameAndType.name + nameAndType.type;
                if (nameAndType.name.equals("<init>")) {
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    for (int i = 0; i < constructorArray.length; ++i) {
                        String string2 = ClassReader.getSignature(constructorArray[i], constructorArray[i].getParameterTypes());
                        if (!string2.equals(string)) continue;
                        this.cpool[n] = executable = constructorArray[i];
                        Executable executable2 = executable;
                        return executable2;
                    }
                } else {
                    Method[] methodArray = clazz.getDeclaredMethods();
                    for (int i = 0; i < methodArray.length; ++i) {
                        String string3 = ClassReader.getSignature(methodArray[i], methodArray[i].getParameterTypes());
                        if (!string3.equals(string)) continue;
                        executable = methodArray[i];
                        this.cpool[n] = executable;
                        Executable executable3 = executable;
                        return executable3;
                    }
                }
                throw new NoSuchMethodException(string);
            }
            Constructor<?> constructor = executable;
            return constructor;
        }
        finally {
            this.pos = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Field resolveField(int n) throws IOException, ClassNotFoundException, NoSuchFieldException {
        int n2 = this.pos;
        try {
            AnnotatedElement annotatedElement;
            Field field = (Field)this.cpool[n];
            if (field == null) {
                this.pos = this.cpoolIndex[n];
                annotatedElement = this.resolveClass(this.readShort());
                NameAndType nameAndType = this.resolveNameAndType(this.readShort());
                field = ((Class)annotatedElement).getDeclaredField(nameAndType.name);
                this.cpool[n] = field;
            }
            annotatedElement = field;
            return annotatedElement;
        }
        finally {
            this.pos = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NameAndType resolveNameAndType(int n) throws IOException {
        int n2 = this.pos;
        try {
            Object object;
            NameAndType nameAndType = (NameAndType)this.cpool[n];
            if (nameAndType == null) {
                this.pos = this.cpoolIndex[n];
                object = this.resolveUtf8(this.readShort());
                String string = this.resolveUtf8(this.readShort());
                nameAndType = new NameAndType((String)object, string);
                this.cpool[n] = nameAndType;
            }
            object = nameAndType;
            return object;
        }
        finally {
            this.pos = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Class resolveClass(int n) throws IOException, ClassNotFoundException {
        int n2 = this.pos;
        try {
            Object object;
            Class<?> clazz = (Class<?>)this.cpool[n];
            if (clazz == null) {
                this.pos = this.cpoolIndex[n];
                object = this.resolveUtf8(this.readShort());
                this.cpool[n] = clazz = Class.forName(ClassReader.classDescriptorToName((String)object));
            }
            object = clazz;
            return object;
        }
        finally {
            this.pos = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String resolveUtf8(int n) throws IOException {
        int n2 = this.pos;
        try {
            String string = (String)this.cpool[n];
            if (string == null) {
                this.pos = this.cpoolIndex[n];
                int n3 = this.readShort();
                this.skipFully(n3);
                string = new String(this.buf, this.pos - n3, n3, "utf-8");
                this.cpool[n] = string;
            }
            String string2 = string;
            return string2;
        }
        finally {
            this.pos = n2;
        }
    }

    protected final void readCpool() throws IOException {
        int n = this.readShort();
        this.cpoolIndex = new int[n];
        this.cpool = new Object[n];
        block7: for (int i = 1; i < n; ++i) {
            int n2 = this.read();
            this.cpoolIndex[i] = this.pos;
            switch (n2) {
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.readShort();
                }
                case 7: 
                case 8: {
                    this.readShort();
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.readInt();
                    ++i;
                }
                case 3: 
                case 4: {
                    this.readInt();
                    continue block7;
                }
                case 1: {
                    int n3 = this.readShort();
                    this.skipFully(n3);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(Messages.getMessage("unexpectedBytes00"));
                }
            }
        }
    }

    protected final void skipAttributes() throws IOException {
        int n = this.readShort();
        for (int i = 0; i < n; ++i) {
            this.readShort();
            this.skipFully(this.readInt());
        }
    }

    protected final void readAttributes() throws IOException {
        int n = this.readShort();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readShort();
            int n3 = this.readInt();
            int n4 = this.pos;
            String string = this.resolveUtf8(n2);
            Method method = (Method)this.attrMethods.get(string);
            if (method != null) {
                try {
                    method.invoke((Object)this, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.pos = n4;
                    this.skipFully(n3);
                }
                catch (InvocationTargetException invocationTargetException) {
                    try {
                        throw invocationTargetException.getTargetException();
                    }
                    catch (Error error) {
                        throw error;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Throwable throwable) {
                        this.pos = n4;
                        this.skipFully(n3);
                    }
                }
                continue;
            }
            this.skipFully(n3);
        }
    }

    public void readCode() throws IOException {
        this.readShort();
        this.readShort();
        this.skipFully(this.readInt());
        this.skipFully(8 * this.readShort());
        this.readAttributes();
    }

    protected ClassReader(byte[] byArray, Map map) {
        super(byArray);
        this.attrMethods = map;
    }

    private static class NameAndType {
        String name;
        String type;

        public NameAndType(String string, String string2) {
            this.name = string;
            this.type = string2;
        }
    }
}

