/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.CLUtil;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Emitter;

public class Java2WSDL {
    protected static final int INHERITED_CLASS_OPT = 97;
    protected static final int SOAPACTION_OPT = 65;
    protected static final int BINDING_NAME_OPT = 98;
    protected static final int STOP_CLASSES_OPT = 99;
    protected static final int IMPORT_SCHEMA_OPT = 67;
    protected static final int EXTRA_CLASSES_OPT = 101;
    protected static final int HELP_OPT = 104;
    protected static final int IMPL_CLASS_OPT = 105;
    protected static final int INPUT_OPT = 73;
    protected static final int LOCATION_OPT = 108;
    protected static final int LOCATION_IMPORT_OPT = 76;
    protected static final int METHODS_ALLOWED_OPT = 109;
    protected static final int NAMESPACE_OPT = 110;
    protected static final int NAMESPACE_IMPL_OPT = 78;
    protected static final int OUTPUT_OPT = 111;
    protected static final int OUTPUT_IMPL_OPT = 79;
    protected static final int PACKAGE_OPT = 112;
    protected static final int PORTTYPE_NAME_OPT = 80;
    protected static final int SERVICE_PORT_NAME_OPT = 115;
    protected static final int SERVICE_ELEMENT_NAME_OPT = 83;
    protected static final int TYPEMAPPING_OPT = 84;
    protected static final int USE_OPT = 117;
    protected static final int OUTPUT_WSDL_MODE_OPT = 119;
    protected static final int METHODS_NOTALLOWED_OPT = 120;
    protected static final int CLASSPATH_OPT = 88;
    protected static final int STYLE_OPT = 121;
    protected static final int DEPLOY_OPT = 100;
    protected CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, Messages.getMessage("j2wopthelp00")), new CLOptionDescriptor("input", 2, 73, Messages.getMessage("j2woptinput00")), new CLOptionDescriptor("output", 2, 111, Messages.getMessage("j2woptoutput00")), new CLOptionDescriptor("location", 2, 108, Messages.getMessage("j2woptlocation00")), new CLOptionDescriptor("portTypeName", 2, 80, Messages.getMessage("j2woptportTypeName00")), new CLOptionDescriptor("bindingName", 2, 98, Messages.getMessage("j2woptbindingName00")), new CLOptionDescriptor("serviceElementName", 2, 83, Messages.getMessage("j2woptserviceElementName00")), new CLOptionDescriptor("servicePortName", 2, 115, Messages.getMessage("j2woptservicePortName00")), new CLOptionDescriptor("namespace", 2, 110, Messages.getMessage("j2woptnamespace00")), new CLOptionDescriptor("PkgtoNS", 48, 112, Messages.getMessage("j2woptPkgtoNS00")), new CLOptionDescriptor("methods", 34, 109, Messages.getMessage("j2woptmethods00")), new CLOptionDescriptor("all", 8, 97, Messages.getMessage("j2woptall00")), new CLOptionDescriptor("outputWsdlMode", 2, 119, Messages.getMessage("j2woptoutputWsdlMode00")), new CLOptionDescriptor("locationImport", 2, 76, Messages.getMessage("j2woptlocationImport00")), new CLOptionDescriptor("namespaceImpl", 2, 78, Messages.getMessage("j2woptnamespaceImpl00")), new CLOptionDescriptor("outputImpl", 2, 79, Messages.getMessage("j2woptoutputImpl00")), new CLOptionDescriptor("implClass", 2, 105, Messages.getMessage("j2woptimplClass00")), new CLOptionDescriptor("exclude", 34, 120, Messages.getMessage("j2woptexclude00")), new CLOptionDescriptor("stopClasses", 34, 99, Messages.getMessage("j2woptstopClass00")), new CLOptionDescriptor("typeMappingVersion", 2, 84, Messages.getMessage("j2wopttypeMapping00")), new CLOptionDescriptor("soapAction", 2, 65, Messages.getMessage("j2woptsoapAction00")), new CLOptionDescriptor("style", 2, 121, Messages.getMessage("j2woptStyle00")), new CLOptionDescriptor("use", 2, 117, Messages.getMessage("j2woptUse00")), new CLOptionDescriptor("extraClasses", 34, 101, Messages.getMessage("j2woptExtraClasses00")), new CLOptionDescriptor("importSchema", 4, 67, Messages.getMessage("j2woptImportSchema00")), new CLOptionDescriptor("classpath", 4, 88, Messages.getMessage("optionClasspath")), new CLOptionDescriptor("deploy", 8, 100, Messages.getMessage("j2woptDeploy00"))};
    protected Emitter emitter;
    protected String className = null;
    protected String wsdlFilename = null;
    protected String wsdlImplFilename = null;
    protected HashMap namespaceMap = new HashMap();
    protected int mode = 0;
    boolean locationSet = false;
    protected String typeMappingVersion = "1.2";
    protected boolean isDeploy = false;

    protected Java2WSDL() {
        this.emitter = this.createEmitter();
    }

    protected Emitter createEmitter() {
        return new Emitter();
    }

    protected void addOptions(CLOptionDescriptor[] cLOptionDescriptorArray) {
        if (cLOptionDescriptorArray != null && cLOptionDescriptorArray.length > 0) {
            CLOptionDescriptor[] cLOptionDescriptorArray2 = new CLOptionDescriptor[this.options.length + cLOptionDescriptorArray.length];
            System.arraycopy(this.options, 0, cLOptionDescriptorArray2, 0, this.options.length);
            System.arraycopy(cLOptionDescriptorArray, 0, cLOptionDescriptorArray2, this.options.length, cLOptionDescriptorArray.length);
            this.options = cLOptionDescriptorArray2;
        }
    }

    protected boolean parseOption(CLOption cLOption) {
        boolean bl = true;
        switch (cLOption.getId()) {
            case 0: {
                if (this.className != null) {
                    System.out.println(Messages.getMessage("j2wDuplicateClass00", this.className, cLOption.getArgument()));
                    this.printUsage();
                    bl = false;
                }
                this.className = cLOption.getArgument();
                break;
            }
            case 109: {
                this.emitter.setAllowedMethods(cLOption.getArgument());
                break;
            }
            case 97: {
                this.emitter.setUseInheritedMethods(true);
                break;
            }
            case 105: {
                this.emitter.setImplCls(cLOption.getArgument());
                break;
            }
            case 104: {
                this.printUsage();
                bl = false;
                break;
            }
            case 119: {
                String string = cLOption.getArgument();
                if ("All".equalsIgnoreCase(string)) {
                    this.mode = 0;
                    break;
                }
                if ("Interface".equalsIgnoreCase(string)) {
                    this.mode = 1;
                    break;
                }
                if ("Implementation".equalsIgnoreCase(string)) {
                    this.mode = 2;
                    break;
                }
                this.mode = 0;
                System.err.println(Messages.getMessage("j2wmodeerror", string));
                break;
            }
            case 111: {
                this.wsdlFilename = cLOption.getArgument();
                break;
            }
            case 73: {
                this.emitter.setInputWSDL(cLOption.getArgument());
                break;
            }
            case 79: {
                this.wsdlImplFilename = cLOption.getArgument();
                break;
            }
            case 112: {
                String string = cLOption.getArgument(0);
                String string2 = cLOption.getArgument(1);
                this.namespaceMap.put(string, string2);
                break;
            }
            case 110: {
                this.emitter.setIntfNamespace(cLOption.getArgument());
                break;
            }
            case 78: {
                this.emitter.setImplNamespace(cLOption.getArgument());
                break;
            }
            case 83: {
                this.emitter.setServiceElementName(cLOption.getArgument());
                break;
            }
            case 115: {
                this.emitter.setServicePortName(cLOption.getArgument());
                break;
            }
            case 108: {
                this.emitter.setLocationUrl(cLOption.getArgument());
                this.locationSet = true;
                break;
            }
            case 76: {
                this.emitter.setImportUrl(cLOption.getArgument());
                break;
            }
            case 120: {
                this.emitter.setDisallowedMethods(cLOption.getArgument());
                break;
            }
            case 80: {
                this.emitter.setPortTypeName(cLOption.getArgument());
                break;
            }
            case 98: {
                this.emitter.setBindingName(cLOption.getArgument());
                break;
            }
            case 99: {
                this.emitter.setStopClasses(cLOption.getArgument());
                break;
            }
            case 84: {
                String string;
                this.typeMappingVersion = string = cLOption.getArgument();
                break;
            }
            case 65: {
                String string = cLOption.getArgument();
                if (string.equalsIgnoreCase("DEFAULT")) {
                    this.emitter.setSoapAction("DEFAULT");
                    break;
                }
                if (string.equalsIgnoreCase("OPERATION")) {
                    this.emitter.setSoapAction("OPERATION");
                    break;
                }
                if (string.equalsIgnoreCase("NONE")) {
                    this.emitter.setSoapAction("NONE");
                    break;
                }
                System.out.println(Messages.getMessage("j2wBadSoapAction00"));
                bl = false;
                break;
            }
            case 121: {
                String string = cLOption.getArgument();
                if (string.equalsIgnoreCase("DOCUMENT") || string.equalsIgnoreCase("RPC") || string.equalsIgnoreCase("WRAPPED")) {
                    this.emitter.setStyle(string);
                    break;
                }
                System.out.println(Messages.getMessage("j2woptBadStyle00"));
                bl = false;
                break;
            }
            case 117: {
                String string = cLOption.getArgument();
                if (string.equalsIgnoreCase("LITERAL") || string.equalsIgnoreCase("ENCODED")) {
                    this.emitter.setUse(string);
                    break;
                }
                System.out.println(Messages.getMessage("j2woptBadUse00"));
                bl = false;
                break;
            }
            case 101: {
                try {
                    this.emitter.setExtraClasses(cLOption.getArgument());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println(Messages.getMessage("j2woptBadClass00", classNotFoundException.toString()));
                    bl = false;
                }
                break;
            }
            case 67: {
                this.emitter.setInputSchema(cLOption.getArgument());
                break;
            }
            case 88: {
                ClassUtils.setDefaultClassLoader(ClassUtils.createClassLoader(cLOption.getArgument(), this.getClass().getClassLoader()));
                break;
            }
            case 100: {
                this.isDeploy = true;
                break;
            }
        }
        return bl;
    }

    protected boolean validateOptions() {
        if (this.className == null) {
            System.out.println(Messages.getMessage("j2wMissingClass00"));
            this.printUsage();
            return false;
        }
        if (!(this.locationSet || this.mode != 0 && this.mode != 2)) {
            System.out.println(Messages.getMessage("j2wMissingLocation00"));
            this.printUsage();
            return false;
        }
        return true;
    }

    protected int run(String[] stringArray) {
        CLArgsParser cLArgsParser = new CLArgsParser(stringArray, this.options);
        if (null != cLArgsParser.getErrorString()) {
            System.err.println(Messages.getMessage("j2werror00", cLArgsParser.getErrorString()));
            this.printUsage();
            return 1;
        }
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        try {
            for (int i = 0; i < n; ++i) {
                if (this.parseOption((CLOption)vector.get(i))) continue;
                return 1;
            }
            if (!this.validateOptions()) {
                return 1;
            }
            if (!this.namespaceMap.isEmpty()) {
                this.emitter.setNamespaceMap(this.namespaceMap);
            }
            TypeMappingRegistryImpl typeMappingRegistryImpl = new TypeMappingRegistryImpl();
            typeMappingRegistryImpl.doRegisterFromVersion(this.typeMappingVersion);
            this.emitter.setTypeMappingRegistry(typeMappingRegistryImpl);
            this.emitter.setCls(this.className);
            if (this.wsdlImplFilename == null) {
                this.emitter.emit(this.wsdlFilename, this.mode);
            } else {
                this.emitter.emit(this.wsdlFilename, this.wsdlImplFilename);
            }
            if (this.isDeploy) {
                this.generateServerSide(this.emitter, this.wsdlImplFilename != null ? this.wsdlImplFilename : this.wsdlFilename);
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 1;
        }
    }

    protected void generateServerSide(Emitter emitter, String string) throws Exception {
        org.apache.axis.wsdl.toJava.Emitter emitter2 = new org.apache.axis.wsdl.toJava.Emitter();
        File file = new File(string);
        emitter2.setServiceDesc(emitter.getServiceDesc());
        emitter2.setQName2ClassMap(emitter.getQName2ClassMap());
        emitter2.setOutputDir(file.getParent());
        emitter2.setServerSide(true);
        emitter2.setHelperWanted(true);
        String string2 = emitter.getIntfNamespace();
        String string32 = emitter.getCls().getPackage().getName();
        emitter2.getNamespaceMap().put(string2, string32);
        Map map = emitter.getNamespaceMap();
        if (map != null) {
            for (String string32 : map.keySet()) {
                string2 = (String)map.get(string32);
                emitter2.getNamespaceMap().put(string2, string32);
            }
        }
        emitter2.setDeploy(true);
        if (emitter.getImplCls() != null) {
            emitter2.setImplementationClassName(emitter.getImplCls().getName());
        } else if (!emitter.getCls().isInterface()) {
            emitter2.setImplementationClassName(emitter.getCls().getName());
        } else {
            throw new Exception("implementation class is not specified.");
        }
        emitter2.run(string);
    }

    protected void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Java2WSDL " + Messages.getMessage("j2wemitter00")).append(string);
        stringBuffer.append(Messages.getMessage("j2wusage00", "java " + this.getClass().getName() + " [options] class-of-portType")).append(string);
        stringBuffer.append(Messages.getMessage("j2woptions00")).append(string);
        stringBuffer.append(CLUtil.describeOptions(this.options).toString());
        stringBuffer.append(Messages.getMessage("j2wdetails00")).append(string);
        System.out.println(stringBuffer.toString());
    }

    public static void main(String[] stringArray) {
        Java2WSDL java2WSDL = new Java2WSDL();
        System.exit(java2WSDL.run(stringArray));
    }
}

