/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.wsdl.Message;
import org.apache.axis.constants.Use;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaFaultWriter
extends JavaClassWriter {
    private Message faultMessage;
    private SymbolTable symbolTable;
    private boolean literal;
    private String faultName;

    protected JavaFaultWriter(Emitter emitter, SymbolTable symbolTable, FaultInfo faultInfo) {
        super(emitter, Utils.getFullExceptionName(faultInfo.getMessage(), symbolTable), "fault");
        this.literal = faultInfo.getUse().equals(Use.LITERAL);
        this.faultMessage = faultInfo.getMessage();
        this.symbolTable = symbolTable;
        this.faultName = faultInfo.getName();
    }

    protected String getExtendsText() {
        return "extends org.apache.axis.AxisFault ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        String string;
        String string2;
        Parameter parameter;
        int n;
        Vector vector = new Vector();
        this.symbolTable.getParametersFromParts(vector, this.faultMessage.getOrderedParts(null), this.literal, this.faultName, null);
        for (n = 0; n < vector.size(); ++n) {
            parameter = (Parameter)vector.get(n);
            string2 = parameter.getType().getName();
            string = Utils.xmlNameToJava(parameter.getName());
            printWriter.println("    public " + string2 + " " + string + ";");
            printWriter.println("    public " + string2 + " get" + Utils.capitalizeFirstChar(string) + "() {");
            printWriter.println("        return this." + string + ";");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println("    public " + this.className + "() {");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + this.className + "(java.lang.Exception target) {");
        printWriter.println("        super(target);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + this.className + "(java.lang.String message, java.lang.Throwable t) {");
        printWriter.println("        super(message, t);");
        printWriter.println("    }");
        printWriter.println();
        if (vector.size() > 0) {
            printWriter.print("      public " + this.className + "(");
            for (n = 0; n < vector.size(); ++n) {
                if (n != 0) {
                    printWriter.print(", ");
                }
                parameter = (Parameter)vector.get(n);
                string2 = parameter.getType().getName();
                string = Utils.xmlNameToJava(parameter.getName());
                printWriter.print(string2 + " " + string);
            }
            printWriter.println(") {");
            for (n = 0; n < vector.size(); ++n) {
                parameter = (Parameter)vector.get(n);
                string2 = Utils.xmlNameToJava(parameter.getName());
                printWriter.println("        this." + string2 + " = " + string2 + ";");
            }
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Writes the exception data to the faultDetails");
        printWriter.println("     */");
        printWriter.println("    public void writeDetails(javax.xml.namespace.QName qname, org.apache.axis.encoding.SerializationContext context) throws java.io.IOException {");
        for (n = 0; n < vector.size(); ++n) {
            parameter = (Parameter)vector.get(n);
            string2 = Utils.xmlNameToJava(parameter.getName());
            printWriter.println("        context.serialize(qname, null, " + Utils.wrapPrimitiveType(parameter.getType(), string2) + ");");
        }
        printWriter.println("    }");
    }
}

