/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.StringUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.commons.logging.Log;

public class JavaStubWriter
extends JavaClassWriter {
    protected static Log log = LogFactory.getLog(JavaStubWriter.class.getName());
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    private static final int MAXIMUM_BINDINGS_PER_METHOD = 100;
    static String[] modeStrings = new String[]{"", "org.apache.axis.description.ParameterDesc.IN", "org.apache.axis.description.ParameterDesc.OUT", "org.apache.axis.description.ParameterDesc.INOUT"};
    static Map styles = new HashMap();
    static Map uses = new HashMap();
    static int OPERDESC_PER_BLOCK;

    public JavaStubWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, bindingEntry.getName() + "Stub", "stub");
        this.bEntry = bindingEntry;
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends org.apache.axis.client.Stub ";
    }

    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        Serializable serializable;
        Object object;
        int n;
        PortType portType = this.binding.getPortType();
        HashSet hashSet = this.getTypesInPortType(portType);
        boolean bl = Utils.hasMIME(this.bEntry);
        if (hashSet.size() > 0 || bl) {
            printWriter.println("    private java.util.Vector cachedSerClasses = new java.util.Vector();");
            printWriter.println("    private java.util.Vector cachedSerQNames = new java.util.Vector();");
            printWriter.println("    private java.util.Vector cachedSerFactories = new java.util.Vector();");
            printWriter.println("    private java.util.Vector cachedDeserFactories = new java.util.Vector();");
        }
        printWriter.println();
        printWriter.println("    static org.apache.axis.description.OperationDesc [] _operations;");
        printWriter.println();
        this.writeOperationMap(printWriter);
        printWriter.println();
        printWriter.println("    public " + this.className + "() throws org.apache.axis.AxisFault {");
        printWriter.println("         this(null);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        printWriter.println("         this(service);");
        printWriter.println("         super.cachedEndpoint = endpointURL;");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + this.className + "(javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        printWriter.println("        if (service == null) {");
        printWriter.println("            super.service = new org.apache.axis.client.Service();");
        printWriter.println("        } else {");
        printWriter.println("            super.service = service;");
        printWriter.println("        }");
        printWriter.println("        ((org.apache.axis.client.Service)super.service).setTypeMappingVersion(\"" + this.emitter.getTypeMappingVersion() + "\");");
        ArrayList<TypeEntry> arrayList = new ArrayList<TypeEntry>();
        int n2 = 0;
        if (hashSet.size() > 0) {
            for (Object object2 : hashSet) {
                if (!Utils.shouldEmit((TypeEntry)object2)) continue;
                if (n2 == 0) {
                    this.writeSerializationDecls(printWriter, bl, this.binding.getQName().getNamespaceURI());
                }
                arrayList.add((TypeEntry)object2);
                ++n2;
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                TypeEntry typeEntry = (TypeEntry)object;
                TypeEntry typeEntry2 = (TypeEntry)object2;
                return typeEntry.getQName().toString().compareToIgnoreCase(typeEntry2.getQName().toString());
            }
        });
        if (n2 == 0 && bl) {
            this.writeSerializationDecls(printWriter, bl, this.binding.getQName().getNamespaceURI());
            ++n2;
        }
        boolean bl2 = false;
        if (arrayList.size() < 100) {
            Object object2;
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                this.writeSerializationInit(printWriter, (TypeEntry)object2.next());
            }
        } else {
            bl2 = true;
            int n3 = this.calculateBindingMethodCount(arrayList);
            for (n = 0; n < n3; ++n) {
                printWriter.println("        addBindings" + n + "();");
            }
        }
        printWriter.println("    }");
        printWriter.println();
        if (bl2) {
            this.writeBindingMethods(printWriter, arrayList);
            printWriter.println();
        }
        printWriter.println("    protected org.apache.axis.client.Call createCall() throws java.rmi.RemoteException {");
        printWriter.println("        try {");
        printWriter.println("            org.apache.axis.client.Call _call = super._createCall();");
        printWriter.println("            if (super.maintainSessionSet) {");
        printWriter.println("                _call.setMaintainSession(super.maintainSession);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedUsername != null) {");
        printWriter.println("                _call.setUsername(super.cachedUsername);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedPassword != null) {");
        printWriter.println("                _call.setPassword(super.cachedPassword);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedEndpoint != null) {");
        printWriter.println("                _call.setTargetEndpointAddress(super.cachedEndpoint);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedTimeout != null) {");
        printWriter.println("                _call.setTimeout(super.cachedTimeout);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedPortName != null) {");
        printWriter.println("                _call.setPortName(super.cachedPortName);");
        printWriter.println("            }");
        printWriter.println("            java.util.Enumeration keys = super.cachedProperties.keys();");
        printWriter.println("            while (keys.hasMoreElements()) {");
        printWriter.println("                java.lang.String key = (java.lang.String) keys.nextElement();");
        printWriter.println("                _call.setProperty(key, super.cachedProperties.get(key));");
        printWriter.println("            }");
        if (n2 > 0) {
            printWriter.println("            // " + Messages.getMessage("typeMap00"));
            printWriter.println("            // " + Messages.getMessage("typeMap01"));
            printWriter.println("            // " + Messages.getMessage("typeMap02"));
            printWriter.println("            // " + Messages.getMessage("typeMap03"));
            printWriter.println("            // " + Messages.getMessage("typeMap04"));
            printWriter.println("            synchronized (this) {");
            printWriter.println("                if (firstCall()) {");
            printWriter.println("                    // " + Messages.getMessage("mustSetStyle"));
            if (this.bEntry.hasLiteral()) {
                printWriter.println("                    _call.setEncodingStyle(null);");
            } else {
                for (Object e : this.bEntry.getBinding().getExtensibilityElements()) {
                    if (e instanceof SOAPBinding) {
                        printWriter.println("                    _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP11_CONSTANTS);");
                        printWriter.println("                    _call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP11_ENC);");
                        continue;
                    }
                    if (!(e instanceof UnknownExtensibilityElement) || !((QName)(object = ((UnknownExtensibilityElement)(serializable = (UnknownExtensibilityElement)e)).getElementType())).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !((QName)object).getLocalPart().equals("binding")) continue;
                    printWriter.println("                    _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP12_CONSTANTS);");
                    printWriter.println("                    _call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP12_ENC);");
                }
            }
            printWriter.println("                    for (int i = 0; i < cachedSerFactories.size(); ++i) {");
            printWriter.println("                        java.lang.Class cls = (java.lang.Class) cachedSerClasses.get(i);");
            printWriter.println("                        javax.xml.namespace.QName qName =");
            printWriter.println("                                (javax.xml.namespace.QName) cachedSerQNames.get(i);");
            printWriter.println("                        java.lang.Object x = cachedSerFactories.get(i);");
            printWriter.println("                        if (x instanceof Class) {");
            printWriter.println("                            java.lang.Class sf = (java.lang.Class)");
            printWriter.println("                                 cachedSerFactories.get(i);");
            printWriter.println("                            java.lang.Class df = (java.lang.Class)");
            printWriter.println("                                 cachedDeserFactories.get(i);");
            printWriter.println("                            _call.registerTypeMapping(cls, qName, sf, df, false);");
            printWriter.println("                        }");
            printWriter.println("                        else if (x instanceof javax.xml.rpc.encoding.SerializerFactory) {");
            printWriter.println("                            org.apache.axis.encoding.SerializerFactory sf = (org.apache.axis.encoding.SerializerFactory)");
            printWriter.println("                                 cachedSerFactories.get(i);");
            printWriter.println("                            org.apache.axis.encoding.DeserializerFactory df = (org.apache.axis.encoding.DeserializerFactory)");
            printWriter.println("                                 cachedDeserFactories.get(i);");
            printWriter.println("                            _call.registerTypeMapping(cls, qName, sf, df, false);");
            printWriter.println("                        }");
            printWriter.println("                    }");
            printWriter.println("                }");
            printWriter.println("            }");
        }
        printWriter.println("            return _call;");
        printWriter.println("        }");
        printWriter.println("        catch (java.lang.Throwable _t) {");
        printWriter.println("            throw new org.apache.axis.AxisFault(\"" + Messages.getMessage("badCall01") + "\", _t);");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
        List list = this.binding.getBindingOperations();
        for (n = 0; n < list.size(); ++n) {
            Serializable serializable2;
            Object object32;
            serializable = (BindingOperation)list.get(n);
            object = this.bEntry.getParameters(serializable.getOperation());
            String string = "";
            String string2 = null;
            for (Object object32 : serializable.getExtensibilityElements()) {
                QName qName;
                if (object32 instanceof SOAPOperation) {
                    string = ((SOAPOperation)object32).getSoapActionURI();
                    string2 = ((SOAPOperation)object32).getStyle();
                    break;
                }
                if (!(object32 instanceof UnknownExtensibilityElement) || !(qName = ((UnknownExtensibilityElement)(serializable2 = (UnknownExtensibilityElement)object32)).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !qName.getLocalPart().equals("operation")) continue;
                if (((UnknownExtensibilityElement)serializable2).getElement().getAttribute("soapAction") != null) {
                    string = ((UnknownExtensibilityElement)serializable2).getElement().getAttribute("soapAction");
                }
                string2 = ((UnknownExtensibilityElement)serializable2).getElement().getAttribute("style");
            }
            if (OperationType.NOTIFICATION.equals((OperationType)(serializable2 = (object32 = serializable.getOperation()).getStyle())) || OperationType.SOLICIT_RESPONSE.equals((OperationType)serializable2)) {
                printWriter.println(((Parameters)object).signature);
                printWriter.println();
                continue;
            }
            this.writeOperation(printWriter, (BindingOperation)serializable, (Parameters)object, string, string2, serializable2 == OperationType.ONE_WAY, n);
        }
    }

    private int calculateBindingMethodCount(List list) {
        int n = list.size() / 100;
        if (list.size() % 100 != 0) {
            ++n;
        }
        return n;
    }

    protected void writeBindingMethods(PrintWriter printWriter, List list) {
        int n = this.calculateBindingMethodCount(list);
        for (int i = 0; i < n; ++i) {
            int n2;
            printWriter.println("    private void addBindings" + i + "() {");
            this.writeSerializationDecls(printWriter, false, null);
            for (int j = 0; j < 100 && (n2 = i * 100 + j) != list.size(); ++j) {
                this.writeSerializationInit(printWriter, (TypeEntry)list.get(n2));
            }
            printWriter.println("    }");
        }
    }

    protected void writeOperationMap(PrintWriter printWriter) {
        int n;
        List list = this.binding.getBindingOperations();
        printWriter.println("    static {");
        printWriter.println("        _operations = new org.apache.axis.description.OperationDesc[" + list.size() + "];");
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            if (n % OPERDESC_PER_BLOCK != 0) continue;
            printWriter.println("        _initOperationDesc" + ++n2 + "();");
        }
        n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            Object object5;
            Object object62;
            if (n % OPERDESC_PER_BLOCK == 0) {
                printWriter.println("    }\n");
                printWriter.println("    private static void _initOperationDesc" + ++n2 + "(){");
                printWriter.println("        org.apache.axis.description.OperationDesc oper;");
                printWriter.println("        org.apache.axis.description.ParameterDesc param;");
            }
            BindingOperation bindingOperation = (BindingOperation)list.get(n);
            Parameters parameters = this.bEntry.getParameters(bindingOperation.getOperation());
            String string = null;
            for (Object object62 : bindingOperation.getExtensibilityElements()) {
                if (object62 instanceof SOAPOperation) {
                    string = ((SOAPOperation)object62).getStyle();
                    break;
                }
                if (!(object62 instanceof UnknownExtensibilityElement) || !((QName)(object5 = ((UnknownExtensibilityElement)(serializable = (UnknownExtensibilityElement)object62)).getElementType())).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !((QName)object5).getLocalPart().equals("operation")) continue;
                string = ((UnknownExtensibilityElement)serializable).getElement().getAttribute("style");
            }
            if (OperationType.NOTIFICATION.equals((OperationType)(serializable = (object62 = bindingOperation.getOperation()).getStyle())) || OperationType.SOLICIT_RESPONSE.equals((OperationType)serializable)) {
                printWriter.println(parameters.signature);
                printWriter.println();
            }
            object5 = bindingOperation.getName();
            String string2 = "        ";
            printWriter.println(string2 + "oper = new org.apache.axis.description.OperationDesc();");
            printWriter.println(string2 + "oper.setName(\"" + (String)object5 + "\");");
            for (int i = 0; i < parameters.list.size(); ++i) {
                object4 = (Parameter)parameters.list.get(i);
                object3 = Utils.getXSIType((Parameter)object4);
                object2 = Utils.getParameterTypeName((Parameter)object4);
                object2 = object2 != null ? (String)object2 + ".class, " : "null, ";
                object = Utils.getNewQNameWithLastLocalPart(((Parameter)object4).getQName());
                String string3 = Utils.getNewQName((QName)object3);
                boolean bl = ((Parameter)object4).isInHeader();
                boolean bl2 = ((Parameter)object4).isOutHeader();
                printWriter.println("        param = new org.apache.axis.description.ParameterDesc(" + (String)object + ", " + modeStrings[((Parameter)object4).getMode()] + ", " + string3 + ", " + (String)object2 + bl + ", " + bl2 + ");");
                QName qName = Utils.getItemQName(((Parameter)object4).getType());
                if (qName != null) {
                    printWriter.println("        param.setItemQName(" + Utils.getNewQName(qName) + ");");
                }
                printWriter.println("        oper.addParameter(param);");
            }
            Parameter parameter = parameters.returnParam;
            if (parameter != null) {
                object4 = Utils.getXSIType(parameter);
                object3 = Utils.getParameterTypeName(parameter);
                object3 = object3 == null ? "" : (String)object3 + ".class";
                printWriter.println("        oper.setReturnType(" + Utils.getNewQName((QName)object4) + ");");
                printWriter.println("        oper.setReturnClass(" + (String)object3 + ");");
                object2 = parameter.getQName();
                if (object2 != null) {
                    printWriter.println("        oper.setReturnQName(" + Utils.getNewQNameWithLastLocalPart((QName)object2) + ");");
                }
                if (parameter.isOutHeader()) {
                    printWriter.println("        oper.setReturnHeader(true);");
                }
                if ((object = Utils.getItemQName(parameter.getType())) != null) {
                    printWriter.println("        param = oper.getReturnParamDesc();");
                    printWriter.println("        param.setItemQName(" + Utils.getNewQName((QName)object) + ");");
                }
            } else {
                printWriter.println("        oper.setReturnType(org.apache.axis.encoding.XMLType.AXIS_VOID);");
            }
            boolean bl = Utils.hasMIME(this.bEntry, bindingOperation);
            object3 = Style.getStyle(string, this.bEntry.getBindingStyle());
            object2 = this.bEntry.getInputBodyType(bindingOperation.getOperation());
            if (object3 == Style.DOCUMENT && this.symbolTable.isWrapped()) {
                object3 = Style.WRAPPED;
            }
            if (!bl) {
                printWriter.println("        oper.setStyle(" + styles.get(object3) + ");");
                printWriter.println("        oper.setUse(" + uses.get(object2) + ");");
            }
            this.writeFaultInfo(printWriter, bindingOperation);
            printWriter.println(string2 + "_operations[" + n + "] = oper;");
            printWriter.println("");
        }
        printWriter.println("    }");
    }

    private HashSet getTypesInPortType(PortType portType) {
        Serializable serializable2;
        HashSet<Serializable> hashSet = new HashSet<Serializable>();
        HashSet hashSet2 = new HashSet();
        List list = portType.getOperations();
        for (int i = 0; i < list.size(); ++i) {
            serializable2 = (Operation)list.get(i);
            hashSet2.addAll(this.getTypesInOperation((Operation)serializable2));
        }
        for (Serializable serializable2 : hashSet2) {
            if (hashSet.contains(serializable2)) continue;
            hashSet.add(serializable2);
            hashSet.addAll(((TypeEntry)serializable2).getNestedTypes(this.symbolTable, true));
        }
        if (this.emitter.isAllWanted()) {
            serializable2 = this.symbolTable.getHashMap();
            for (Vector vector : ((HashMap)serializable2).values()) {
                for (Object e : vector) {
                    TypeEntry typeEntry;
                    if (!(e instanceof DefinedType) || hashSet.contains(typeEntry = (TypeEntry)e)) continue;
                    hashSet.add(typeEntry);
                }
            }
        }
        return hashSet;
    }

    private HashSet getTypesInOperation(Operation operation) {
        Map map;
        HashSet hashSet = new HashSet();
        Vector<TypeEntry> vector = new Vector<TypeEntry>();
        Parameters parameters = this.bEntry.getParameters(operation);
        for (int i = 0; i < parameters.list.size(); ++i) {
            Parameter parameter = (Parameter)parameters.list.get(i);
            vector.add(parameter.getType());
        }
        if (parameters.returnParam != null) {
            vector.add(parameters.returnParam.getType());
        }
        if ((map = operation.getFaults()) != null) {
            for (Fault fault : map.values()) {
                this.partTypes(vector, fault.getMessage().getOrderedParts(null));
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            hashSet.add(vector.get(i));
        }
        return hashSet;
    }

    private void partTypes(Vector vector, Collection collection) {
        for (Part part : collection) {
            QName qName = part.getTypeName();
            if (qName != null) {
                vector.add(this.symbolTable.getType(qName));
                continue;
            }
            qName = part.getElementName();
            if (qName == null) continue;
            vector.add(this.symbolTable.getElement(qName));
        }
    }

    protected void writeFaultInfo(PrintWriter printWriter, BindingOperation bindingOperation) {
        HashMap hashMap = this.bEntry.getFaults();
        ArrayList arrayList = (ArrayList)hashMap.get(bindingOperation);
        if (arrayList == null) {
            return;
        }
        for (FaultInfo faultInfo : arrayList) {
            QName qName = faultInfo.getQName();
            Message message = faultInfo.getMessage();
            if (qName == null) continue;
            String string = Utils.getFullExceptionName(message, this.symbolTable);
            printWriter.println("        oper.addFault(new org.apache.axis.description.FaultDesc(");
            printWriter.println("                      " + Utils.getNewQName(qName) + ",");
            printWriter.println("                      \"" + string + "\",");
            printWriter.println("                      " + Utils.getNewQName(faultInfo.getXMLType()) + ", ");
            printWriter.println("                      " + Utils.isFaultComplex(message, this.symbolTable));
            printWriter.println("                     ));");
        }
    }

    protected void writeSerializationDecls(PrintWriter printWriter, boolean bl, String string) {
        printWriter.println("            java.lang.Class cls;");
        printWriter.println("            javax.xml.namespace.QName qName;");
        printWriter.println("            javax.xml.namespace.QName qName2;");
        printWriter.println("            java.lang.Class beansf = org.apache.axis.encoding.ser.BeanSerializerFactory.class;");
        printWriter.println("            java.lang.Class beandf = org.apache.axis.encoding.ser.BeanDeserializerFactory.class;");
        printWriter.println("            java.lang.Class enumsf = org.apache.axis.encoding.ser.EnumSerializerFactory.class;");
        printWriter.println("            java.lang.Class enumdf = org.apache.axis.encoding.ser.EnumDeserializerFactory.class;");
        printWriter.println("            java.lang.Class arraysf = org.apache.axis.encoding.ser.ArraySerializerFactory.class;");
        printWriter.println("            java.lang.Class arraydf = org.apache.axis.encoding.ser.ArrayDeserializerFactory.class;");
        printWriter.println("            java.lang.Class simplesf = org.apache.axis.encoding.ser.SimpleSerializerFactory.class;");
        printWriter.println("            java.lang.Class simpledf = org.apache.axis.encoding.ser.SimpleDeserializerFactory.class;");
        printWriter.println("            java.lang.Class simplelistsf = org.apache.axis.encoding.ser.SimpleListSerializerFactory.class;");
        printWriter.println("            java.lang.Class simplelistdf = org.apache.axis.encoding.ser.SimpleListDeserializerFactory.class;");
        if (bl) {
            printWriter.println("            java.lang.Class mimesf = org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory.class;");
            printWriter.println("            java.lang.Class mimedf = org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory.class;");
            printWriter.println();
            QName qName = new QName(string, "DataHandler");
            printWriter.println("            qName = new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
            printWriter.println("            cachedSerQNames.add(qName);");
            printWriter.println("            cls = javax.activation.DataHandler.class;");
            printWriter.println("            cachedSerClasses.add(cls);");
            printWriter.println("            cachedSerFactories.add(mimesf);");
            printWriter.println("            cachedDeserFactories.add(mimedf);");
            printWriter.println();
        }
    }

    protected void writeSerializationInit(PrintWriter printWriter, TypeEntry typeEntry) {
        QName qName = typeEntry.getQName();
        printWriter.println("            qName = new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
        printWriter.println("            cachedSerQNames.add(qName);");
        printWriter.println("            cls = " + typeEntry.getName() + ".class;");
        printWriter.println("            cachedSerClasses.add(cls);");
        if (typeEntry.getName().endsWith("[]")) {
            if (SchemaUtils.isListWithItemType(typeEntry.getNode())) {
                printWriter.println("            cachedSerFactories.add(simplelistsf);");
                printWriter.println("            cachedDeserFactories.add(simplelistdf);");
            } else if (typeEntry.getComponentType() != null) {
                QName qName2 = typeEntry.getComponentType();
                QName qName3 = typeEntry.getItemQName();
                printWriter.println("            qName = new javax.xml.namespace.QName(\"" + qName2.getNamespaceURI() + "\", \"" + qName2.getLocalPart() + "\");");
                if (qName3 != null) {
                    printWriter.println("            qName2 = new javax.xml.namespace.QName(\"" + qName3.getNamespaceURI() + "\", \"" + qName3.getLocalPart() + "\");");
                } else {
                    printWriter.println("            qName2 = null;");
                }
                printWriter.println("            cachedSerFactories.add(new org.apache.axis.encoding.ser.ArraySerializerFactory(qName, qName2));");
                printWriter.println("            cachedDeserFactories.add(new org.apache.axis.encoding.ser.ArrayDeserializerFactory());");
            } else {
                printWriter.println("            cachedSerFactories.add(arraysf);");
                printWriter.println("            cachedDeserFactories.add(arraydf);");
            }
        } else if (typeEntry.getNode() != null && Utils.getEnumerationBaseAndValues(typeEntry.getNode(), this.symbolTable) != null) {
            printWriter.println("            cachedSerFactories.add(enumsf);");
            printWriter.println("            cachedDeserFactories.add(enumdf);");
        } else if (typeEntry.isSimpleType()) {
            printWriter.println("            cachedSerFactories.add(simplesf);");
            printWriter.println("            cachedDeserFactories.add(simpledf);");
        } else if (typeEntry.getBaseType() != null) {
            printWriter.println("            cachedSerFactories.add(null);");
            printWriter.println("            cachedDeserFactories.add(simpledf);");
        } else {
            printWriter.println("            cachedSerFactories.add(beansf);");
            printWriter.println("            cachedDeserFactories.add(beandf);");
        }
        printWriter.println();
    }

    protected void writeOperation(PrintWriter printWriter, BindingOperation bindingOperation, Parameters parameters, String string, String string2, boolean bl, int n) {
        Iterator iterator;
        Serializable serializable;
        Object object2;
        Style style;
        this.writeComment(printWriter, bindingOperation.getDocumentationElement(), true);
        printWriter.println(parameters.signature + " {");
        printWriter.println("        if (super.cachedEndpoint == null) {");
        printWriter.println("            throw new org.apache.axis.NoEndPointException();");
        printWriter.println("        }");
        printWriter.println("        org.apache.axis.client.Call _call = createCall();");
        printWriter.println("        _call.setOperation(_operations[" + n + "]);");
        if (string != null) {
            printWriter.println("        _call.setUseSOAPAction(true);");
            printWriter.println("        _call.setSOAPActionURI(\"" + string + "\");");
        }
        boolean bl2 = Utils.hasMIME(this.bEntry, bindingOperation);
        Use use = this.bEntry.getInputBodyType(bindingOperation.getOperation());
        if (use == Use.LITERAL) {
            printWriter.println("        _call.setEncodingStyle(null);");
            printWriter.println("        _call.setProperty(org.apache.axis.client.Call.SEND_TYPE_ATTR, Boolean.FALSE);");
        }
        if (bl2 || use == Use.LITERAL) {
            printWriter.println("        _call.setProperty(org.apache.axis.AxisEngine.PROP_DOMULTIREFS, Boolean.FALSE);");
        }
        if ((style = Style.getStyle(string2, this.bEntry.getBindingStyle())) == Style.DOCUMENT && this.symbolTable.isWrapped()) {
            style = Style.WRAPPED;
        }
        for (Object object2 : this.bEntry.getBinding().getExtensibilityElements()) {
            if (object2 instanceof SOAPBinding) {
                printWriter.println("        _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP11_CONSTANTS);");
                continue;
            }
            if (!(object2 instanceof UnknownExtensibilityElement) || !((QName)(serializable = ((UnknownExtensibilityElement)((Object)(iterator = (UnknownExtensibilityElement)object2))).getElementType())).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !((QName)serializable).getLocalPart().equals("binding")) continue;
            printWriter.println("        _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP12_CONSTANTS);");
        }
        if (style == Style.WRAPPED) {
            object2 = bindingOperation.getOperation().getInput().getMessage().getParts();
            iterator = object2.values().iterator();
            if (iterator.hasNext()) {
                serializable = (Part)object2.values().iterator().next();
                QName qName = serializable.getElementName();
                printWriter.println("        _call.setOperationName(" + Utils.getNewQName(qName) + ");");
            } else {
                log.warn(Messages.getMessage("missingPartsForMessage00", bindingOperation.getOperation().getInput().getMessage().getQName().toString()));
            }
        } else {
            object2 = Utils.getOperationQName(bindingOperation, this.bEntry, this.symbolTable);
            if (object2 != null) {
                printWriter.println("        _call.setOperationName(" + Utils.getNewQName((QName)object2) + ");");
            }
        }
        printWriter.println();
        printWriter.println("        setRequestHeaders(_call);");
        printWriter.println("        setAttachments(_call);");
        if (this.bEntry.isOperationDIME(bindingOperation.getOperation().getName())) {
            printWriter.println("        _call.setProperty(_call.ATTACHMENT_ENCAPSULATION_FORMAT, _call.ATTACHMENT_ENCAPSULATION_FORMAT_DIME);");
        }
        if (bl) {
            printWriter.print("        _call.invokeOneWay(");
        } else {
            printWriter.print(" try {");
            printWriter.print("        java.lang.Object _resp = _call.invoke(");
        }
        printWriter.print("new java.lang.Object[] {");
        this.writeParameters(printWriter, parameters);
        printWriter.println("});");
        printWriter.println();
        if (!bl) {
            this.writeResponseHandling(printWriter, parameters);
        }
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeParameters(PrintWriter printWriter, Parameters parameters) {
        boolean bl = false;
        for (int i = 0; i < parameters.list.size(); ++i) {
            Parameter parameter = (Parameter)parameters.list.get(i);
            if (parameter.getMode() == 2) continue;
            if (bl) {
                printWriter.print(", ");
            } else {
                bl = true;
            }
            String string = Utils.xmlNameToJava(parameter.getName());
            if (parameter.getMode() != 1) {
                string = string + ".value";
            }
            if (parameter.getMIMEInfo() == null && !parameter.isOmittable()) {
                string = Utils.wrapPrimitiveType(parameter.getType(), string);
            }
            printWriter.print(string);
        }
    }

    protected void writeResponseHandling(PrintWriter printWriter, Parameters parameters) {
        Object object;
        Object object2;
        printWriter.println("        if (_resp instanceof java.rmi.RemoteException) {");
        printWriter.println("            throw (java.rmi.RemoteException)_resp;");
        printWriter.println("        }");
        int n = parameters.outputs + parameters.inouts;
        if (n > 0) {
            String string;
            int n2;
            printWriter.println("        else {");
            printWriter.println("            extractAttachments(_call);");
            if (n == 1) {
                if (parameters.returnParam != null) {
                    this.writeOutputAssign(printWriter, "return ", parameters.returnParam, "_resp");
                } else {
                    n2 = 0;
                    object2 = (Parameter)parameters.list.get(n2);
                    while (((Parameter)object2).getMode() == 1) {
                        object2 = (Parameter)parameters.list.get(++n2);
                    }
                    string = Utils.xmlNameToJava(((Parameter)object2).getName());
                    object = Utils.getNewQNameWithLastLocalPart(((Parameter)object2).getQName());
                    printWriter.println("            java.util.Map _output;");
                    printWriter.println("            _output = _call.getOutputParams();");
                    this.writeOutputAssign(printWriter, string + ".value = ", (Parameter)object2, "_output.get(" + (String)object + ")");
                }
            } else {
                printWriter.println("            java.util.Map _output;");
                printWriter.println("            _output = _call.getOutputParams();");
                for (n2 = 0; n2 < parameters.list.size(); ++n2) {
                    object2 = (Parameter)parameters.list.get(n2);
                    string = Utils.xmlNameToJava(((Parameter)object2).getName());
                    object = Utils.getNewQNameWithLastLocalPart(((Parameter)object2).getQName());
                    if (((Parameter)object2).getMode() == 1) continue;
                    this.writeOutputAssign(printWriter, string + ".value = ", (Parameter)object2, "_output.get(" + (String)object + ")");
                }
                if (parameters.returnParam != null) {
                    this.writeOutputAssign(printWriter, "return ", parameters.returnParam, "_resp");
                }
            }
            printWriter.println("        }");
        } else {
            printWriter.println("        extractAttachments(_call);");
        }
        Map map = parameters.faults;
        object2 = new ArrayList();
        int n3 = parameters.signature.indexOf("throws");
        if (n3 != -1) {
            object = StringUtils.split(parameters.signature.substring(n3 + 6), ',');
            for (int i = 0; i < ((String[])object).length; ++i) {
                object2.add(((String)object[i]).trim());
            }
        }
        printWriter.println("  } catch (org.apache.axis.AxisFault axisFaultException) {");
        if (map != null && map.size() > 0) {
            printWriter.println("    if (axisFaultException.detail != null) {");
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                printWriter.println("        if (axisFaultException.detail instanceof " + string + ") {");
                printWriter.println("              throw (" + string + ") axisFaultException.detail;");
                printWriter.println("         }");
            }
            printWriter.println("   }");
        }
        printWriter.println("  throw axisFaultException;");
        printWriter.println("}");
    }

    protected void writeOutputAssign(PrintWriter printWriter, String string, Parameter parameter, String string2) {
        TypeEntry typeEntry = parameter.getType();
        if (typeEntry != null && typeEntry.getName() != null) {
            String string3 = typeEntry.getName();
            if (parameter.isOmittable() && parameter.getType().getDimensions().equals("") || parameter.getType().getUnderlTypeNillable()) {
                string3 = Utils.getWrapperType(typeEntry);
            }
            printWriter.println("            try {");
            printWriter.println("                " + string + Utils.getResponseString(parameter, string2));
            printWriter.println("            } catch (java.lang.Exception _exception) {");
            printWriter.println("                " + string + Utils.getResponseString(parameter, "org.apache.axis.utils.JavaUtils.convert(" + string2 + ", " + string3 + ".class)"));
            printWriter.println("            }");
        } else {
            printWriter.println("              " + string + Utils.getResponseString(parameter, string2));
        }
    }

    static {
        styles.put(Style.DOCUMENT, "org.apache.axis.constants.Style.DOCUMENT");
        styles.put(Style.RPC, "org.apache.axis.constants.Style.RPC");
        styles.put(Style.MESSAGE, "org.apache.axis.constants.Style.MESSAGE");
        styles.put(Style.WRAPPED, "org.apache.axis.constants.Style.WRAPPED");
        uses.put(Use.ENCODED, "org.apache.axis.constants.Use.ENCODED");
        uses.put(Use.LITERAL, "org.apache.axis.constants.Use.LITERAL");
        OPERDESC_PER_BLOCK = 10;
    }
}

