/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GenericBridge;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GVTBuilder
implements SVGConstants {
    public GraphicsNode build(BridgeContext bridgeContext, Document document) {
        bridgeContext.setDocument(document);
        bridgeContext.initializeDocument(document);
        bridgeContext.setGVTBuilder(this);
        RootGraphicsNode rootGraphicsNode = new RootGraphicsNode();
        Element element = document.getDocumentElement();
        GraphicsNode graphicsNode = null;
        try {
            Bridge bridge = bridgeContext.getBridge(element);
            if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
                return null;
            }
            GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
            graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
            if (graphicsNode == null) {
                return null;
            }
            graphicsNode.setDataGenomeNum(this.getDataGenomeNumAttribute(element));
            graphicsNode.setDataXPointer(this.getDataXPointerAttribute(element));
            graphicsNode.setDataVisibility(this.getDataVisibilityAttribute(element));
            rootGraphicsNode.getChildren().add(graphicsNode);
            this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
            graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
        }
        catch (BridgeException bridgeException) {
            bridgeException.setGraphicsNode(rootGraphicsNode);
            Element element2 = bridgeException.getElement();
            bridgeException.setLineNumber(bridgeContext.getDocumentLoader().getLineNumber(element2));
            throw bridgeException;
        }
        if (bridgeContext.isInteractive()) {
            bridgeContext.addUIEventListeners(document);
            BridgeEventSupport.addGVTListener(bridgeContext, document);
        }
        if (bridgeContext.isDynamic()) {
            bridgeContext.addDOMListeners();
        }
        return rootGraphicsNode;
    }

    public GraphicsNode build(BridgeContext bridgeContext, Element element) {
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(bridgeContext, element);
            return null;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            return null;
        }
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
        if (!graphicsNodeBridge.getDisplay(element)) {
            return null;
        }
        GraphicsNode graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
        if (graphicsNode != null) {
            if (graphicsNodeBridge.isComposite()) {
                this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
            } else {
                this.handleGenericBridges(bridgeContext, element);
            }
            graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
        }
        if (bridgeContext.isDynamic()) {
            // empty if block
        }
        return graphicsNode;
    }

    protected void buildComposite(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.buildGraphicsNode(bridgeContext, (Element)node, compositeGraphicsNode);
        }
    }

    protected void buildGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        if (HaltingThread.hasBeenHalted()) {
            throw new InterruptedBridgeException();
        }
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(bridgeContext, element);
            return;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            return;
        }
        if (!CSSUtilities.convertDisplay(element)) {
            return;
        }
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
        try {
            GraphicsNode graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
            if (graphicsNode != null) {
                compositeGraphicsNode.getChildren().add(graphicsNode);
                if (graphicsNodeBridge.isComposite()) {
                    this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
                } else {
                    this.handleGenericBridges(bridgeContext, element);
                }
                graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
                graphicsNode.setDataGenomeNum(this.getDataGenomeNumAttribute(element));
                graphicsNode.setDataXPointer(this.getDataXPointerAttribute(element));
                graphicsNode.setDataVisibility(this.getDataVisibilityAttribute(element));
            }
        }
        catch (BridgeException bridgeException) {
            GraphicsNode graphicsNode = bridgeException.getGraphicsNode();
            if (graphicsNode != null) {
                compositeGraphicsNode.getChildren().add(graphicsNode);
                graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
                bridgeException.setGraphicsNode(null);
            }
            throw bridgeException;
        }
    }

    protected void handleGenericBridges(BridgeContext bridgeContext, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            Bridge bridge;
            if (!(node instanceof Element) || !((bridge = bridgeContext.getBridge(element2 = (Element)node)) instanceof GenericBridge)) continue;
            ((GenericBridge)bridge).handleElement(bridgeContext, element2);
        }
    }

    private int getDataGenomeNumAttribute(Element element) {
        String string = "";
        if (element != null && (string = element.getAttributeNS("http://bluejay.org", "genomenum")) != null && !"".equals(string)) {
            try {
                int n = Integer.parseInt(string);
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1;
    }

    private String getDataXPointerAttribute(Element element) {
        String string = "";
        if (element != null) {
            string = element.getAttributeNS("http://bluejay.org", "xptr");
        }
        return string;
    }

    private int getDataVisibilityAttribute(Element element) {
        String string;
        if (element != null && (string = element.getAttributeNS("http://bluejay.org", "viz")) != null && !"".equals(string)) {
            try {
                int n = Integer.valueOf(string);
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 112;
    }
}

