/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;

public abstract class MagicNumberRegistryEntry
extends AbstractRegistryEntry
implements StreamRegistryEntry {
    public static final float PRIORITY = 1000.0f;
    MagicNumber[] magicNumbers;

    public MagicNumberRegistryEntry(String string, String string2, String string3, int n, byte[] byArray) {
        super(string, 1000.0f, string2, string3);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(n, byArray);
    }

    public MagicNumberRegistryEntry(String string, String string2, String string3, MagicNumber[] magicNumberArray) {
        super(string, 1000.0f, string2, string3);
        this.magicNumbers = magicNumberArray;
    }

    public MagicNumberRegistryEntry(String string, String[] stringArray, String[] stringArray2, int n, byte[] byArray) {
        super(string, 1000.0f, stringArray, stringArray2);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(n, byArray);
    }

    public MagicNumberRegistryEntry(String string, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray) {
        super(string, 1000.0f, stringArray, stringArray2);
        this.magicNumbers = magicNumberArray;
    }

    public MagicNumberRegistryEntry(String string, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray, float f) {
        super(string, f, stringArray, stringArray2);
        this.magicNumbers = magicNumberArray;
    }

    public int getReadlimit() {
        int n = 0;
        for (int i = 0; i < this.magicNumbers.length; ++i) {
            int n2 = this.magicNumbers[i].getReadlimit();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public boolean isCompatibleStream(InputStream inputStream) throws StreamCorruptedException {
        for (int i = 0; i < this.magicNumbers.length; ++i) {
            if (!this.magicNumbers[i].isMatch(inputStream)) continue;
            return true;
        }
        return false;
    }

    public static class MagicNumber {
        int offset;
        byte[] magicNumber;
        byte[] buffer;

        public MagicNumber(int n, byte[] byArray) {
            this.offset = n;
            this.magicNumber = (byte[])byArray.clone();
            this.buffer = new byte[byArray.length];
        }

        int getReadlimit() {
            return this.offset + this.magicNumber.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isMatch(InputStream inputStream) throws StreamCorruptedException {
            inputStream.mark(this.getReadlimit());
            try {
                int n;
                int n2;
                for (n = 0; n < this.offset; n += n2) {
                    n2 = (int)inputStream.skip(this.offset - n);
                    if (n2 != -1) continue;
                    boolean bl = false;
                    return bl;
                }
                for (n = 0; n < this.buffer.length; n += n2) {
                    n2 = inputStream.read(this.buffer, n, this.buffer.length - n);
                    if (n2 != -1) continue;
                    boolean bl = false;
                    return bl;
                }
                for (n2 = 0; n2 < this.magicNumber.length; ++n2) {
                    if (this.magicNumber[n2] == this.buffer[n2]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    throw new StreamCorruptedException(iOException.getMessage());
                }
            }
            return true;
        }
    }
}

