/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Collection;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.util.HaltingThread;

public class DynamicRenderer
extends StaticRenderer {
    static final int COPY_OVERHEAD = 1000;
    static final int COPY_LINE_OVERHEAD = 10;
    RectListManager damagedAreas;

    public DynamicRenderer() {
    }

    public DynamicRenderer(RenderingHints renderingHints, AffineTransform affineTransform) {
        super(renderingHints, affineTransform);
    }

    protected CachableRed setupCache(CachableRed cachableRed) {
        return cachableRed;
    }

    public void flush(Rectangle rectangle) {
    }

    public void flush(Collection collection) {
    }

    protected void updateWorkingBuffers() {
        if (this.rootFilter == null) {
            this.rootFilter = this.rootGN.getGraphicsNodeRable(true);
            this.rootCR = null;
        }
        this.rootCR = this.renderGNR();
        if (this.rootCR == null) {
            this.workingRaster = null;
            this.workingOffScreen = null;
            this.workingBaseRaster = null;
            this.currentOffScreen = null;
            this.currentBaseRaster = null;
            this.currentRaster = null;
            return;
        }
        SampleModel sampleModel = this.rootCR.getSampleModel();
        int n = this.offScreenWidth;
        int n2 = this.offScreenHeight;
        if (this.workingBaseRaster == null || this.workingBaseRaster.getWidth() < n || this.workingBaseRaster.getHeight() < n2) {
            sampleModel = sampleModel.createCompatibleSampleModel(n, n2);
            this.workingBaseRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
            this.workingRaster = this.workingBaseRaster.createWritableChild(0, 0, n, n2, 0, 0, null);
            this.workingOffScreen = new BufferedImage(this.rootCR.getColorModel(), this.workingRaster, this.rootCR.getColorModel().isAlphaPremultiplied(), null);
        }
        if (!this.isDoubleBuffered) {
            this.currentOffScreen = this.workingOffScreen;
            this.currentBaseRaster = this.workingBaseRaster;
            this.currentRaster = this.workingRaster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(RectListManager rectListManager) {
        if (rectListManager == null) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.rootCR == null || this.workingBaseRaster == null) {
            return;
        }
        CachableRed cachableRed = this.rootCR;
        WritableRaster writableRaster = this.workingBaseRaster;
        WritableRaster writableRaster2 = this.workingRaster;
        Rectangle rectangle = this.rootCR.getBounds();
        Rectangle rectangle2 = this.workingRaster.getBounds();
        if (rectangle2.x < rectangle.x || rectangle2.y < rectangle.y || rectangle2.x + rectangle2.width > rectangle.x + rectangle.width || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            cachableRed = new PadRed(cachableRed, rectangle2, PadMode.ZERO_PAD, null);
        }
        boolean bl = false;
        Rectangle rectangle3 = writableRaster2.getBounds();
        Object object = writableRaster;
        synchronized (object) {
            if (bl) {
                cachableRed.copyData(writableRaster2);
            } else {
                WritableRaster writableRaster3;
                Graphics2D graphics2D = null;
                if (this.isDoubleBuffered && this.currentRaster != null && this.damagedAreas != null) {
                    this.damagedAreas.subtract(rectListManager, 1000, 10);
                    this.damagedAreas.mergeRects(1000, 10);
                    for (Rectangle rectangle4 : this.damagedAreas) {
                        if (!rectangle3.intersects(rectangle4)) continue;
                        rectangle4 = rectangle3.intersection(rectangle4);
                        writableRaster3 = this.currentRaster.createWritableChild(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, rectangle4.x, rectangle4.y, null);
                        GraphicsUtil.copyData(writableRaster3, writableRaster2);
                        if (graphics2D == null) continue;
                        graphics2D.setPaint(new Color(0, 0, 255, 50));
                        graphics2D.fill(rectangle4);
                        graphics2D.setPaint(new Color(0, 0, 0, 50));
                        graphics2D.draw(rectangle4);
                    }
                }
                for (Rectangle rectangle4 : rectListManager) {
                    if (!rectangle3.intersects(rectangle4)) continue;
                    rectangle4 = rectangle3.intersection(rectangle4);
                    writableRaster3 = writableRaster2.createWritableChild(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, rectangle4.x, rectangle4.y, null);
                    cachableRed.copyData(writableRaster3);
                    if (graphics2D == null) continue;
                    graphics2D.setPaint(new Color(255, 0, 0, 50));
                    graphics2D.fill(rectangle4);
                    graphics2D.setPaint(new Color(0, 0, 0, 50));
                    graphics2D.draw(rectangle4);
                }
            }
        }
        if (HaltingThread.hasBeenHalted()) {
            return;
        }
        object = this.workingOffScreen;
        this.workingBaseRaster = this.currentBaseRaster;
        this.workingRaster = this.currentRaster;
        this.workingOffScreen = this.currentOffScreen;
        this.currentRaster = writableRaster2;
        this.currentBaseRaster = writableRaster;
        this.currentOffScreen = object;
        this.damagedAreas = rectListManager;
    }
}

