/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.ExceptionConstants;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.LoadClass;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

public class ANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower,
StackProducer {
    ANEWARRAY() {
    }

    public ANEWARRAY(int n) {
        super((short)189, n);
    }

    public Class[] getExceptions() {
        Class[] classArray = new Class[1 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, classArray, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        classArray[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        return classArray;
    }

    public void accept(Visitor visitor) {
        visitor.visitLoadClass(this);
        visitor.visitAllocationInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitANEWARRAY(this);
    }

    public ObjectType getLoadClassType(ConstantPoolGen constantPoolGen) {
        Type type = this.getType(constantPoolGen);
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getBasicType();
        }
        return type instanceof ObjectType ? (ObjectType)type : null;
    }
}

