/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELifier;

class BCELFactory
extends EmptyVisitor {
    private MethodGen _mg;
    private PrintWriter _out;
    private ConstantPoolGen _cp;
    private HashMap branch_map = new HashMap();
    private ArrayList branches = new ArrayList();

    BCELFactory(MethodGen methodGen, PrintWriter printWriter) {
        this._mg = methodGen;
        this._cp = methodGen.getConstantPool();
        this._out = printWriter;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle instructionHandle = this._mg.getInstructionList().getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                Instruction instruction = instructionHandle.getInstruction();
                if (instruction instanceof BranchInstruction) {
                    this.branch_map.put(instruction, instructionHandle);
                }
                if (instructionHandle.hasTargeters()) {
                    if (instruction instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + instructionHandle.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + instructionHandle.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(instruction)) continue;
                instruction.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction instruction) {
        short s = instruction.getOpcode();
        if (InstructionConstants.INSTRUCTIONS[s] != null && !(instruction instanceof ConstantPushInstruction) && !(instruction instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConstants." + instruction.getName().toUpperCase() + ");");
            return true;
        }
        return false;
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction localVariableInstruction) {
        short s = localVariableInstruction.getOpcode();
        Type type = localVariableInstruction.getType(this._cp);
        if (s == 132) {
            this._out.println("il.append(new IINC(" + localVariableInstruction.getIndex() + ", " + ((IINC)localVariableInstruction).getIncrement() + "));");
        } else {
            String string = s < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + string + "(" + BCELifier.printType(type) + ", " + localVariableInstruction.getIndex() + "));");
        }
    }

    public void visitArrayInstruction(ArrayInstruction arrayInstruction) {
        short s = arrayInstruction.getOpcode();
        Type type = arrayInstruction.getType(this._cp);
        String string = s < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + string + "(" + BCELifier.printType(type) + "));");
    }

    public void visitFieldInstruction(FieldInstruction fieldInstruction) {
        short s = fieldInstruction.getOpcode();
        String string = fieldInstruction.getClassName(this._cp);
        String string2 = fieldInstruction.getFieldName(this._cp);
        Type type = fieldInstruction.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + string + "\", \"" + string2 + "\", " + BCELifier.printType(type) + ", " + "Constants." + Constants.OPCODE_NAMES[s].toUpperCase() + "));");
    }

    public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
        short s = invokeInstruction.getOpcode();
        String string = invokeInstruction.getClassName(this._cp);
        String string2 = invokeInstruction.getMethodName(this._cp);
        Type type = invokeInstruction.getReturnType(this._cp);
        Type[] typeArray = invokeInstruction.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + string + "\", \"" + string2 + "\", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(typeArray) + ", " + "Constants." + Constants.OPCODE_NAMES[s].toUpperCase() + "));");
    }

    public void visitAllocationInstruction(AllocationInstruction allocationInstruction) {
        Type type = allocationInstruction instanceof CPInstruction ? ((CPInstruction)((Object)allocationInstruction)).getType(this._cp) : ((NEWARRAY)allocationInstruction).getType();
        short s = ((Instruction)((Object)allocationInstruction)).getOpcode();
        short s2 = 1;
        switch (s) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type).getClassName() + "\"));");
                break;
            }
            case 197: {
                s2 = ((MULTIANEWARRAY)allocationInstruction).getDimensions();
            }
            case 188: 
            case 189: {
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type) + ", (short) " + s2 + "));");
                break;
            }
            default: {
                throw new RuntimeException("Oops: " + s);
            }
        }
    }

    private void createConstant(Object object) {
        String string = object.toString();
        if (object instanceof String) {
            string = '\"' + Utility.convertString(object.toString()) + '\"';
        } else if (object instanceof Character) {
            string = "(char)0x" + Integer.toHexString(((Character)object).charValue());
        }
        this._out.println("il.append(new PUSH(_cp, " + string + "));");
    }

    public void visitLDC(LDC lDC) {
        this.createConstant(lDC.getValue(this._cp));
    }

    public void visitLDC2_W(LDC2_W lDC2_W) {
        this.createConstant(lDC2_W.getValue(this._cp));
    }

    public void visitConstantPushInstruction(ConstantPushInstruction constantPushInstruction) {
        this.createConstant(constantPushInstruction.getValue());
    }

    public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
        Type type = iNSTANCEOF.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type) + ")));");
    }

    public void visitCHECKCAST(CHECKCAST cHECKCAST) {
        Type type = cHECKCAST.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type) + "));");
    }

    public void visitReturnInstruction(ReturnInstruction returnInstruction) {
        Type type = returnInstruction.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type) + "));");
    }

    public void visitBranchInstruction(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = (BranchHandle)this.branch_map.get(branchInstruction);
        int n = branchHandle.getPosition();
        String string = branchInstruction.getName() + "_" + n;
        if (branchInstruction instanceof Select) {
            int n2;
            Select select = (Select)branchInstruction;
            this.branches.add(branchInstruction);
            StringBuffer stringBuffer = new StringBuffer("new int[] { ");
            int[] nArray = select.getMatchs();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                stringBuffer.append(nArray[n2]);
                if (n2 >= nArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            this._out.print("    Select " + string + " = new " + branchInstruction.getName().toUpperCase() + "(" + stringBuffer + ", new InstructionHandle[] { ");
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this._out.print("null");
                if (n2 >= nArray.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(");");
        } else {
            String string2;
            int n3 = branchHandle.getTarget().getPosition();
            if (n > n3) {
                string2 = "ih_" + n3;
            } else {
                this.branches.add(branchInstruction);
                string2 = "null";
            }
            this._out.println("    BranchInstruction " + string + " = _factory.createBranchInstruction(" + "Constants." + branchInstruction.getName().toUpperCase() + ", " + string2 + ");");
        }
        if (branchHandle.hasTargeters()) {
            this._out.println("    ih_" + n + " = il.append(" + string + ");");
        } else {
            this._out.println("    il.append(" + string + ");");
        }
    }

    public void visitRET(RET rET) {
        this._out.println("il.append(new RET(" + rET.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (BranchInstruction branchInstruction : this.branches) {
            BranchHandle branchHandle = (BranchHandle)this.branch_map.get(branchInstruction);
            int n = branchHandle.getPosition();
            String string = branchInstruction.getName() + "_" + n;
            int n2 = branchHandle.getTarget().getPosition();
            this._out.println("    " + string + ".setTarget(ih_" + n2 + ");");
            if (!(branchInstruction instanceof Select)) continue;
            InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
            for (int i = 0; i < instructionHandleArray.length; ++i) {
                n2 = instructionHandleArray[i].getPosition();
                this._out.println("    " + string + ".setTarget(" + i + ", ih_" + n2 + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray = this._mg.getExceptionHandlers();
        for (int i = 0; i < codeExceptionGenArray.length; ++i) {
            CodeExceptionGen codeExceptionGen = codeExceptionGenArray[i];
            String string = codeExceptionGen.getCatchType() == null ? "null" : BCELifier.printType(codeExceptionGen.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + codeExceptionGen.getStartPC().getPosition() + ", " + "ih_" + codeExceptionGen.getEndPC().getPosition() + ", " + "ih_" + codeExceptionGen.getHandlerPC().getPosition() + ", " + string + ");");
        }
    }
}

