/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.Repository;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.statics.Pass1Verifier;
import org.apache.bcel.verifier.statics.Pass2Verifier;
import org.apache.bcel.verifier.statics.Pass3aVerifier;
import org.apache.bcel.verifier.structurals.Pass3bVerifier;

public class Verifier {
    private final String classname;
    private Pass1Verifier p1v;
    private Pass2Verifier p2v;
    private HashMap p3avs = new HashMap();
    private HashMap p3bvs = new HashMap();

    public VerificationResult doPass1() {
        if (this.p1v == null) {
            this.p1v = new Pass1Verifier(this);
        }
        return this.p1v.verify();
    }

    public VerificationResult doPass2() {
        if (this.p2v == null) {
            this.p2v = new Pass2Verifier(this);
        }
        return this.p2v.verify();
    }

    public VerificationResult doPass3a(int n) {
        String string = Integer.toString(n);
        Pass3aVerifier pass3aVerifier = (Pass3aVerifier)this.p3avs.get(string);
        if (this.p3avs.get(string) == null) {
            pass3aVerifier = new Pass3aVerifier(this, n);
            this.p3avs.put(string, pass3aVerifier);
        }
        return pass3aVerifier.verify();
    }

    public VerificationResult doPass3b(int n) {
        String string = Integer.toString(n);
        Pass3bVerifier pass3bVerifier = (Pass3bVerifier)this.p3bvs.get(string);
        if (this.p3bvs.get(string) == null) {
            pass3bVerifier = new Pass3bVerifier(this, n);
            this.p3bvs.put(string, pass3bVerifier);
        }
        return pass3bVerifier.verify();
    }

    Verifier(String string) {
        this.classname = string;
        this.flush();
    }

    public final String getClassName() {
        return this.classname;
    }

    public void flush() {
        this.p1v = null;
        this.p2v = null;
        this.p3avs.clear();
        this.p3bvs.clear();
    }

    public String[] getMessages() {
        int n;
        Object object3;
        int n2;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.p1v != null) {
            object2 = this.p1v.getMessages();
            for (n2 = 0; n2 < ((String[])object2).length; ++n2) {
                arrayList.add("Pass 1: " + (String)object2[n2]);
            }
        }
        if (this.p2v != null) {
            object2 = this.p2v.getMessages();
            for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                arrayList.add("Pass 2: " + (String)object2[n2]);
            }
        }
        for (Pass3aVerifier pass3aVerifier : this.p3avs.values()) {
            object3 = pass3aVerifier.getMessages();
            int n3 = pass3aVerifier.getMethodNo();
            for (n = 0; n < ((Object)object3).length; ++n) {
                arrayList.add("Pass 3a, method " + n3 + " ('" + Repository.lookupClass(this.classname).getMethods()[n3] + "'): " + (String)object3[n]);
            }
        }
        for (Object object3 : this.p3bvs.values()) {
            String[] stringArray = ((PassVerifier)object3).getMessages();
            n = ((Pass3bVerifier)object3).getMethodNo();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add("Pass 3b, method " + n + " ('" + Repository.lookupClass(this.classname).getMethods()[n] + "'): " + stringArray[i]);
            }
        }
        object3 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object3[i] = (String)arrayList.get(i);
        }
        return object3;
    }

    public static void main(String[] stringArray) {
        System.out.println("JustIce by Enver Haase, (C) 2001-2002.\n<http://bcel.sourceforge.net>\n<http://jakarta.apache.org/bcel>\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2;
            int n2;
            if (stringArray[i].endsWith(".class") && (n2 = stringArray[i].lastIndexOf(".class")) != -1) {
                stringArray[i] = stringArray[i].substring(0, n2);
            }
            stringArray[i] = stringArray[i].replace('/', '.');
            System.out.println("Now verifying: " + stringArray[i] + "\n");
            Verifier verifier = VerifierFactory.getVerifier(stringArray[i]);
            VerificationResult verificationResult = verifier.doPass1();
            System.out.println("Pass 1:\n" + verificationResult);
            verificationResult = verifier.doPass2();
            System.out.println("Pass 2:\n" + verificationResult);
            if (verificationResult == VerificationResult.VR_OK) {
                stringArray2 = Repository.lookupClass(stringArray[i]);
                for (n = 0; n < stringArray2.getMethods().length; ++n) {
                    verificationResult = verifier.doPass3a(n);
                    System.out.println("Pass 3a, method number " + n + " ['" + stringArray2.getMethods()[n] + "']:\n" + verificationResult);
                    verificationResult = verifier.doPass3b(n);
                    System.out.println("Pass 3b, method number " + n + " ['" + stringArray2.getMethods()[n] + "']:\n" + verificationResult);
                }
            }
            System.out.println("Warnings:");
            stringArray2 = verifier.getMessages();
            if (stringArray2.length == 0) {
                System.out.println("<none>");
            }
            for (n = 0; n < stringArray2.length; ++n) {
                System.out.println(stringArray2[n]);
            }
            System.out.println("\n");
            verifier.flush();
            Repository.clearCache();
            System.gc();
        }
    }
}

