/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.bcel.Constants;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.ClassConstraintException;
import org.apache.bcel.verifier.exc.LocalVariableInfoInconsistentException;
import org.apache.bcel.verifier.statics.LocalVariablesInfo;
import org.apache.bcel.verifier.statics.StringRepresentation;

public final class Pass2Verifier
extends PassVerifier
implements Constants {
    private LocalVariablesInfo[] localVariablesInfos;
    private Verifier myOwner;

    public Pass2Verifier(Verifier verifier) {
        this.myOwner = verifier;
    }

    public LocalVariablesInfo getLocalVariablesInfo(int n) {
        if (this.verify() != VerificationResult.VR_OK) {
            return null;
        }
        if (n < 0 || n >= this.localVariablesInfos.length) {
            throw new AssertionViolatedException("Method number out of range.");
        }
        return this.localVariablesInfos[n];
    }

    public VerificationResult do_verify() {
        VerificationResult verificationResult = this.myOwner.doPass1();
        if (verificationResult.equals(VerificationResult.VR_OK)) {
            this.localVariablesInfos = new LocalVariablesInfo[Repository.lookupClass(this.myOwner.getClassName()).getMethods().length];
            VerificationResult verificationResult2 = VerificationResult.VR_OK;
            try {
                this.constant_pool_entries_satisfy_static_constraints();
                this.field_and_method_refs_are_valid();
                this.every_class_has_an_accessible_superclass();
                this.final_methods_are_not_overridden();
            }
            catch (ClassConstraintException classConstraintException) {
                verificationResult2 = new VerificationResult(2, classConstraintException.getMessage());
            }
            return verificationResult2;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void every_class_has_an_accessible_superclass() {
        HashSet<String> hashSet = new HashSet<String>();
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        int n = -1;
        while (n != 0) {
            n = javaClass.getSuperclassNameIndex();
            if (n == 0) {
                if (javaClass == Repository.lookupClass(Type.OBJECT.getClassName())) continue;
                throw new ClassConstraintException("Superclass of '" + javaClass.getClassName() + "' missing but not " + Type.OBJECT.getClassName() + " itself!");
            }
            String string = javaClass.getSuperclassName();
            if (!hashSet.add(string)) {
                throw new ClassConstraintException("Circular superclass hierarchy detected.");
            }
            Verifier verifier = VerifierFactory.getVerifier(string);
            VerificationResult verificationResult = verifier.doPass1();
            if (verificationResult != VerificationResult.VR_OK) {
                throw new ClassConstraintException("Could not load in ancestor class '" + string + "'.");
            }
            javaClass = Repository.lookupClass(string);
            if (!javaClass.isFinal()) continue;
            throw new ClassConstraintException("Ancestor class '" + string + "' has the FINAL access modifier and must therefore not be subclassed.");
        }
    }

    private void final_methods_are_not_overridden() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        int n = -1;
        while (n != 0) {
            n = javaClass.getSuperclassNameIndex();
            Method[] methodArray = javaClass.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                String string = methodArray[i].getName() + methodArray[i].getSignature();
                if (hashMap.containsKey(string)) {
                    if (methodArray[i].isFinal()) {
                        throw new ClassConstraintException("Method '" + string + "' in class '" + hashMap.get(string) + "' overrides the final (not-overridable) definition in class '" + javaClass.getClassName() + "'.");
                    }
                    if (methodArray[i].isStatic()) continue;
                    hashMap.put(string, javaClass.getClassName());
                    continue;
                }
                if (methodArray[i].isStatic()) continue;
                hashMap.put(string, javaClass.getClassName());
            }
            javaClass = Repository.lookupClass(javaClass.getSuperclassName());
        }
    }

    private void constant_pool_entries_satisfy_static_constraints() {
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        new CPESSC_Visitor(javaClass);
    }

    private void field_and_method_refs_are_valid() {
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        DescendingVisitor descendingVisitor = new DescendingVisitor(javaClass, new FAMRAV_Visitor(javaClass));
        descendingVisitor.visit();
    }

    private static final boolean validClassName(String string) {
        return true;
    }

    private static boolean validMethodName(String string, boolean bl) {
        if (Pass2Verifier.validJavaLangMethodName(string)) {
            return true;
        }
        if (bl) {
            return string.equals("<init>") || string.equals("<clinit>");
        }
        return string.equals("<init>");
    }

    private static boolean validClassMethodName(String string) {
        return Pass2Verifier.validMethodName(string, false);
    }

    private static boolean validJavaLangMethodName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean validInterfaceMethodName(String string) {
        if (string.startsWith("<")) {
            return false;
        }
        return Pass2Verifier.validJavaLangMethodName(string);
    }

    private static boolean validJavaIdentifier(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean validFieldName(String string) {
        return Pass2Verifier.validJavaIdentifier(string);
    }

    private static String tostring(Node node) {
        return new StringRepresentation(node).toString();
    }

    private class InnerClassDetector
    extends EmptyVisitor {
        private boolean hasInnerClass = false;
        private JavaClass jc;
        private ConstantPool cp;

        private InnerClassDetector() {
        }

        public InnerClassDetector(JavaClass javaClass) {
            this.jc = javaClass;
            this.cp = this.jc.getConstantPool();
            new DescendingVisitor(this.jc, this).visit();
        }

        public boolean innerClassReferenced() {
            return this.hasInnerClass;
        }

        public void visitConstantClass(ConstantClass constantClass) {
            String string;
            Constant constant = this.cp.getConstant(constantClass.getNameIndex());
            if (constant instanceof ConstantUtf8 && (string = ((ConstantUtf8)constant).getBytes()).startsWith(this.jc.getClassName().replace('.', '/') + "$")) {
                this.hasInnerClass = true;
            }
        }
    }

    private class FAMRAV_Visitor
    extends EmptyVisitor
    implements Visitor {
        private final ConstantPool cp;

        private FAMRAV_Visitor(JavaClass javaClass) {
            this.cp = javaClass.getConstantPool();
        }

        public void visitConstantFieldref(ConstantFieldref constantFieldref) {
            if (constantFieldref.getTag() != 9) {
                throw new ClassConstraintException("ConstantFieldref '" + Pass2Verifier.tostring(constantFieldref) + "' has wrong tag!");
            }
            int n = constantFieldref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.validFieldName(string)) {
                throw new ClassConstraintException("Invalid field name '" + string + "' referenced by '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
            int n2 = constantFieldref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n2);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassName(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type.getType(string3);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
        }

        public void visitConstantMethodref(ConstantMethodref constantMethodref) {
            if (constantMethodref.getTag() != 10) {
                throw new ClassConstraintException("ConstantMethodref '" + Pass2Verifier.tostring(constantMethodref) + "' has wrong tag!");
            }
            int n = constantMethodref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassMethodName(string)) {
                throw new ClassConstraintException("Invalid (non-interface) method name '" + string + "' referenced by '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
            int n2 = constantMethodref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n2);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassName(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getReturnType(string3);
                if (string.equals("<init>") && type != Type.VOID) {
                    throw new ClassConstraintException("Instance initialization method must have VOID return type.");
                }
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
        }

        public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
            if (constantInterfaceMethodref.getTag() != 11) {
                throw new ClassConstraintException("ConstantInterfaceMethodref '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "' has wrong tag!");
            }
            int n = constantInterfaceMethodref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.validInterfaceMethodName(string)) {
                throw new ClassConstraintException("Invalid (interface) method name '" + string + "' referenced by '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
            int n2 = constantInterfaceMethodref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n2);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassName(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getReturnType(string3);
                if (string.equals("<clinit>") && type != Type.VOID) {
                    Pass2Verifier.this.addMessage("Class or interface initialization method '<clinit>' usually has VOID return type instead of '" + type + "'. Note this is really not a requirement of The Java Virtual Machine Specification, Second Edition.");
                }
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
        }
    }

    private class CPESSC_Visitor
    extends EmptyVisitor
    implements Visitor {
        private Class CONST_Class;
        private Class CONST_String;
        private Class CONST_Integer;
        private Class CONST_Float;
        private Class CONST_Long;
        private Class CONST_Double;
        private Class CONST_NameAndType;
        private Class CONST_Utf8;
        private final JavaClass jc;
        private final ConstantPool cp;
        private final int cplen;
        private DescendingVisitor carrier;
        private HashSet field_names = new HashSet();
        private HashSet field_names_and_desc = new HashSet();
        private HashSet method_names_and_desc = new HashSet();

        private CPESSC_Visitor(JavaClass javaClass) {
            this.jc = javaClass;
            this.cp = javaClass.getConstantPool();
            this.cplen = this.cp.getLength();
            this.CONST_Class = ConstantClass.class;
            this.CONST_String = ConstantString.class;
            this.CONST_Integer = ConstantInteger.class;
            this.CONST_Float = ConstantFloat.class;
            this.CONST_Long = ConstantLong.class;
            this.CONST_Double = ConstantDouble.class;
            this.CONST_NameAndType = ConstantNameAndType.class;
            this.CONST_Utf8 = ConstantUtf8.class;
            this.carrier = new DescendingVisitor(javaClass, this);
            this.carrier.visit();
        }

        private void checkIndex(Node node, int n, Class clazz) {
            if (n < 0 || n >= this.cplen) {
                throw new ClassConstraintException("Invalid index '" + n + "' used by '" + Pass2Verifier.tostring(node) + "'.");
            }
            Constant constant = this.cp.getConstant(n);
            if (!clazz.isInstance(constant)) {
                throw new ClassCastException("Illegal constant '" + Pass2Verifier.tostring(constant) + "' at index '" + n + "'. '" + Pass2Verifier.tostring(node) + "' expects a '" + clazz + "'.");
            }
        }

        public void visitJavaClass(JavaClass javaClass) {
            Attribute[] attributeArray = javaClass.getAttributes();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = new InnerClassDetector(this.jc).innerClassReferenced();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (!(attributeArray[i] instanceof SourceFile || attributeArray[i] instanceof Deprecated || attributeArray[i] instanceof InnerClasses || attributeArray[i] instanceof Synthetic)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i]) + "' as an attribute of the ClassFile structure '" + Pass2Verifier.tostring(javaClass) + "' is unknown and will therefore be ignored.");
                }
                if (attributeArray[i] instanceof SourceFile) {
                    if (!bl) {
                        bl = true;
                    } else {
                        throw new ClassConstraintException("A ClassFile structure (like '" + Pass2Verifier.tostring(javaClass) + "') may have no more than one SourceFile attribute.");
                    }
                }
                if (!(attributeArray[i] instanceof InnerClasses)) continue;
                if (!bl2) {
                    bl2 = true;
                } else if (bl3) {
                    throw new ClassConstraintException("A Classfile structure (like '" + Pass2Verifier.tostring(javaClass) + "') must have exactly one InnerClasses attribute if at least one Inner Class is referenced (which is the case). More than one InnerClasses attribute was found.");
                }
                if (bl3) continue;
                Pass2Verifier.this.addMessage("No referenced Inner Class found, but InnerClasses attribute '" + Pass2Verifier.tostring(attributeArray[i]) + "' found. Strongly suggest removal of that attribute.");
            }
            if (bl3 && !bl2) {
                Pass2Verifier.this.addMessage("A Classfile structure (like '" + Pass2Verifier.tostring(javaClass) + "') must have exactly one InnerClasses attribute if at least one Inner Class is referenced (which is the case). No InnerClasses attribute was found.");
            }
        }

        public void visitConstantClass(ConstantClass constantClass) {
            if (constantClass.getTag() != 7) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantClass) + "'.");
            }
            this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
        }

        public void visitConstantFieldref(ConstantFieldref constantFieldref) {
            if (constantFieldref.getTag() != 9) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
            this.checkIndex(constantFieldref, constantFieldref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantFieldref, constantFieldref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantMethodref(ConstantMethodref constantMethodref) {
            if (constantMethodref.getTag() != 10) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
            this.checkIndex(constantMethodref, constantMethodref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantMethodref, constantMethodref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
            if (constantInterfaceMethodref.getTag() != 11) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
            this.checkIndex(constantInterfaceMethodref, constantInterfaceMethodref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantInterfaceMethodref, constantInterfaceMethodref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantString(ConstantString constantString) {
            if (constantString.getTag() != 8) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantString) + "'.");
            }
            this.checkIndex(constantString, constantString.getStringIndex(), this.CONST_Utf8);
        }

        public void visitConstantInteger(ConstantInteger constantInteger) {
            if (constantInteger.getTag() != 3) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantInteger) + "'.");
            }
        }

        public void visitConstantFloat(ConstantFloat constantFloat) {
            if (constantFloat.getTag() != 4) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantFloat) + "'.");
            }
        }

        public void visitConstantLong(ConstantLong constantLong) {
            if (constantLong.getTag() != 5) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantLong) + "'.");
            }
        }

        public void visitConstantDouble(ConstantDouble constantDouble) {
            if (constantDouble.getTag() != 6) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantDouble) + "'.");
            }
        }

        public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
            if (constantNameAndType.getTag() != 12) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantNameAndType) + "'.");
            }
            this.checkIndex(constantNameAndType, constantNameAndType.getNameIndex(), this.CONST_Utf8);
            this.checkIndex(constantNameAndType, constantNameAndType.getSignatureIndex(), this.CONST_Utf8);
        }

        public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
            if (constantUtf8.getTag() != 1) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantUtf8) + "'.");
            }
        }

        public void visitField(Field field) {
            if (this.jc.isClass()) {
                int n = 0;
                if (field.isPrivate()) {
                    ++n;
                }
                if (field.isProtected()) {
                    ++n;
                }
                if (field.isPublic()) {
                    ++n;
                }
                if (n > 1) {
                    throw new ClassConstraintException("Field '" + Pass2Verifier.tostring(field) + "' must only have at most one of its ACC_PRIVATE, ACC_PROTECTED, ACC_PUBLIC modifiers set.");
                }
                if (field.isFinal() && field.isVolatile()) {
                    throw new ClassConstraintException("Field '" + Pass2Verifier.tostring(field) + "' must only have at most one of its ACC_FINAL, ACC_VOLATILE modifiers set.");
                }
            } else {
                if (!field.isPublic()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.tostring(field) + "' must have the ACC_PUBLIC modifier set but hasn't!");
                }
                if (!field.isStatic()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.tostring(field) + "' must have the ACC_STATIC modifier set but hasn't!");
                }
                if (!field.isFinal()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.tostring(field) + "' must have the ACC_FINAL modifier set but hasn't!");
                }
            }
            if ((field.getAccessFlags() & 0xFFFFFF20) > 0) {
                Pass2Verifier.this.addMessage("Field '" + Pass2Verifier.tostring(field) + "' has access flag(s) other than ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_VOLATILE, ACC_TRANSIENT set (ignored).");
            }
            this.checkIndex(field, field.getNameIndex(), this.CONST_Utf8);
            String string = field.getName();
            if (!Pass2Verifier.validFieldName(string)) {
                throw new ClassConstraintException("Field '" + Pass2Verifier.tostring(field) + "' has illegal name '" + field.getName() + "'.");
            }
            this.checkIndex(field, field.getSignatureIndex(), this.CONST_Utf8);
            String string2 = ((ConstantUtf8)this.cp.getConstant(field.getSignatureIndex())).getBytes();
            try {
                Type.getType(string2);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string2 + "' used by '" + Pass2Verifier.tostring(field) + "'.");
            }
            String string3 = string + string2;
            if (this.field_names_and_desc.contains(string3)) {
                throw new ClassConstraintException("No two fields (like '" + Pass2Verifier.tostring(field) + "') are allowed have same names and descriptors!");
            }
            if (this.field_names.contains(string)) {
                Pass2Verifier.this.addMessage("More than one field of name '" + string + "' detected (but with different type descriptors). This is very unusual.");
            }
            this.field_names_and_desc.add(string3);
            this.field_names.add(string);
            Attribute[] attributeArray = field.getAttributes();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (!(attributeArray[i] instanceof ConstantValue || attributeArray[i] instanceof Synthetic || attributeArray[i] instanceof Deprecated)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i]) + "' as an attribute of Field '" + Pass2Verifier.tostring(field) + "' is unknown and will therefore be ignored.");
                }
                if (attributeArray[i] instanceof ConstantValue) continue;
                Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i]) + "' as an attribute of Field '" + Pass2Verifier.tostring(field) + "' is not a ConstantValue and is therefore only of use for debuggers and such.");
            }
        }

        public void visitMethod(Method method) {
            String string;
            int n;
            Verifier verifier;
            Attribute[] attributeArray;
            Type[] typeArray;
            Type type;
            this.checkIndex(method, method.getNameIndex(), this.CONST_Utf8);
            String string2 = method.getName();
            if (!Pass2Verifier.validMethodName(string2, true)) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has illegal name '" + string2 + "'.");
            }
            this.checkIndex(method, method.getSignatureIndex(), this.CONST_Utf8);
            String string3 = ((ConstantUtf8)this.cp.getConstant(method.getSignatureIndex())).getBytes();
            try {
                type = Type.getReturnType(string3);
                typeArray = Type.getArgumentTypes(string3);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by Method '" + Pass2Verifier.tostring(method) + "'.");
            }
            Type type2 = type;
            if (type2 instanceof ArrayType) {
                type2 = ((ArrayType)type2).getBasicType();
            }
            if (type2 instanceof ObjectType && (attributeArray = (verifier = VerifierFactory.getVerifier(((ObjectType)type2).getClassName())).doPass1()) != VerificationResult.VR_OK) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has a return type that does not pass verification pass 1: '" + attributeArray + "'.");
            }
            for (n = 0; n < typeArray.length; ++n) {
                VerificationResult verificationResult;
                type2 = typeArray[n];
                if (type2 instanceof ArrayType) {
                    type2 = ((ArrayType)type2).getBasicType();
                }
                if (!(type2 instanceof ObjectType) || (verificationResult = (attributeArray = VerifierFactory.getVerifier(((ObjectType)type2).getClassName())).doPass1()) == VerificationResult.VR_OK) continue;
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has an argument type that does not pass verification pass 1: '" + verificationResult + "'.");
            }
            if (string2.equals("<clinit>") && typeArray.length != 0) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has illegal name '" + string2 + "'. It's name resembles the class or interface initialization method which it isn't because of its arguments (==descriptor).");
            }
            if (this.jc.isClass()) {
                n = 0;
                if (method.isPrivate()) {
                    ++n;
                }
                if (method.isProtected()) {
                    ++n;
                }
                if (method.isPublic()) {
                    ++n;
                }
                if (n > 1) {
                    throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' must only have at most one of its ACC_PRIVATE, ACC_PROTECTED, ACC_PUBLIC modifiers set.");
                }
                if (method.isAbstract()) {
                    if (method.isFinal()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_FINAL modifier set.");
                    }
                    if (method.isNative()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_NATIVE modifier set.");
                    }
                    if (method.isPrivate()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_PRIVATE modifier set.");
                    }
                    if (method.isStatic()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_STATIC modifier set.");
                    }
                    if (method.isStrictfp()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_STRICT modifier set.");
                    }
                    if (method.isSynchronized()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_SYNCHRONIZED modifier set.");
                    }
                }
            } else if (!string2.equals("<clinit>")) {
                if (!method.isPublic()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.tostring(method) + "' must have the ACC_PUBLIC modifier set but hasn't!");
                }
                if (!method.isAbstract()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.tostring(method) + "' must have the ACC_STATIC modifier set but hasn't!");
                }
                if (method.isPrivate() || method.isProtected() || method.isStatic() || method.isFinal() || method.isSynchronized() || method.isNative() || method.isStrictfp()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.tostring(method) + "' must not have any of the ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT, ACC_STRICT modifiers set.");
                }
            }
            if (string2.equals("<init>") && (method.isStatic() || method.isFinal() || method.isSynchronized() || method.isNative() || method.isAbstract())) {
                throw new ClassConstraintException("Instance initialization method '" + Pass2Verifier.tostring(method) + "' must not have any of the ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT modifiers set.");
            }
            if (string2.equals("<clinit>")) {
                if ((method.getAccessFlags() & 0xFFFFF7FF) > 0) {
                    Pass2Verifier.this.addMessage("Class or interface initialization method '" + Pass2Verifier.tostring(method) + "' has superfluous access modifier(s) set: everything but ACC_STRICT is ignored.");
                }
                if (method.isAbstract()) {
                    throw new ClassConstraintException("Class or interface initialization method '" + Pass2Verifier.tostring(method) + "' must not be abstract. This contradicts the Java Language Specification, Second Edition (which omits this constraint) but is common practice of existing verifiers.");
                }
            }
            if ((method.getAccessFlags() & 0xFFFFF2C0) > 0) {
                Pass2Verifier.this.addMessage("Method '" + Pass2Verifier.tostring(method) + "' has access flag(s) other than ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT, ACC_STRICT set (ignored).");
            }
            if (this.method_names_and_desc.contains(string = string2 + string3)) {
                throw new ClassConstraintException("No two methods (like '" + Pass2Verifier.tostring(method) + "') are allowed have same names and desciptors!");
            }
            this.method_names_and_desc.add(string);
            attributeArray = method.getAttributes();
            int n2 = 0;
            for (int i = 0; i < attributeArray.length; ++i) {
                if (!(attributeArray[i] instanceof Code || attributeArray[i] instanceof ExceptionTable || attributeArray[i] instanceof Synthetic || attributeArray[i] instanceof Deprecated)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i]) + "' as an attribute of Method '" + Pass2Verifier.tostring(method) + "' is unknown and will therefore be ignored.");
                }
                if (!(attributeArray[i] instanceof Code) && !(attributeArray[i] instanceof ExceptionTable)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i]) + "' as an attribute of Method '" + Pass2Verifier.tostring(method) + "' is neither Code nor Exceptions and is therefore only of use for debuggers and such.");
                }
                if (attributeArray[i] instanceof Code && (method.isNative() || method.isAbstract())) {
                    throw new ClassConstraintException("Native or abstract methods like '" + Pass2Verifier.tostring(method) + "' must not have a Code attribute like '" + Pass2Verifier.tostring(attributeArray[i]) + "'.");
                }
                if (!(attributeArray[i] instanceof Code)) continue;
                ++n2;
            }
            if (!method.isNative() && !method.isAbstract() && n2 != 1) {
                throw new ClassConstraintException("Non-native, non-abstract methods like '" + Pass2Verifier.tostring(method) + "' must have exactly one Code attribute (found: " + n2 + ").");
            }
        }

        public void visitSourceFile(SourceFile sourceFile) {
            this.checkIndex(sourceFile, sourceFile.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(sourceFile.getNameIndex())).getBytes();
            if (!string.equals("SourceFile")) {
                throw new ClassConstraintException("The SourceFile attribute '" + Pass2Verifier.tostring(sourceFile) + "' is not correctly named 'SourceFile' but '" + string + "'.");
            }
            this.checkIndex(sourceFile, sourceFile.getSourceFileIndex(), this.CONST_Utf8);
            String string2 = ((ConstantUtf8)this.cp.getConstant(sourceFile.getSourceFileIndex())).getBytes();
            String string3 = string2.toLowerCase();
            if (string2.indexOf(47) != -1 || string2.indexOf(92) != -1 || string2.indexOf(58) != -1 || string3.lastIndexOf(".java") == -1) {
                Pass2Verifier.this.addMessage("SourceFile attribute '" + Pass2Verifier.tostring(sourceFile) + "' has a funny name: remember not to confuse certain parsers working on javap's output. Also, this name ('" + string2 + "') is considered an unqualified (simple) file name only.");
            }
        }

        public void visitDeprecated(Deprecated deprecated) {
            this.checkIndex(deprecated, deprecated.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(deprecated.getNameIndex())).getBytes();
            if (!string.equals("Deprecated")) {
                throw new ClassConstraintException("The Deprecated attribute '" + Pass2Verifier.tostring(deprecated) + "' is not correctly named 'Deprecated' but '" + string + "'.");
            }
        }

        public void visitSynthetic(Synthetic synthetic) {
            this.checkIndex(synthetic, synthetic.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(synthetic.getNameIndex())).getBytes();
            if (!string.equals("Synthetic")) {
                throw new ClassConstraintException("The Synthetic attribute '" + Pass2Verifier.tostring(synthetic) + "' is not correctly named 'Synthetic' but '" + string + "'.");
            }
        }

        public void visitInnerClasses(InnerClasses innerClasses) {
            this.checkIndex(innerClasses, innerClasses.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(innerClasses.getNameIndex())).getBytes();
            if (!string.equals("InnerClasses")) {
                throw new ClassConstraintException("The InnerClasses attribute '" + Pass2Verifier.tostring(innerClasses) + "' is not correctly named 'InnerClasses' but '" + string + "'.");
            }
            InnerClass[] innerClassArray = innerClasses.getInnerClasses();
            for (int i = 0; i < innerClassArray.length; ++i) {
                int n;
                this.checkIndex(innerClasses, innerClassArray[i].getInnerClassIndex(), this.CONST_Class);
                int n2 = innerClassArray[i].getOuterClassIndex();
                if (n2 != 0) {
                    this.checkIndex(innerClasses, n2, this.CONST_Class);
                }
                if ((n = innerClassArray[i].getInnerNameIndex()) != 0) {
                    this.checkIndex(innerClasses, n, this.CONST_Utf8);
                }
                int n3 = innerClassArray[i].getInnerAccessFlags();
                if ((n3 &= 0xFFFFF9E0) == 0) continue;
                Pass2Verifier.this.addMessage("Unknown access flag for inner class '" + Pass2Verifier.tostring(innerClassArray[i]) + "' set (InnerClasses attribute '" + Pass2Verifier.tostring(innerClasses) + "').");
            }
        }

        public void visitConstantValue(ConstantValue constantValue) {
            this.checkIndex(constantValue, constantValue.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(constantValue.getNameIndex())).getBytes();
            if (!string.equals("ConstantValue")) {
                throw new ClassConstraintException("The ConstantValue attribute '" + Pass2Verifier.tostring(constantValue) + "' is not correctly named 'ConstantValue' but '" + string + "'.");
            }
            Object object = this.carrier.predecessor();
            if (object instanceof Field) {
                Field field = (Field)object;
                Type type = Type.getType(((ConstantUtf8)this.cp.getConstant(field.getSignatureIndex())).getBytes());
                int n = constantValue.getConstantValueIndex();
                if (n < 0 || n >= this.cplen) {
                    throw new ClassConstraintException("Invalid index '" + n + "' used by '" + Pass2Verifier.tostring(constantValue) + "'.");
                }
                Constant constant = this.cp.getConstant(n);
                if (this.CONST_Long.isInstance(constant) && type.equals(Type.LONG)) {
                    return;
                }
                if (this.CONST_Float.isInstance(constant) && type.equals(Type.FLOAT)) {
                    return;
                }
                if (this.CONST_Double.isInstance(constant) && type.equals(Type.DOUBLE)) {
                    return;
                }
                if (this.CONST_Integer.isInstance(constant) && (type.equals(Type.INT) || type.equals(Type.SHORT) || type.equals(Type.CHAR) || type.equals(Type.BYTE) || type.equals(Type.BOOLEAN))) {
                    return;
                }
                if (this.CONST_String.isInstance(constant) && type.equals(Type.STRING)) {
                    return;
                }
                throw new ClassConstraintException("Illegal type of ConstantValue '" + constantValue + "' embedding Constant '" + constant + "'. It is referenced by field '" + Pass2Verifier.tostring(field) + "' expecting a different type: '" + type + "'.");
            }
        }

        public void visitCode(Code code) {
            int n;
            LocalVariable[] localVariableArray;
            Node node;
            Object object;
            Object object2;
            Object object3;
            int n2;
            this.checkIndex(code, code.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(code.getNameIndex())).getBytes();
            if (!string.equals("Code")) {
                throw new ClassConstraintException("The Code attribute '" + Pass2Verifier.tostring(code) + "' is not correctly named 'Code' but '" + string + "'.");
            }
            Method method = null;
            if (!(this.carrier.predecessor() instanceof Method)) {
                Pass2Verifier.this.addMessage("Code attribute '" + Pass2Verifier.tostring(code) + "' is not declared in a method_info structure but in '" + this.carrier.predecessor() + "'. Ignored.");
                return;
            }
            method = (Method)this.carrier.predecessor();
            if (code.getCode().length == 0) {
                throw new ClassConstraintException("Code array of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') must not be empty.");
            }
            CodeException[] codeExceptionArray = code.getExceptionTable();
            for (n2 = 0; n2 < codeExceptionArray.length; ++n2) {
                int n3 = codeExceptionArray[n2].getCatchType();
                if (n3 == 0) continue;
                this.checkIndex(code, n3, this.CONST_Class);
                ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n3);
                this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
                object3 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes().replace('/', '.');
                Verifier verifier = VerifierFactory.getVerifier((String)object3);
                object2 = verifier.doPass1();
                if (object2 != VerificationResult.VR_OK) {
                    throw new ClassConstraintException("Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.tostring(codeExceptionArray[n2]) + "' that references '" + (String)object3 + "' as an Exception but it does not pass verification pass 1: " + object2);
                }
                object = Repository.lookupClass((String)object3);
                node = Repository.lookupClass(Type.THROWABLE.getClassName());
                localVariableArray = Repository.lookupClass(Type.OBJECT.getClassName());
                while (object != localVariableArray && object != node) {
                    verifier = VerifierFactory.getVerifier(((JavaClass)object).getSuperclassName());
                    object2 = verifier.doPass1();
                    if (object2 != VerificationResult.VR_OK) {
                        throw new ClassConstraintException("Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.tostring(codeExceptionArray[n2]) + "' that references '" + (String)object3 + "' as an Exception but '" + ((JavaClass)object).getSuperclassName() + "' in the ancestor hierachy does not pass verification pass 1: " + object2);
                    }
                    object = Repository.lookupClass(((JavaClass)object).getSuperclassName());
                }
                if (object == node) continue;
                throw new ClassConstraintException("Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.tostring(codeExceptionArray[n2]) + "' that references '" + (String)object3 + "' as an Exception but it is not a subclass of '" + ((JavaClass)node).getClassName() + "'.");
            }
            n2 = -1;
            Method[] methodArray = Repository.lookupClass(Pass2Verifier.this.myOwner.getClassName()).getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (method != methodArray[n]) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                throw new AssertionViolatedException("Could not find a known BCEL Method object in the corresponding BCEL JavaClass object.");
            }
            ((Pass2Verifier)Pass2Verifier.this).localVariablesInfos[n2] = new LocalVariablesInfo(code.getMaxLocals());
            n = 0;
            object3 = code.getAttributes();
            for (int i = 0; i < ((Attribute[])object3).length; ++i) {
                if (!(object3[i] instanceof LineNumberTable) && !(object3[i] instanceof LocalVariableTable)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(object3[i]) + "' as an attribute of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') is unknown and will therefore be ignored.");
                } else {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(object3[i]) + "' as an attribute of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') will effectively be ignored and is only useful for debuggers and such.");
                }
                if (!(object3[i] instanceof LocalVariableTable)) continue;
                object2 = (LocalVariableTable)object3[i];
                this.checkIndex((Node)object2, ((Attribute)object2).getNameIndex(), this.CONST_Utf8);
                object = ((ConstantUtf8)this.cp.getConstant(((Attribute)object2).getNameIndex())).getBytes();
                if (!((String)object).equals("LocalVariableTable")) {
                    throw new ClassConstraintException("The LocalVariableTable attribute '" + Pass2Verifier.tostring((Node)object2) + "' is not correctly named 'LocalVariableTable' but '" + (String)object + "'.");
                }
                node = code;
                localVariableArray = ((LocalVariableTable)object2).getLocalVariableTable();
                for (int j = 0; j < localVariableArray.length; ++j) {
                    Type type;
                    this.checkIndex((Node)object2, localVariableArray[j].getNameIndex(), this.CONST_Utf8);
                    String string2 = ((ConstantUtf8)this.cp.getConstant(localVariableArray[j].getNameIndex())).getBytes();
                    if (!Pass2Verifier.validJavaIdentifier(string2)) {
                        throw new ClassConstraintException("LocalVariableTable '" + Pass2Verifier.tostring((Node)object2) + "' references a local variable by the name '" + string2 + "' which is not a legal Java simple name.");
                    }
                    this.checkIndex((Node)object2, localVariableArray[j].getSignatureIndex(), this.CONST_Utf8);
                    String string3 = ((ConstantUtf8)this.cp.getConstant(localVariableArray[j].getSignatureIndex())).getBytes();
                    try {
                        type = Type.getType(string3);
                    }
                    catch (ClassFormatError classFormatError) {
                        throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by LocalVariable '" + Pass2Verifier.tostring(localVariableArray[j]) + "' referenced by '" + Pass2Verifier.tostring((Node)object2) + "'.");
                    }
                    int n4 = localVariableArray[j].getIndex();
                    if ((type == Type.LONG || type == Type.DOUBLE ? n4 + 1 : n4) >= ((Code)node).getMaxLocals()) {
                        throw new ClassConstraintException("LocalVariableTable attribute '" + Pass2Verifier.tostring((Node)object2) + "' references a LocalVariable '" + Pass2Verifier.tostring(localVariableArray[j]) + "' with an index that exceeds the surrounding Code attribute's max_locals value of '" + ((Code)node).getMaxLocals() + "'.");
                    }
                    try {
                        Pass2Verifier.this.localVariablesInfos[n2].add(n4, string2, localVariableArray[j].getStartPC(), localVariableArray[j].getLength(), type);
                        continue;
                    }
                    catch (LocalVariableInfoInconsistentException localVariableInfoInconsistentException) {
                        throw new ClassConstraintException("Conflicting information in LocalVariableTable '" + Pass2Verifier.tostring((Node)object2) + "' found in Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + Pass2Verifier.tostring(method) + "'). " + localVariableInfoInconsistentException.getMessage());
                    }
                }
                if (++n <= code.getMaxLocals()) continue;
                throw new ClassConstraintException("Number of LocalVariableTable attributes of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + Pass2Verifier.tostring(method) + "') exceeds number of local variable slots '" + code.getMaxLocals() + "' ('There may be no more than one LocalVariableTable attribute per local variable in the Code attribute.').");
            }
        }

        public void visitExceptionTable(ExceptionTable exceptionTable) {
            this.checkIndex(exceptionTable, exceptionTable.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(exceptionTable.getNameIndex())).getBytes();
            if (!string.equals("Exceptions")) {
                throw new ClassConstraintException("The Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' is not correctly named 'Exceptions' but '" + string + "'.");
            }
            int[] nArray = exceptionTable.getExceptionIndexTable();
            for (int i = 0; i < nArray.length; ++i) {
                this.checkIndex(exceptionTable, nArray[i], this.CONST_Class);
                ConstantClass constantClass = (ConstantClass)this.cp.getConstant(nArray[i]);
                this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
                String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes().replace('/', '.');
                Verifier verifier = VerifierFactory.getVerifier(string2);
                VerificationResult verificationResult = verifier.doPass1();
                if (verificationResult != VerificationResult.VR_OK) {
                    throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' references '" + string2 + "' as an Exception but it does not pass verification pass 1: " + verificationResult);
                }
                JavaClass javaClass = Repository.lookupClass(string2);
                JavaClass javaClass2 = Repository.lookupClass(Type.THROWABLE.getClassName());
                JavaClass javaClass3 = Repository.lookupClass(Type.OBJECT.getClassName());
                while (javaClass != javaClass3 && javaClass != javaClass2) {
                    verifier = VerifierFactory.getVerifier(javaClass.getSuperclassName());
                    verificationResult = verifier.doPass1();
                    if (verificationResult != VerificationResult.VR_OK) {
                        throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' references '" + string2 + "' as an Exception but '" + javaClass.getSuperclassName() + "' in the ancestor hierachy does not pass verification pass 1: " + verificationResult);
                    }
                    javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                }
                if (javaClass == javaClass2) continue;
                throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' references '" + string2 + "' as an Exception but it is not a subclass of '" + javaClass2.getClassName() + "'.");
            }
        }

        public void visitLineNumberTable(LineNumberTable lineNumberTable) {
            this.checkIndex(lineNumberTable, lineNumberTable.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(lineNumberTable.getNameIndex())).getBytes();
            if (!string.equals("LineNumberTable")) {
                throw new ClassConstraintException("The LineNumberTable attribute '" + Pass2Verifier.tostring(lineNumberTable) + "' is not correctly named 'LineNumberTable' but '" + string + "'.");
            }
        }

        public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        }

        public void visitUnknown(Unknown unknown) {
            this.checkIndex(unknown, unknown.getNameIndex(), this.CONST_Utf8);
            Pass2Verifier.this.addMessage("Unknown attribute '" + Pass2Verifier.tostring(unknown) + "'. This attribute is not known in any context!");
        }

        public void visitLocalVariable(LocalVariable localVariable) {
        }

        public void visitCodeException(CodeException codeException) {
        }

        public void visitConstantPool(ConstantPool constantPool) {
        }

        public void visitInnerClass(InnerClass innerClass) {
        }

        public void visitLineNumber(LineNumber lineNumber) {
        }
    }
}

