/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int n) {
        this.locals = new Type[n];
        for (int i = 0; i < n; ++i) {
            this.locals[i] = Type.UNKNOWN;
        }
    }

    protected Object clone() {
        LocalVariables localVariables = new LocalVariables(this.locals.length);
        for (int i = 0; i < this.locals.length; ++i) {
            localVariables.locals[i] = this.locals[i];
        }
        return localVariables;
    }

    public Type get(int n) {
        return this.locals[n];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int n, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[n] = type;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalVariables)) {
            return false;
        }
        LocalVariables localVariables = (LocalVariables)object;
        if (this.locals.length != localVariables.locals.length) {
            return false;
        }
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i].equals(localVariables.locals[i])) continue;
            return false;
        }
        return true;
    }

    public void merge(LocalVariables localVariables) {
        if (this.locals.length != localVariables.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i = 0; i < this.locals.length; ++i) {
            this.merge(localVariables, i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(LocalVariables localVariables, int n) {
        if (!(this.locals[n] instanceof UninitializedObjectType) && localVariables.locals[n] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (!this.locals[n].equals(localVariables.locals[n]) && this.locals[n] instanceof UninitializedObjectType && localVariables.locals[n] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (this.locals[n] instanceof UninitializedObjectType && !(localVariables.locals[n] instanceof UninitializedObjectType)) {
            this.locals[n] = ((UninitializedObjectType)this.locals[n]).getInitialized();
        }
        if (this.locals[n] instanceof ReferenceType && localVariables.locals[n] instanceof ReferenceType) {
            if (this.locals[n].equals(localVariables.locals[n])) return;
            ReferenceType referenceType = ((ReferenceType)this.locals[n]).getFirstCommonSuperclass((ReferenceType)localVariables.locals[n]);
            if (referenceType == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[n] + "' and '" + localVariables.locals[n] + "'.");
            this.locals[n] = referenceType;
            return;
        } else {
            if (this.locals[n].equals(localVariables.locals[n])) return;
            this.locals[n] = Type.UNKNOWN;
        }
    }

    public String toString() {
        String string = new String();
        for (int i = 0; i < this.locals.length; ++i) {
            string = string + Integer.toString(i) + ": " + this.locals[i] + "\n";
        }
        return string;
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != uninitializedObjectType) continue;
            this.locals[i] = uninitializedObjectType.getInitialized();
        }
    }
}

