/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.commons.codec.net.RFC1522Codec;

public class QCodec
extends RFC1522Codec
implements StringEncoder,
StringDecoder {
    private String charset = "UTF-8";
    private static final BitSet PRINTABLE_CHARS;
    private static byte BLANK;
    private static byte UNDERSCORE;
    private boolean encodeBlanks = false;

    public QCodec() {
    }

    public QCodec(String string) {
        this.charset = string;
    }

    protected String getEncoding() {
        return "Q";
    }

    protected byte[] doEncoding(byte[] byArray) throws EncoderException {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray);
        if (this.encodeBlanks) {
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != BLANK) continue;
                byArray2[i] = UNDERSCORE;
            }
        }
        return byArray2;
    }

    protected byte[] doDecoding(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != UNDERSCORE) continue;
            bl = true;
            break;
        }
        if (bl) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                byArray2[i] = by != UNDERSCORE ? by : BLANK;
            }
            return QuotedPrintableCodec.decodeQuotedPrintable(byArray2);
        }
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    public String encode(String string, String string2) throws EncoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.encodeText(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncoderException(unsupportedEncodingException.getMessage());
        }
    }

    public String encode(String string) throws EncoderException {
        if (string == null) {
            return null;
        }
        return this.encode(string, this.getDefaultCharset());
    }

    public String decode(String string) throws DecoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DecoderException(unsupportedEncodingException.getMessage());
        }
    }

    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be encoded using Q codec");
    }

    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be decoded using Q codec");
    }

    public String getDefaultCharset() {
        return this.charset;
    }

    public boolean isEncodeBlanks() {
        return this.encodeBlanks;
    }

    public void setEncodeBlanks(boolean bl) {
        this.encodeBlanks = bl;
    }

    static {
        int n;
        PRINTABLE_CHARS = new BitSet(256);
        PRINTABLE_CHARS.set(32);
        PRINTABLE_CHARS.set(33);
        PRINTABLE_CHARS.set(34);
        PRINTABLE_CHARS.set(35);
        PRINTABLE_CHARS.set(36);
        PRINTABLE_CHARS.set(37);
        PRINTABLE_CHARS.set(38);
        PRINTABLE_CHARS.set(39);
        PRINTABLE_CHARS.set(40);
        PRINTABLE_CHARS.set(41);
        PRINTABLE_CHARS.set(42);
        PRINTABLE_CHARS.set(43);
        PRINTABLE_CHARS.set(44);
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(47);
        for (n = 48; n <= 57; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(58);
        PRINTABLE_CHARS.set(59);
        PRINTABLE_CHARS.set(60);
        PRINTABLE_CHARS.set(62);
        PRINTABLE_CHARS.set(64);
        for (n = 65; n <= 90; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(91);
        PRINTABLE_CHARS.set(92);
        PRINTABLE_CHARS.set(93);
        PRINTABLE_CHARS.set(94);
        PRINTABLE_CHARS.set(96);
        for (n = 97; n <= 122; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(123);
        PRINTABLE_CHARS.set(124);
        PRINTABLE_CHARS.set(125);
        PRINTABLE_CHARS.set(126);
        BLANK = (byte)32;
        UNDERSCORE = (byte)95;
    }
}

