/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceDiscover;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.DiscoverResources;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverNamesInFile
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverNamesInFile.class);
    private ResourceDiscover discoverResources;

    public static void setLog(Log log) {
        DiscoverNamesInFile.log = log;
    }

    public DiscoverNamesInFile() {
        this.discoverResources = new DiscoverResources();
    }

    public DiscoverNamesInFile(ClassLoaders classLoaders) {
        this.discoverResources = new DiscoverResources(classLoaders);
    }

    public DiscoverNamesInFile(ResourceDiscover resourceDiscover) {
        this.discoverResources = resourceDiscover;
    }

    public void setDiscoverer(ResourceDiscover resourceDiscover) {
        this.discoverResources = resourceDiscover;
    }

    public ResourceDiscover getDiscover() {
        return this.discoverResources;
    }

    public ResourceNameIterator findResourceNames(final String string) {
        if (log.isDebugEnabled()) {
            log.debug("find: fileName='" + string + "'");
        }
        return new ResourceNameIterator(){
            private ResourceIterator files;
            private int idx;
            private Vector classNames;
            private String resource;
            {
                this.files = DiscoverNamesInFile.this.getDiscover().findResources(string);
                this.idx = 0;
                this.classNames = null;
                this.resource = null;
            }

            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextClassName();
                }
                return this.resource != null;
            }

            public String nextResourceName() {
                String string2 = this.resource;
                this.resource = null;
                return string2;
            }

            private String getNextClassName() {
                if (this.classNames == null || this.idx >= this.classNames.size()) {
                    this.classNames = this.getNextClassNames();
                    this.idx = 0;
                    if (this.classNames == null) {
                        return null;
                    }
                }
                String string2 = (String)this.classNames.get(this.idx++);
                if (log.isDebugEnabled()) {
                    log.debug("getNextClassResource: next class='" + string2 + "'");
                }
                return string2;
            }

            private Vector getNextClassNames() {
                while (this.files.hasNext()) {
                    Vector vector = DiscoverNamesInFile.this.readServices(this.files.nextResource());
                    if (vector == null || vector.size() <= 0) continue;
                    return vector;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector readServices(Resource resource) {
        Vector<String> vector = new Vector<String>();
        InputStream inputStream = resource.getResourceAsStream();
        if (inputStream != null) {
            try {
                try {
                    BufferedReader bufferedReader;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    }
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            int n = string.indexOf(35);
                            if (n >= 0) {
                                string = string.substring(0, n);
                            }
                            if ((string = string.trim()).length() == 0) continue;
                            vector.add(string);
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return vector;
    }
}

