/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.discovery.DiscoveryException;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.logging.Log;

public class ClassUtils {
    private static Log log = DiscoveryLogFactory.newLog(ClassUtils.class);

    public static void setLog(Log log) {
        ClassUtils.log = log;
    }

    public static String getPackageName(Class clazz) {
        String string;
        Package package_ = clazz.getPackage();
        if (package_ != null) {
            string = package_.getName();
        } else {
            String string2 = clazz.getName();
            string = string2.substring(0, string2.lastIndexOf(46));
        }
        return string;
    }

    public static Method findPublicStaticMethod(Class clazz, Class clazz2, String string, Class[] classArray) {
        boolean bl = false;
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
            if (log != null) {
                log.debug("Class " + clazz.getName() + ": missing method '" + string + "(...)", noSuchMethodException);
            }
            System.err.println("Class " + clazz.getName() + ": missing method '" + string + "(...)");
            noSuchMethodException.printStackTrace();
            System.err.println("[Message redirected to stderr because no log could be initialized] ");
        }
        if (!(bl || Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) && method.getReturnType() == clazz2)) {
            if (log.isDebugEnabled()) {
                if (!Modifier.isPublic(method.getModifiers())) {
                    log.debug(string + "() is not public");
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    log.debug(string + "() is not static");
                }
                if (method.getReturnType() != clazz2) {
                    log.debug("Method returns: " + method.getReturnType().getName() + "@@" + method.getReturnType().getClassLoader());
                    log.debug("Should return:  " + clazz2.getName() + "@@" + clazz2.getClassLoader());
                }
            }
            bl = true;
            method = null;
        }
        return method;
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (classArray == null || objectArray == null) {
            return clazz.newInstance();
        }
        Constructor constructor = clazz.getConstructor(classArray);
        return constructor.newInstance(objectArray);
    }

    public static void verifyAncestory(Class clazz, Class clazz2) throws DiscoveryException {
        if (clazz == null) {
            throw new DiscoveryException("No interface defined!");
        }
        if (clazz2 == null) {
            throw new DiscoveryException("No implementation defined for " + clazz.getName());
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new DiscoveryException("Class " + clazz2.getName() + " does not implement " + clazz.getName());
        }
    }
}

