/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Logger;

public final class Log4jFactory
extends LogFactory {
    private Hashtable attributes = new Hashtable();
    private Hashtable instances = new Hashtable();

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        Log log = (Log)this.instances.get(clazz);
        if (log != null) {
            return log;
        }
        log = new Log4JLogger(Logger.getLogger(clazz));
        this.instances.put(clazz, log);
        return log;
    }

    public Log getInstance(String string) throws LogConfigurationException {
        Log log = (Log)this.instances.get(string);
        if (log != null) {
            return log;
        }
        log = new Log4JLogger(Logger.getLogger(string));
        this.instances.put(string, log);
        return log;
    }

    public void release() {
        this.instances.clear();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }
}

